/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecr.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetDownloadUrlForLayerResponse extends EcrResponse implements
        ToCopyableBuilder<GetDownloadUrlForLayerResponse.Builder, GetDownloadUrlForLayerResponse> {
    private static final SdkField<String> DOWNLOAD_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetDownloadUrlForLayerResponse::downloadUrl)).setter(setter(Builder::downloadUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("downloadUrl").build()).build();

    private static final SdkField<String> LAYER_DIGEST_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetDownloadUrlForLayerResponse::layerDigest)).setter(setter(Builder::layerDigest))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("layerDigest").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOWNLOAD_URL_FIELD,
            LAYER_DIGEST_FIELD));

    private final String downloadUrl;

    private final String layerDigest;

    private GetDownloadUrlForLayerResponse(BuilderImpl builder) {
        super(builder);
        this.downloadUrl = builder.downloadUrl;
        this.layerDigest = builder.layerDigest;
    }

    /**
     * <p>
     * The pre-signed Amazon S3 download URL for the requested layer.
     * </p>
     * 
     * @return The pre-signed Amazon S3 download URL for the requested layer.
     */
    public String downloadUrl() {
        return downloadUrl;
    }

    /**
     * <p>
     * The digest of the image layer to download.
     * </p>
     * 
     * @return The digest of the image layer to download.
     */
    public String layerDigest() {
        return layerDigest;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(downloadUrl());
        hashCode = 31 * hashCode + Objects.hashCode(layerDigest());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDownloadUrlForLayerResponse)) {
            return false;
        }
        GetDownloadUrlForLayerResponse other = (GetDownloadUrlForLayerResponse) obj;
        return Objects.equals(downloadUrl(), other.downloadUrl()) && Objects.equals(layerDigest(), other.layerDigest());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetDownloadUrlForLayerResponse").add("DownloadUrl", downloadUrl())
                .add("LayerDigest", layerDigest()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "downloadUrl":
            return Optional.ofNullable(clazz.cast(downloadUrl()));
        case "layerDigest":
            return Optional.ofNullable(clazz.cast(layerDigest()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetDownloadUrlForLayerResponse, T> g) {
        return obj -> g.apply((GetDownloadUrlForLayerResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EcrResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetDownloadUrlForLayerResponse> {
        /**
         * <p>
         * The pre-signed Amazon S3 download URL for the requested layer.
         * </p>
         * 
         * @param downloadUrl
         *        The pre-signed Amazon S3 download URL for the requested layer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder downloadUrl(String downloadUrl);

        /**
         * <p>
         * The digest of the image layer to download.
         * </p>
         * 
         * @param layerDigest
         *        The digest of the image layer to download.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder layerDigest(String layerDigest);
    }

    static final class BuilderImpl extends EcrResponse.BuilderImpl implements Builder {
        private String downloadUrl;

        private String layerDigest;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDownloadUrlForLayerResponse model) {
            super(model);
            downloadUrl(model.downloadUrl);
            layerDigest(model.layerDigest);
        }

        public final String getDownloadUrl() {
            return downloadUrl;
        }

        @Override
        public final Builder downloadUrl(String downloadUrl) {
            this.downloadUrl = downloadUrl;
            return this;
        }

        public final void setDownloadUrl(String downloadUrl) {
            this.downloadUrl = downloadUrl;
        }

        public final String getLayerDigest() {
            return layerDigest;
        }

        @Override
        public final Builder layerDigest(String layerDigest) {
            this.layerDigest = layerDigest;
            return this;
        }

        public final void setLayerDigest(String layerDigest) {
            this.layerDigest = layerDigest;
        }

        @Override
        public GetDownloadUrlForLayerResponse build() {
            return new GetDownloadUrlForLayerResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
