/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecr.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.ecr.model.FindingSeverity;
import software.amazon.awssdk.services.ecr.model.FindingSeverityCountsCopier;
import software.amazon.awssdk.services.ecr.model.ImageScanFinding;
import software.amazon.awssdk.services.ecr.model.ImageScanFindingListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ImageScanFindings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ImageScanFindings> {
    private static final SdkField<Instant> IMAGE_SCAN_COMPLETED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(ImageScanFindings.getter(ImageScanFindings::imageScanCompletedAt)).setter(ImageScanFindings.setter(Builder::imageScanCompletedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageScanCompletedAt").build()}).build();
    private static final SdkField<Instant> VULNERABILITY_SOURCE_UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(ImageScanFindings.getter(ImageScanFindings::vulnerabilitySourceUpdatedAt)).setter(ImageScanFindings.setter(Builder::vulnerabilitySourceUpdatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vulnerabilitySourceUpdatedAt").build()}).build();
    private static final SdkField<List<ImageScanFinding>> FINDINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ImageScanFindings.getter(ImageScanFindings::findings)).setter(ImageScanFindings.setter(Builder::findings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("findings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ImageScanFinding::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Map<String, Integer>> FINDING_SEVERITY_COUNTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(ImageScanFindings.getter(ImageScanFindings::findingSeverityCountsAsStrings)).setter(ImageScanFindings.setter(Builder::findingSeverityCountsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("findingSeverityCounts").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.INTEGER).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMAGE_SCAN_COMPLETED_AT_FIELD, VULNERABILITY_SOURCE_UPDATED_AT_FIELD, FINDINGS_FIELD, FINDING_SEVERITY_COUNTS_FIELD));
    private static final long serialVersionUID = 1L;
    private final Instant imageScanCompletedAt;
    private final Instant vulnerabilitySourceUpdatedAt;
    private final List<ImageScanFinding> findings;
    private final Map<String, Integer> findingSeverityCounts;

    private ImageScanFindings(BuilderImpl builder) {
        this.imageScanCompletedAt = builder.imageScanCompletedAt;
        this.vulnerabilitySourceUpdatedAt = builder.vulnerabilitySourceUpdatedAt;
        this.findings = builder.findings;
        this.findingSeverityCounts = builder.findingSeverityCounts;
    }

    public Instant imageScanCompletedAt() {
        return this.imageScanCompletedAt;
    }

    public Instant vulnerabilitySourceUpdatedAt() {
        return this.vulnerabilitySourceUpdatedAt;
    }

    public boolean hasFindings() {
        return this.findings != null && !(this.findings instanceof SdkAutoConstructList);
    }

    public List<ImageScanFinding> findings() {
        return this.findings;
    }

    public Map<FindingSeverity, Integer> findingSeverityCounts() {
        return FindingSeverityCountsCopier.copyStringToEnum(this.findingSeverityCounts);
    }

    public boolean hasFindingSeverityCounts() {
        return this.findingSeverityCounts != null && !(this.findingSeverityCounts instanceof SdkAutoConstructMap);
    }

    public Map<String, Integer> findingSeverityCountsAsStrings() {
        return this.findingSeverityCounts;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.imageScanCompletedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.vulnerabilitySourceUpdatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.findings());
        hashCode = 31 * hashCode + Objects.hashCode(this.findingSeverityCountsAsStrings());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImageScanFindings)) {
            return false;
        }
        ImageScanFindings other = (ImageScanFindings)obj;
        return Objects.equals(this.imageScanCompletedAt(), other.imageScanCompletedAt()) && Objects.equals(this.vulnerabilitySourceUpdatedAt(), other.vulnerabilitySourceUpdatedAt()) && Objects.equals(this.findings(), other.findings()) && Objects.equals(this.findingSeverityCountsAsStrings(), other.findingSeverityCountsAsStrings());
    }

    public String toString() {
        return ToString.builder((String)"ImageScanFindings").add("ImageScanCompletedAt", (Object)this.imageScanCompletedAt()).add("VulnerabilitySourceUpdatedAt", (Object)this.vulnerabilitySourceUpdatedAt()).add("Findings", this.findings()).add("FindingSeverityCounts", this.findingSeverityCountsAsStrings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "imageScanCompletedAt": {
                return Optional.ofNullable(clazz.cast(this.imageScanCompletedAt()));
            }
            case "vulnerabilitySourceUpdatedAt": {
                return Optional.ofNullable(clazz.cast(this.vulnerabilitySourceUpdatedAt()));
            }
            case "findings": {
                return Optional.ofNullable(clazz.cast(this.findings()));
            }
            case "findingSeverityCounts": {
                return Optional.ofNullable(clazz.cast(this.findingSeverityCountsAsStrings()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ImageScanFindings, T> g) {
        return obj -> g.apply((ImageScanFindings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Instant imageScanCompletedAt;
        private Instant vulnerabilitySourceUpdatedAt;
        private List<ImageScanFinding> findings = DefaultSdkAutoConstructList.getInstance();
        private Map<String, Integer> findingSeverityCounts = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ImageScanFindings model) {
            this.imageScanCompletedAt(model.imageScanCompletedAt);
            this.vulnerabilitySourceUpdatedAt(model.vulnerabilitySourceUpdatedAt);
            this.findings(model.findings);
            this.findingSeverityCountsWithStrings(model.findingSeverityCounts);
        }

        public final Instant getImageScanCompletedAt() {
            return this.imageScanCompletedAt;
        }

        @Override
        public final Builder imageScanCompletedAt(Instant imageScanCompletedAt) {
            this.imageScanCompletedAt = imageScanCompletedAt;
            return this;
        }

        public final void setImageScanCompletedAt(Instant imageScanCompletedAt) {
            this.imageScanCompletedAt = imageScanCompletedAt;
        }

        public final Instant getVulnerabilitySourceUpdatedAt() {
            return this.vulnerabilitySourceUpdatedAt;
        }

        @Override
        public final Builder vulnerabilitySourceUpdatedAt(Instant vulnerabilitySourceUpdatedAt) {
            this.vulnerabilitySourceUpdatedAt = vulnerabilitySourceUpdatedAt;
            return this;
        }

        public final void setVulnerabilitySourceUpdatedAt(Instant vulnerabilitySourceUpdatedAt) {
            this.vulnerabilitySourceUpdatedAt = vulnerabilitySourceUpdatedAt;
        }

        public final Collection<ImageScanFinding.Builder> getFindings() {
            return this.findings != null ? (Collection)this.findings.stream().map(ImageScanFinding::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder findings(Collection<ImageScanFinding> findings) {
            this.findings = ImageScanFindingListCopier.copy(findings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder findings(ImageScanFinding ... findings) {
            this.findings(Arrays.asList(findings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder findings(Consumer<ImageScanFinding.Builder> ... findings) {
            this.findings(Stream.of(findings).map(c -> (ImageScanFinding)((ImageScanFinding.Builder)ImageScanFinding.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFindings(Collection<ImageScanFinding.BuilderImpl> findings) {
            this.findings = ImageScanFindingListCopier.copyFromBuilder(findings);
        }

        public final Map<String, Integer> getFindingSeverityCountsAsStrings() {
            return this.findingSeverityCounts;
        }

        @Override
        public final Builder findingSeverityCountsWithStrings(Map<String, Integer> findingSeverityCounts) {
            this.findingSeverityCounts = FindingSeverityCountsCopier.copy(findingSeverityCounts);
            return this;
        }

        @Override
        public final Builder findingSeverityCounts(Map<FindingSeverity, Integer> findingSeverityCounts) {
            this.findingSeverityCounts = FindingSeverityCountsCopier.copyEnumToString(findingSeverityCounts);
            return this;
        }

        public final void setFindingSeverityCountsWithStrings(Map<String, Integer> findingSeverityCounts) {
            this.findingSeverityCounts = FindingSeverityCountsCopier.copy(findingSeverityCounts);
        }

        public ImageScanFindings build() {
            return new ImageScanFindings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ImageScanFindings> {
        public Builder imageScanCompletedAt(Instant var1);

        public Builder vulnerabilitySourceUpdatedAt(Instant var1);

        public Builder findings(Collection<ImageScanFinding> var1);

        public Builder findings(ImageScanFinding ... var1);

        public Builder findings(Consumer<ImageScanFinding.Builder> ... var1);

        public Builder findingSeverityCountsWithStrings(Map<String, Integer> var1);

        public Builder findingSeverityCounts(Map<FindingSeverity, Integer> var1);
    }
}

