/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecr.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object representing a repository.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Repository implements SdkPojo, Serializable, ToCopyableBuilder<Repository.Builder, Repository> {
    private static final SdkField<String> REPOSITORY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Repository::repositoryArn)).setter(setter(Builder::repositoryArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repositoryArn").build()).build();

    private static final SdkField<String> REGISTRY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Repository::registryId)).setter(setter(Builder::registryId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("registryId").build()).build();

    private static final SdkField<String> REPOSITORY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Repository::repositoryName)).setter(setter(Builder::repositoryName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repositoryName").build()).build();

    private static final SdkField<String> REPOSITORY_URI_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Repository::repositoryUri)).setter(setter(Builder::repositoryUri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repositoryUri").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(Repository::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()).build();

    private static final SdkField<String> IMAGE_TAG_MUTABILITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Repository::imageTagMutabilityAsString)).setter(setter(Builder::imageTagMutability))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageTagMutability").build())
            .build();

    private static final SdkField<ImageScanningConfiguration> IMAGE_SCANNING_CONFIGURATION_FIELD = SdkField
            .<ImageScanningConfiguration> builder(MarshallingType.SDK_POJO)
            .getter(getter(Repository::imageScanningConfiguration))
            .setter(setter(Builder::imageScanningConfiguration))
            .constructor(ImageScanningConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageScanningConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPOSITORY_ARN_FIELD,
            REGISTRY_ID_FIELD, REPOSITORY_NAME_FIELD, REPOSITORY_URI_FIELD, CREATED_AT_FIELD, IMAGE_TAG_MUTABILITY_FIELD,
            IMAGE_SCANNING_CONFIGURATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String repositoryArn;

    private final String registryId;

    private final String repositoryName;

    private final String repositoryUri;

    private final Instant createdAt;

    private final String imageTagMutability;

    private final ImageScanningConfiguration imageScanningConfiguration;

    private Repository(BuilderImpl builder) {
        this.repositoryArn = builder.repositoryArn;
        this.registryId = builder.registryId;
        this.repositoryName = builder.repositoryName;
        this.repositoryUri = builder.repositoryUri;
        this.createdAt = builder.createdAt;
        this.imageTagMutability = builder.imageTagMutability;
        this.imageScanningConfiguration = builder.imageScanningConfiguration;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) that identifies the repository. The ARN contains the <code>arn:aws:ecr</code>
     * namespace, followed by the region of the repository, AWS account ID of the repository owner, repository
     * namespace, and repository name. For example, <code>arn:aws:ecr:region:012345678910:repository/test</code>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) that identifies the repository. The ARN contains the
     *         <code>arn:aws:ecr</code> namespace, followed by the region of the repository, AWS account ID of the
     *         repository owner, repository namespace, and repository name. For example,
     *         <code>arn:aws:ecr:region:012345678910:repository/test</code>.
     */
    public String repositoryArn() {
        return repositoryArn;
    }

    /**
     * <p>
     * The AWS account ID associated with the registry that contains the repository.
     * </p>
     * 
     * @return The AWS account ID associated with the registry that contains the repository.
     */
    public String registryId() {
        return registryId;
    }

    /**
     * <p>
     * The name of the repository.
     * </p>
     * 
     * @return The name of the repository.
     */
    public String repositoryName() {
        return repositoryName;
    }

    /**
     * <p>
     * The URI for the repository. You can use this URI for Docker <code>push</code> or <code>pull</code> operations.
     * </p>
     * 
     * @return The URI for the repository. You can use this URI for Docker <code>push</code> or <code>pull</code>
     *         operations.
     */
    public String repositoryUri() {
        return repositoryUri;
    }

    /**
     * <p>
     * The date and time, in JavaScript date format, when the repository was created.
     * </p>
     * 
     * @return The date and time, in JavaScript date format, when the repository was created.
     */
    public Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The tag mutability setting for the repository.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #imageTagMutability} will return {@link ImageTagMutability#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #imageTagMutabilityAsString}.
     * </p>
     * 
     * @return The tag mutability setting for the repository.
     * @see ImageTagMutability
     */
    public ImageTagMutability imageTagMutability() {
        return ImageTagMutability.fromValue(imageTagMutability);
    }

    /**
     * <p>
     * The tag mutability setting for the repository.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #imageTagMutability} will return {@link ImageTagMutability#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #imageTagMutabilityAsString}.
     * </p>
     * 
     * @return The tag mutability setting for the repository.
     * @see ImageTagMutability
     */
    public String imageTagMutabilityAsString() {
        return imageTagMutability;
    }

    /**
     * Returns the value of the ImageScanningConfiguration property for this object.
     * 
     * @return The value of the ImageScanningConfiguration property for this object.
     */
    public ImageScanningConfiguration imageScanningConfiguration() {
        return imageScanningConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(repositoryArn());
        hashCode = 31 * hashCode + Objects.hashCode(registryId());
        hashCode = 31 * hashCode + Objects.hashCode(repositoryName());
        hashCode = 31 * hashCode + Objects.hashCode(repositoryUri());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(imageTagMutabilityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(imageScanningConfiguration());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Repository)) {
            return false;
        }
        Repository other = (Repository) obj;
        return Objects.equals(repositoryArn(), other.repositoryArn()) && Objects.equals(registryId(), other.registryId())
                && Objects.equals(repositoryName(), other.repositoryName())
                && Objects.equals(repositoryUri(), other.repositoryUri()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(imageTagMutabilityAsString(), other.imageTagMutabilityAsString())
                && Objects.equals(imageScanningConfiguration(), other.imageScanningConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("Repository").add("RepositoryArn", repositoryArn()).add("RegistryId", registryId())
                .add("RepositoryName", repositoryName()).add("RepositoryUri", repositoryUri()).add("CreatedAt", createdAt())
                .add("ImageTagMutability", imageTagMutabilityAsString())
                .add("ImageScanningConfiguration", imageScanningConfiguration()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "repositoryArn":
            return Optional.ofNullable(clazz.cast(repositoryArn()));
        case "registryId":
            return Optional.ofNullable(clazz.cast(registryId()));
        case "repositoryName":
            return Optional.ofNullable(clazz.cast(repositoryName()));
        case "repositoryUri":
            return Optional.ofNullable(clazz.cast(repositoryUri()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "imageTagMutability":
            return Optional.ofNullable(clazz.cast(imageTagMutabilityAsString()));
        case "imageScanningConfiguration":
            return Optional.ofNullable(clazz.cast(imageScanningConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Repository, T> g) {
        return obj -> g.apply((Repository) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Repository> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) that identifies the repository. The ARN contains the <code>arn:aws:ecr</code>
         * namespace, followed by the region of the repository, AWS account ID of the repository owner, repository
         * namespace, and repository name. For example, <code>arn:aws:ecr:region:012345678910:repository/test</code>.
         * </p>
         * 
         * @param repositoryArn
         *        The Amazon Resource Name (ARN) that identifies the repository. The ARN contains the
         *        <code>arn:aws:ecr</code> namespace, followed by the region of the repository, AWS account ID of the
         *        repository owner, repository namespace, and repository name. For example,
         *        <code>arn:aws:ecr:region:012345678910:repository/test</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder repositoryArn(String repositoryArn);

        /**
         * <p>
         * The AWS account ID associated with the registry that contains the repository.
         * </p>
         * 
         * @param registryId
         *        The AWS account ID associated with the registry that contains the repository.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder registryId(String registryId);

        /**
         * <p>
         * The name of the repository.
         * </p>
         * 
         * @param repositoryName
         *        The name of the repository.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder repositoryName(String repositoryName);

        /**
         * <p>
         * The URI for the repository. You can use this URI for Docker <code>push</code> or <code>pull</code>
         * operations.
         * </p>
         * 
         * @param repositoryUri
         *        The URI for the repository. You can use this URI for Docker <code>push</code> or <code>pull</code>
         *        operations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder repositoryUri(String repositoryUri);

        /**
         * <p>
         * The date and time, in JavaScript date format, when the repository was created.
         * </p>
         * 
         * @param createdAt
         *        The date and time, in JavaScript date format, when the repository was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The tag mutability setting for the repository.
         * </p>
         * 
         * @param imageTagMutability
         *        The tag mutability setting for the repository.
         * @see ImageTagMutability
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ImageTagMutability
         */
        Builder imageTagMutability(String imageTagMutability);

        /**
         * <p>
         * The tag mutability setting for the repository.
         * </p>
         * 
         * @param imageTagMutability
         *        The tag mutability setting for the repository.
         * @see ImageTagMutability
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ImageTagMutability
         */
        Builder imageTagMutability(ImageTagMutability imageTagMutability);

        /**
         * Sets the value of the ImageScanningConfiguration property for this object.
         *
         * @param imageScanningConfiguration
         *        The new value for the ImageScanningConfiguration property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageScanningConfiguration(ImageScanningConfiguration imageScanningConfiguration);

        /**
         * Sets the value of the ImageScanningConfiguration property for this object.
         *
         * This is a convenience that creates an instance of the {@link ImageScanningConfiguration.Builder} avoiding the
         * need to create one manually via {@link ImageScanningConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link ImageScanningConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #imageScanningConfiguration(ImageScanningConfiguration)}.
         * 
         * @param imageScanningConfiguration
         *        a consumer that will call methods on {@link ImageScanningConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #imageScanningConfiguration(ImageScanningConfiguration)
         */
        default Builder imageScanningConfiguration(Consumer<ImageScanningConfiguration.Builder> imageScanningConfiguration) {
            return imageScanningConfiguration(ImageScanningConfiguration.builder().applyMutation(imageScanningConfiguration)
                    .build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String repositoryArn;

        private String registryId;

        private String repositoryName;

        private String repositoryUri;

        private Instant createdAt;

        private String imageTagMutability;

        private ImageScanningConfiguration imageScanningConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(Repository model) {
            repositoryArn(model.repositoryArn);
            registryId(model.registryId);
            repositoryName(model.repositoryName);
            repositoryUri(model.repositoryUri);
            createdAt(model.createdAt);
            imageTagMutability(model.imageTagMutability);
            imageScanningConfiguration(model.imageScanningConfiguration);
        }

        public final String getRepositoryArn() {
            return repositoryArn;
        }

        @Override
        public final Builder repositoryArn(String repositoryArn) {
            this.repositoryArn = repositoryArn;
            return this;
        }

        public final void setRepositoryArn(String repositoryArn) {
            this.repositoryArn = repositoryArn;
        }

        public final String getRegistryId() {
            return registryId;
        }

        @Override
        public final Builder registryId(String registryId) {
            this.registryId = registryId;
            return this;
        }

        public final void setRegistryId(String registryId) {
            this.registryId = registryId;
        }

        public final String getRepositoryName() {
            return repositoryName;
        }

        @Override
        public final Builder repositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
            return this;
        }

        public final void setRepositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
        }

        public final String getRepositoryUri() {
            return repositoryUri;
        }

        @Override
        public final Builder repositoryUri(String repositoryUri) {
            this.repositoryUri = repositoryUri;
            return this;
        }

        public final void setRepositoryUri(String repositoryUri) {
            this.repositoryUri = repositoryUri;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        public final String getImageTagMutabilityAsString() {
            return imageTagMutability;
        }

        @Override
        public final Builder imageTagMutability(String imageTagMutability) {
            this.imageTagMutability = imageTagMutability;
            return this;
        }

        @Override
        public final Builder imageTagMutability(ImageTagMutability imageTagMutability) {
            this.imageTagMutability(imageTagMutability == null ? null : imageTagMutability.toString());
            return this;
        }

        public final void setImageTagMutability(String imageTagMutability) {
            this.imageTagMutability = imageTagMutability;
        }

        public final ImageScanningConfiguration.Builder getImageScanningConfiguration() {
            return imageScanningConfiguration != null ? imageScanningConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder imageScanningConfiguration(ImageScanningConfiguration imageScanningConfiguration) {
            this.imageScanningConfiguration = imageScanningConfiguration;
            return this;
        }

        public final void setImageScanningConfiguration(ImageScanningConfiguration.BuilderImpl imageScanningConfiguration) {
            this.imageScanningConfiguration = imageScanningConfiguration != null ? imageScanningConfiguration.build() : null;
        }

        @Override
        public Repository build() {
            return new Repository(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
