/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecr.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object representing an Amazon ECR image.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Image implements SdkPojo, Serializable, ToCopyableBuilder<Image.Builder, Image> {
    private static final SdkField<String> REGISTRY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Image::registryId)).setter(setter(Builder::registryId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("registryId").build()).build();

    private static final SdkField<String> REPOSITORY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Image::repositoryName)).setter(setter(Builder::repositoryName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repositoryName").build()).build();

    private static final SdkField<ImageIdentifier> IMAGE_ID_FIELD = SdkField.<ImageIdentifier> builder(MarshallingType.SDK_POJO)
            .getter(getter(Image::imageId)).setter(setter(Builder::imageId)).constructor(ImageIdentifier::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageId").build()).build();

    private static final SdkField<String> IMAGE_MANIFEST_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Image::imageManifest)).setter(setter(Builder::imageManifest))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageManifest").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGISTRY_ID_FIELD,
            REPOSITORY_NAME_FIELD, IMAGE_ID_FIELD, IMAGE_MANIFEST_FIELD));

    private static final long serialVersionUID = 1L;

    private final String registryId;

    private final String repositoryName;

    private final ImageIdentifier imageId;

    private final String imageManifest;

    private Image(BuilderImpl builder) {
        this.registryId = builder.registryId;
        this.repositoryName = builder.repositoryName;
        this.imageId = builder.imageId;
        this.imageManifest = builder.imageManifest;
    }

    /**
     * <p>
     * The AWS account ID associated with the registry containing the image.
     * </p>
     * 
     * @return The AWS account ID associated with the registry containing the image.
     */
    public String registryId() {
        return registryId;
    }

    /**
     * <p>
     * The name of the repository associated with the image.
     * </p>
     * 
     * @return The name of the repository associated with the image.
     */
    public String repositoryName() {
        return repositoryName;
    }

    /**
     * <p>
     * An object containing the image tag and image digest associated with an image.
     * </p>
     * 
     * @return An object containing the image tag and image digest associated with an image.
     */
    public ImageIdentifier imageId() {
        return imageId;
    }

    /**
     * <p>
     * The image manifest associated with the image.
     * </p>
     * 
     * @return The image manifest associated with the image.
     */
    public String imageManifest() {
        return imageManifest;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(registryId());
        hashCode = 31 * hashCode + Objects.hashCode(repositoryName());
        hashCode = 31 * hashCode + Objects.hashCode(imageId());
        hashCode = 31 * hashCode + Objects.hashCode(imageManifest());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Image)) {
            return false;
        }
        Image other = (Image) obj;
        return Objects.equals(registryId(), other.registryId()) && Objects.equals(repositoryName(), other.repositoryName())
                && Objects.equals(imageId(), other.imageId()) && Objects.equals(imageManifest(), other.imageManifest());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("Image").add("RegistryId", registryId()).add("RepositoryName", repositoryName())
                .add("ImageId", imageId()).add("ImageManifest", imageManifest()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "registryId":
            return Optional.ofNullable(clazz.cast(registryId()));
        case "repositoryName":
            return Optional.ofNullable(clazz.cast(repositoryName()));
        case "imageId":
            return Optional.ofNullable(clazz.cast(imageId()));
        case "imageManifest":
            return Optional.ofNullable(clazz.cast(imageManifest()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Image, T> g) {
        return obj -> g.apply((Image) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Image> {
        /**
         * <p>
         * The AWS account ID associated with the registry containing the image.
         * </p>
         * 
         * @param registryId
         *        The AWS account ID associated with the registry containing the image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder registryId(String registryId);

        /**
         * <p>
         * The name of the repository associated with the image.
         * </p>
         * 
         * @param repositoryName
         *        The name of the repository associated with the image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder repositoryName(String repositoryName);

        /**
         * <p>
         * An object containing the image tag and image digest associated with an image.
         * </p>
         * 
         * @param imageId
         *        An object containing the image tag and image digest associated with an image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageId(ImageIdentifier imageId);

        /**
         * <p>
         * An object containing the image tag and image digest associated with an image.
         * </p>
         * This is a convenience that creates an instance of the {@link ImageIdentifier.Builder} avoiding the need to
         * create one manually via {@link ImageIdentifier#builder()}.
         *
         * When the {@link Consumer} completes, {@link ImageIdentifier.Builder#build()} is called immediately and its
         * result is passed to {@link #imageId(ImageIdentifier)}.
         * 
         * @param imageId
         *        a consumer that will call methods on {@link ImageIdentifier.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #imageId(ImageIdentifier)
         */
        default Builder imageId(Consumer<ImageIdentifier.Builder> imageId) {
            return imageId(ImageIdentifier.builder().applyMutation(imageId).build());
        }

        /**
         * <p>
         * The image manifest associated with the image.
         * </p>
         * 
         * @param imageManifest
         *        The image manifest associated with the image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageManifest(String imageManifest);
    }

    static final class BuilderImpl implements Builder {
        private String registryId;

        private String repositoryName;

        private ImageIdentifier imageId;

        private String imageManifest;

        private BuilderImpl() {
        }

        private BuilderImpl(Image model) {
            registryId(model.registryId);
            repositoryName(model.repositoryName);
            imageId(model.imageId);
            imageManifest(model.imageManifest);
        }

        public final String getRegistryId() {
            return registryId;
        }

        @Override
        public final Builder registryId(String registryId) {
            this.registryId = registryId;
            return this;
        }

        public final void setRegistryId(String registryId) {
            this.registryId = registryId;
        }

        public final String getRepositoryName() {
            return repositoryName;
        }

        @Override
        public final Builder repositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
            return this;
        }

        public final void setRepositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
        }

        public final ImageIdentifier.Builder getImageId() {
            return imageId != null ? imageId.toBuilder() : null;
        }

        @Override
        public final Builder imageId(ImageIdentifier imageId) {
            this.imageId = imageId;
            return this;
        }

        public final void setImageId(ImageIdentifier.BuilderImpl imageId) {
            this.imageId = imageId != null ? imageId.build() : null;
        }

        public final String getImageManifest() {
            return imageManifest;
        }

        @Override
        public final Builder imageManifest(String imageManifest) {
            this.imageManifest = imageManifest;
            return this;
        }

        public final void setImageManifest(String imageManifest) {
            this.imageManifest = imageManifest;
        }

        @Override
        public Image build() {
            return new Image(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
