/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecr;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.ecr.model.BatchCheckLayerAvailabilityRequest;
import software.amazon.awssdk.services.ecr.model.BatchCheckLayerAvailabilityResponse;
import software.amazon.awssdk.services.ecr.model.BatchDeleteImageRequest;
import software.amazon.awssdk.services.ecr.model.BatchDeleteImageResponse;
import software.amazon.awssdk.services.ecr.model.BatchGetImageRequest;
import software.amazon.awssdk.services.ecr.model.BatchGetImageResponse;
import software.amazon.awssdk.services.ecr.model.CompleteLayerUploadRequest;
import software.amazon.awssdk.services.ecr.model.CompleteLayerUploadResponse;
import software.amazon.awssdk.services.ecr.model.CreateRepositoryRequest;
import software.amazon.awssdk.services.ecr.model.CreateRepositoryResponse;
import software.amazon.awssdk.services.ecr.model.DeleteLifecyclePolicyRequest;
import software.amazon.awssdk.services.ecr.model.DeleteLifecyclePolicyResponse;
import software.amazon.awssdk.services.ecr.model.DeleteRepositoryPolicyRequest;
import software.amazon.awssdk.services.ecr.model.DeleteRepositoryPolicyResponse;
import software.amazon.awssdk.services.ecr.model.DeleteRepositoryRequest;
import software.amazon.awssdk.services.ecr.model.DeleteRepositoryResponse;
import software.amazon.awssdk.services.ecr.model.DescribeImageScanFindingsRequest;
import software.amazon.awssdk.services.ecr.model.DescribeImageScanFindingsResponse;
import software.amazon.awssdk.services.ecr.model.DescribeImagesRequest;
import software.amazon.awssdk.services.ecr.model.DescribeImagesResponse;
import software.amazon.awssdk.services.ecr.model.DescribeRepositoriesRequest;
import software.amazon.awssdk.services.ecr.model.DescribeRepositoriesResponse;
import software.amazon.awssdk.services.ecr.model.EcrException;
import software.amazon.awssdk.services.ecr.model.EmptyUploadException;
import software.amazon.awssdk.services.ecr.model.GetAuthorizationTokenRequest;
import software.amazon.awssdk.services.ecr.model.GetAuthorizationTokenResponse;
import software.amazon.awssdk.services.ecr.model.GetDownloadUrlForLayerRequest;
import software.amazon.awssdk.services.ecr.model.GetDownloadUrlForLayerResponse;
import software.amazon.awssdk.services.ecr.model.GetLifecyclePolicyPreviewRequest;
import software.amazon.awssdk.services.ecr.model.GetLifecyclePolicyPreviewResponse;
import software.amazon.awssdk.services.ecr.model.GetLifecyclePolicyRequest;
import software.amazon.awssdk.services.ecr.model.GetLifecyclePolicyResponse;
import software.amazon.awssdk.services.ecr.model.GetRepositoryPolicyRequest;
import software.amazon.awssdk.services.ecr.model.GetRepositoryPolicyResponse;
import software.amazon.awssdk.services.ecr.model.ImageAlreadyExistsException;
import software.amazon.awssdk.services.ecr.model.ImageNotFoundException;
import software.amazon.awssdk.services.ecr.model.ImageTagAlreadyExistsException;
import software.amazon.awssdk.services.ecr.model.InitiateLayerUploadRequest;
import software.amazon.awssdk.services.ecr.model.InitiateLayerUploadResponse;
import software.amazon.awssdk.services.ecr.model.InvalidLayerException;
import software.amazon.awssdk.services.ecr.model.InvalidLayerPartException;
import software.amazon.awssdk.services.ecr.model.InvalidParameterException;
import software.amazon.awssdk.services.ecr.model.InvalidTagParameterException;
import software.amazon.awssdk.services.ecr.model.LayerAlreadyExistsException;
import software.amazon.awssdk.services.ecr.model.LayerInaccessibleException;
import software.amazon.awssdk.services.ecr.model.LayerPartTooSmallException;
import software.amazon.awssdk.services.ecr.model.LayersNotFoundException;
import software.amazon.awssdk.services.ecr.model.LifecyclePolicyNotFoundException;
import software.amazon.awssdk.services.ecr.model.LifecyclePolicyPreviewInProgressException;
import software.amazon.awssdk.services.ecr.model.LifecyclePolicyPreviewNotFoundException;
import software.amazon.awssdk.services.ecr.model.LimitExceededException;
import software.amazon.awssdk.services.ecr.model.ListImagesRequest;
import software.amazon.awssdk.services.ecr.model.ListImagesResponse;
import software.amazon.awssdk.services.ecr.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.ecr.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.ecr.model.PutImageRequest;
import software.amazon.awssdk.services.ecr.model.PutImageResponse;
import software.amazon.awssdk.services.ecr.model.PutImageScanningConfigurationRequest;
import software.amazon.awssdk.services.ecr.model.PutImageScanningConfigurationResponse;
import software.amazon.awssdk.services.ecr.model.PutImageTagMutabilityRequest;
import software.amazon.awssdk.services.ecr.model.PutImageTagMutabilityResponse;
import software.amazon.awssdk.services.ecr.model.PutLifecyclePolicyRequest;
import software.amazon.awssdk.services.ecr.model.PutLifecyclePolicyResponse;
import software.amazon.awssdk.services.ecr.model.RepositoryAlreadyExistsException;
import software.amazon.awssdk.services.ecr.model.RepositoryNotEmptyException;
import software.amazon.awssdk.services.ecr.model.RepositoryNotFoundException;
import software.amazon.awssdk.services.ecr.model.RepositoryPolicyNotFoundException;
import software.amazon.awssdk.services.ecr.model.ScanNotFoundException;
import software.amazon.awssdk.services.ecr.model.ServerException;
import software.amazon.awssdk.services.ecr.model.SetRepositoryPolicyRequest;
import software.amazon.awssdk.services.ecr.model.SetRepositoryPolicyResponse;
import software.amazon.awssdk.services.ecr.model.StartImageScanRequest;
import software.amazon.awssdk.services.ecr.model.StartImageScanResponse;
import software.amazon.awssdk.services.ecr.model.StartLifecyclePolicyPreviewRequest;
import software.amazon.awssdk.services.ecr.model.StartLifecyclePolicyPreviewResponse;
import software.amazon.awssdk.services.ecr.model.TagResourceRequest;
import software.amazon.awssdk.services.ecr.model.TagResourceResponse;
import software.amazon.awssdk.services.ecr.model.TooManyTagsException;
import software.amazon.awssdk.services.ecr.model.UntagResourceRequest;
import software.amazon.awssdk.services.ecr.model.UntagResourceResponse;
import software.amazon.awssdk.services.ecr.model.UploadLayerPartRequest;
import software.amazon.awssdk.services.ecr.model.UploadLayerPartResponse;
import software.amazon.awssdk.services.ecr.model.UploadNotFoundException;
import software.amazon.awssdk.services.ecr.paginators.DescribeImageScanFindingsIterable;
import software.amazon.awssdk.services.ecr.paginators.DescribeImagesIterable;
import software.amazon.awssdk.services.ecr.paginators.DescribeRepositoriesIterable;
import software.amazon.awssdk.services.ecr.paginators.GetLifecyclePolicyPreviewIterable;
import software.amazon.awssdk.services.ecr.paginators.ListImagesIterable;

/**
 * Service client for accessing Amazon ECR. This can be created using the static {@link #builder()} method.
 *
 * <fullname>Amazon Elastic Container Registry</fullname>
 * <p>
 * Amazon Elastic Container Registry (Amazon ECR) is a managed Docker registry service. Customers can use the familiar
 * Docker CLI to push, pull, and manage images. Amazon ECR provides a secure, scalable, and reliable registry. Amazon
 * ECR supports private Docker repositories with resource-based permissions using IAM so that specific users or Amazon
 * EC2 instances can access repositories and images. Developers can use the Docker CLI to author and manage images.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public interface EcrClient extends SdkClient {
    String SERVICE_NAME = "ecr";

    /**
     * Create a {@link EcrClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static EcrClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link EcrClient}.
     */
    static EcrClientBuilder builder() {
        return new DefaultEcrClientBuilder();
    }

    /**
     * <p>
     * Check the availability of multiple image layers in a specified registry and repository.
     * </p>
     * <note>
     * <p>
     * This operation is used by the Amazon ECR proxy, and it is not intended for general use by customers for pulling
     * and pushing images. In most cases, you should use the <code>docker</code> CLI to pull, tag, and push images.
     * </p>
     * </note>
     *
     * @param batchCheckLayerAvailabilityRequest
     * @return Result of the BatchCheckLayerAvailability operation returned by the service.
     * @throws RepositoryNotFoundException
     *         The specified repository could not be found. Check the spelling of the specified repository and ensure
     *         that you are performing operations on the correct registry.
     * @throws InvalidParameterException
     *         The specified parameter is invalid. Review the available parameters for the API request.
     * @throws ServerException
     *         These errors are usually caused by a server-side issue.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EcrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EcrClient.BatchCheckLayerAvailability
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/BatchCheckLayerAvailability"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchCheckLayerAvailabilityResponse batchCheckLayerAvailability(
            BatchCheckLayerAvailabilityRequest batchCheckLayerAvailabilityRequest) throws RepositoryNotFoundException,
            InvalidParameterException, ServerException, AwsServiceException, SdkClientException, EcrException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Check the availability of multiple image layers in a specified registry and repository.
     * </p>
     * <note>
     * <p>
     * This operation is used by the Amazon ECR proxy, and it is not intended for general use by customers for pulling
     * and pushing images. In most cases, you should use the <code>docker</code> CLI to pull, tag, and push images.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchCheckLayerAvailabilityRequest.Builder}
     * avoiding the need to create one manually via {@link BatchCheckLayerAvailabilityRequest#builder()}
     * </p>
     *
     * @param batchCheckLayerAvailabilityRequest
     *        A {@link Consumer} that will call methods on {@link BatchCheckLayerAvailabilityRequest.Builder} to create
     *        a request.
     * @return Result of the BatchCheckLayerAvailability operation returned by the service.
     * @throws RepositoryNotFoundException
     *         The specified repository could not be found. Check the spelling of the specified repository and ensure
     *         that you are performing operations on the correct registry.
     * @throws InvalidParameterException
     *         The specified parameter is invalid. Review the available parameters for the API request.
     * @throws ServerException
     *         These errors are usually caused by a server-side issue.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EcrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EcrClient.BatchCheckLayerAvailability
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/BatchCheckLayerAvailability"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchCheckLayerAvailabilityResponse batchCheckLayerAvailability(
            Consumer<BatchCheckLayerAvailabilityRequest.Builder> batchCheckLayerAvailabilityRequest)
            throws RepositoryNotFoundException, InvalidParameterException, ServerException, AwsServiceException,
            SdkClientException, EcrException {
        return batchCheckLayerAvailability(BatchCheckLayerAvailabilityRequest.builder()
                .applyMutation(batchCheckLayerAvailabilityRequest).build());
    }

    /**
     * <p>
     * Deletes a list of specified images within a specified repository. Images are specified with either
     * <code>imageTag</code> or <code>imageDigest</code>.
     * </p>
     * <p>
     * You can remove a tag from an image by specifying the image's tag in your request. When you remove the last tag
     * from an image, the image is deleted from your repository.
     * </p>
     * <p>
     * You can completely delete an image (and all of its tags) by specifying the image's digest in your request.
     * </p>
     *
     * @param batchDeleteImageRequest
     *        Deletes specified images within a specified repository. Images are specified with either the
     *        <code>imageTag</code> or <code>imageDigest</code>.
     * @return Result of the BatchDeleteImage operation returned by the service.
     * @throws ServerException
     *         These errors are usually caused by a server-side issue.
     * @throws InvalidParameterException
     *         The specified parameter is invalid. Review the available parameters for the API request.
     * @throws RepositoryNotFoundException
     *         The specified repository could not be found. Check the spelling of the specified repository and ensure
     *         that you are performing operations on the correct registry.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EcrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EcrClient.BatchDeleteImage
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/BatchDeleteImage" target="_top">AWS API
     *      Documentation</a>
     */
    default BatchDeleteImageResponse batchDeleteImage(BatchDeleteImageRequest batchDeleteImageRequest) throws ServerException,
            InvalidParameterException, RepositoryNotFoundException, AwsServiceException, SdkClientException, EcrException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a list of specified images within a specified repository. Images are specified with either
     * <code>imageTag</code> or <code>imageDigest</code>.
     * </p>
     * <p>
     * You can remove a tag from an image by specifying the image's tag in your request. When you remove the last tag
     * from an image, the image is deleted from your repository.
     * </p>
     * <p>
     * You can completely delete an image (and all of its tags) by specifying the image's digest in your request.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchDeleteImageRequest.Builder} avoiding the need
     * to create one manually via {@link BatchDeleteImageRequest#builder()}
     * </p>
     *
     * @param batchDeleteImageRequest
     *        A {@link Consumer} that will call methods on {@link BatchDeleteImageRequest.Builder} to create a request.
     *        Deletes specified images within a specified repository. Images are specified with either the
     *        <code>imageTag</code> or <code>imageDigest</code>.
     * @return Result of the BatchDeleteImage operation returned by the service.
     * @throws ServerException
     *         These errors are usually caused by a server-side issue.
     * @throws InvalidParameterException
     *         The specified parameter is invalid. Review the available parameters for the API request.
     * @throws RepositoryNotFoundException
     *         The specified repository could not be found. Check the spelling of the specified repository and ensure
     *         that you are performing operations on the correct registry.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EcrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EcrClient.BatchDeleteImage
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/BatchDeleteImage" target="_top">AWS API
     *      Documentation</a>
     */
    default BatchDeleteImageResponse batchDeleteImage(Consumer<BatchDeleteImageRequest.Builder> batchDeleteImageRequest)
            throws ServerException, InvalidParameterException, RepositoryNotFoundException, AwsServiceException,
            SdkClientException, EcrException {
        return batchDeleteImage(BatchDeleteImageRequest.builder().applyMutation(batchDeleteImageRequest).build());
    }

    /**
     * <p>
     * Gets detailed information for specified images within a specified repository. Images are specified with either
     * <code>imageTag</code> or <code>imageDigest</code>.
     * </p>
     *
     * @param batchGetImageRequest
     * @return Result of the BatchGetImage operation returned by the service.
     * @throws ServerException
     *         These errors are usually caused by a server-side issue.
     * @throws InvalidParameterException
     *         The specified parameter is invalid. Review the available parameters for the API request.
     * @throws RepositoryNotFoundException
     *         The specified repository could not be found. Check the spelling of the specified repository and ensure
     *         that you are performing operations on the correct registry.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EcrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EcrClient.BatchGetImage
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/BatchGetImage" target="_top">AWS API
     *      Documentation</a>
     */
    default BatchGetImageResponse batchGetImage(BatchGetImageRequest batchGetImageRequest) throws ServerException,
            InvalidParameterException, RepositoryNotFoundException, AwsServiceException, SdkClientException, EcrException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets detailed information for specified images within a specified repository. Images are specified with either
     * <code>imageTag</code> or <code>imageDigest</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchGetImageRequest.Builder} avoiding the need to
     * create one manually via {@link BatchGetImageRequest#builder()}
     * </p>
     *
     * @param batchGetImageRequest
     *        A {@link Consumer} that will call methods on {@link BatchGetImageRequest.Builder} to create a request.
     * @return Result of the BatchGetImage operation returned by the service.
     * @throws ServerException
     *         These errors are usually caused by a server-side issue.
     * @throws InvalidParameterException
     *         The specified parameter is invalid. Review the available parameters for the API request.
     * @throws RepositoryNotFoundException
     *         The specified repository could not be found. Check the spelling of the specified repository and ensure
     *         that you are performing operations on the correct registry.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EcrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EcrClient.BatchGetImage
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/BatchGetImage" target="_top">AWS API
     *      Documentation</a>
     */
    default BatchGetImageResponse batchGetImage(Consumer<BatchGetImageRequest.Builder> batchGetImageRequest)
            throws ServerException, InvalidParameterException, RepositoryNotFoundException, AwsServiceException,
            SdkClientException, EcrException {
        return batchGetImage(BatchGetImageRequest.builder().applyMutation(batchGetImageRequest).build());
    }

    /**
     * <p>
     * Informs Amazon ECR that the image layer upload has completed for a specified registry, repository name, and
     * upload ID. You can optionally provide a <code>sha256</code> digest of the image layer for data validation
     * purposes.
     * </p>
     * <note>
     * <p>
     * This operation is used by the Amazon ECR proxy, and it is not intended for general use by customers for pulling
     * and pushing images. In most cases, you should use the <code>docker</code> CLI to pull, tag, and push images.
     * </p>
     * </note>
     *
     * @param completeLayerUploadRequest
     * @return Result of the CompleteLayerUpload operation returned by the service.
     * @throws ServerException
     *         These errors are usually caused by a server-side issue.
     * @throws InvalidParameterException
     *         The specified parameter is invalid. Review the available parameters for the API request.
     * @throws RepositoryNotFoundException
     *         The specified repository could not be found. Check the spelling of the specified repository and ensure
     *         that you are performing operations on the correct registry.
     * @throws UploadNotFoundException
     *         The upload could not be found, or the specified upload id is not valid for this repository.
     * @throws InvalidLayerException
     *         The layer digest calculation performed by Amazon ECR upon receipt of the image layer does not match the
     *         digest specified.
     * @throws LayerPartTooSmallException
     *         Layer parts must be at least 5 MiB in size.
     * @throws LayerAlreadyExistsException
     *         The image layer already exists in the associated repository.
     * @throws EmptyUploadException
     *         The specified layer upload does not contain any layer parts.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EcrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EcrClient.CompleteLayerUpload
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/CompleteLayerUpload" target="_top">AWS API
     *      Documentation</a>
     */
    default CompleteLayerUploadResponse completeLayerUpload(CompleteLayerUploadRequest completeLayerUploadRequest)
            throws ServerException, InvalidParameterException, RepositoryNotFoundException, UploadNotFoundException,
            InvalidLayerException, LayerPartTooSmallException, LayerAlreadyExistsException, EmptyUploadException,
            AwsServiceException, SdkClientException, EcrException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Informs Amazon ECR that the image layer upload has completed for a specified registry, repository name, and
     * upload ID. You can optionally provide a <code>sha256</code> digest of the image layer for data validation
     * purposes.
     * </p>
     * <note>
     * <p>
     * This operation is used by the Amazon ECR proxy, and it is not intended for general use by customers for pulling
     * and pushing images. In most cases, you should use the <code>docker</code> CLI to pull, tag, and push images.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CompleteLayerUploadRequest.Builder} avoiding the
     * need to create one manually via {@link CompleteLayerUploadRequest#builder()}
     * </p>
     *
     * @param completeLayerUploadRequest
     *        A {@link Consumer} that will call methods on {@link CompleteLayerUploadRequest.Builder} to create a
     *        request.
     * @return Result of the CompleteLayerUpload operation returned by the service.
     * @throws ServerException
     *         These errors are usually caused by a server-side issue.
     * @throws InvalidParameterException
     *         The specified parameter is invalid. Review the available parameters for the API request.
     * @throws RepositoryNotFoundException
     *         The specified repository could not be found. Check the spelling of the specified repository and ensure
     *         that you are performing operations on the correct registry.
     * @throws UploadNotFoundException
     *         The upload could not be found, or the specified upload id is not valid for this repository.
     * @throws InvalidLayerException
     *         The layer digest calculation performed by Amazon ECR upon receipt of the image layer does not match the
     *         digest specified.
     * @throws LayerPartTooSmallException
     *         Layer parts must be at least 5 MiB in size.
     * @throws LayerAlreadyExistsException
     *         The image layer already exists in the associated repository.
     * @throws EmptyUploadException
     *         The specified layer upload does not contain any layer parts.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EcrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EcrClient.CompleteLayerUpload
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/CompleteLayerUpload" target="_top">AWS API
     *      Documentation</a>
     */
    default CompleteLayerUploadResponse completeLayerUpload(
            Consumer<CompleteLayerUploadRequest.Builder> completeLayerUploadRequest) throws ServerException,
            InvalidParameterException, RepositoryNotFoundException, UploadNotFoundException, InvalidLayerException,
            LayerPartTooSmallException, LayerAlreadyExistsException, EmptyUploadException, AwsServiceException,
            SdkClientException, EcrException {
        return completeLayerUpload(CompleteLayerUploadRequest.builder().applyMutation(completeLayerUploadRequest).build());
    }

    /**
     * <p>
     * Creates an Amazon Elastic Container Registry (Amazon ECR) repository, where users can push and pull Docker
     * images. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonECR/latest/userguide/Repositories.html">Amazon ECR Repositories</a> in
     * the <i>Amazon Elastic Container Registry User Guide</i>.
     * </p>
     *
     * @param createRepositoryRequest
     * @return Result of the CreateRepository operation returned by the service.
     * @throws ServerException
     *         These errors are usually caused by a server-side issue.
     * @throws InvalidParameterException
     *         The specified parameter is invalid. Review the available parameters for the API request.
     * @throws InvalidTagParameterException
     *         An invalid parameter has been specified. Tag keys can have a maximum character length of 128 characters,
     *         and tag values can have a maximum length of 256 characters.
     * @throws TooManyTagsException
     *         The list of tags on the repository is over the limit. The maximum number of tags that can be applied to a
     *         repository is 50.
     * @throws RepositoryAlreadyExistsException
     *         The specified repository already exists in the specified registry.
     * @throws LimitExceededException
     *         The operation did not succeed because it would have exceeded a service limit for your account. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/AmazonECR/latest/userguide/service_limits.html">Amazon ECR Default
     *         Service Limits</a> in the Amazon Elastic Container Registry User Guide.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EcrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EcrClient.CreateRepository
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/CreateRepository" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateRepositoryResponse createRepository(CreateRepositoryRequest createRepositoryRequest) throws ServerException,
            InvalidParameterException, InvalidTagParameterException, TooManyTagsException, RepositoryAlreadyExistsException,
            LimitExceededException, AwsServiceException, SdkClientException, EcrException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an Amazon Elastic Container Registry (Amazon ECR) repository, where users can push and pull Docker
     * images. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonECR/latest/userguide/Repositories.html">Amazon ECR Repositories</a> in
     * the <i>Amazon Elastic Container Registry User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateRepositoryRequest.Builder} avoiding the need
     * to create one manually via {@link CreateRepositoryRequest#builder()}
     * </p>
     *
     * @param createRepositoryRequest
     *        A {@link Consumer} that will call methods on {@link CreateRepositoryRequest.Builder} to create a request.
     * @return Result of the CreateRepository operation returned by the service.
     * @throws ServerException
     *         These errors are usually caused by a server-side issue.
     * @throws InvalidParameterException
     *         The specified parameter is invalid. Review the available parameters for the API request.
     * @throws InvalidTagParameterException
     *         An invalid parameter has been specified. Tag keys can have a maximum character length of 128 characters,
     *         and tag values can have a maximum length of 256 characters.
     * @throws TooManyTagsException
     *         The list of tags on the repository is over the limit. The maximum number of tags that can be applied to a
     *         repository is 50.
     * @throws RepositoryAlreadyExistsException
     *         The specified repository already exists in the specified registry.
     * @throws LimitExceededException
     *         The operation did not succeed because it would have exceeded a service limit for your account. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/AmazonECR/latest/userguide/service_limits.html">Amazon ECR Default
     *         Service Limits</a> in the Amazon Elastic Container Registry User Guide.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EcrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EcrClient.CreateRepository
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/CreateRepository" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateRepositoryResponse createRepository(Consumer<CreateRepositoryRequest.Builder> createRepositoryRequest)
            throws ServerException, InvalidParameterException, InvalidTagParameterException, TooManyTagsException,
            RepositoryAlreadyExistsException, LimitExceededException, AwsServiceException, SdkClientException, EcrException {
        return createRepository(CreateRepositoryRequest.builder().applyMutation(createRepositoryRequest).build());
    }

    /**
     * <p>
     * Deletes the specified lifecycle policy.
     * </p>
     *
     * @param deleteLifecyclePolicyRequest
     * @return Result of the DeleteLifecyclePolicy operation returned by the service.
     * @throws ServerException
     *         These errors are usually caused by a server-side issue.
     * @throws InvalidParameterException
     *         The specified parameter is invalid. Review the available parameters for the API request.
     * @throws RepositoryNotFoundException
     *         The specified repository could not be found. Check the spelling of the specified repository and ensure
     *         that you are performing operations on the correct registry.
     * @throws LifecyclePolicyNotFoundException
     *         The lifecycle policy could not be found, and no policy is set to the repository.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EcrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EcrClient.DeleteLifecyclePolicy
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/DeleteLifecyclePolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteLifecyclePolicyResponse deleteLifecyclePolicy(DeleteLifecyclePolicyRequest deleteLifecyclePolicyRequest)
            throws ServerException, InvalidParameterException, RepositoryNotFoundException, LifecyclePolicyNotFoundException,
            AwsServiceException, SdkClientException, EcrException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified lifecycle policy.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteLifecyclePolicyRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteLifecyclePolicyRequest#builder()}
     * </p>
     *
     * @param deleteLifecyclePolicyRequest
     *        A {@link Consumer} that will call methods on {@link DeleteLifecyclePolicyRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteLifecyclePolicy operation returned by the service.
     * @throws ServerException
     *         These errors are usually caused by a server-side issue.
     * @throws InvalidParameterException
     *         The specified parameter is invalid. Review the available parameters for the API request.
     * @throws RepositoryNotFoundException
     *         The specified repository could not be found. Check the spelling of the specified repository and ensure
     *         that you are performing operations on the correct registry.
     * @throws LifecyclePolicyNotFoundException
     *         The lifecycle policy could not be found, and no policy is set to the repository.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EcrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EcrClient.DeleteLifecyclePolicy
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/DeleteLifecyclePolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteLifecyclePolicyResponse deleteLifecyclePolicy(
            Consumer<DeleteLifecyclePolicyRequest.Builder> deleteLifecyclePolicyRequest) throws ServerException,
            InvalidParameterException, RepositoryNotFoundException, LifecyclePolicyNotFoundException, AwsServiceException,
            SdkClientException, EcrException {
        return deleteLifecyclePolicy(DeleteLifecyclePolicyRequest.builder().applyMutation(deleteLifecyclePolicyRequest).build());
    }

    /**
     * <p>
     * Deletes an existing image repository. If a repository contains images, you must use the <code>force</code> option
     * to delete it.
     * </p>
     *
     * @param deleteRepositoryRequest
     * @return Result of the DeleteRepository operation returned by the service.
     * @throws ServerException
     *         These errors are usually caused by a server-side issue.
     * @throws InvalidParameterException
     *         The specified parameter is invalid. Review the available parameters for the API request.
     * @throws RepositoryNotFoundException
     *         The specified repository could not be found. Check the spelling of the specified repository and ensure
     *         that you are performing operations on the correct registry.
     * @throws RepositoryNotEmptyException
     *         The specified repository contains images. To delete a repository that contains images, you must force the
     *         deletion with the <code>force</code> parameter.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EcrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EcrClient.DeleteRepository
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/DeleteRepository" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteRepositoryResponse deleteRepository(DeleteRepositoryRequest deleteRepositoryRequest) throws ServerException,
            InvalidParameterException, RepositoryNotFoundException, RepositoryNotEmptyException, AwsServiceException,
            SdkClientException, EcrException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an existing image repository. If a repository contains images, you must use the <code>force</code> option
     * to delete it.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteRepositoryRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteRepositoryRequest#builder()}
     * </p>
     *
     * @param deleteRepositoryRequest
     *        A {@link Consumer} that will call methods on {@link DeleteRepositoryRequest.Builder} to create a request.
     * @return Result of the DeleteRepository operation returned by the service.
     * @throws ServerException
     *         These errors are usually caused by a server-side issue.
     * @throws InvalidParameterException
     *         The specified parameter is invalid. Review the available parameters for the API request.
     * @throws RepositoryNotFoundException
     *         The specified repository could not be found. Check the spelling of the specified repository and ensure
     *         that you are performing operations on the correct registry.
     * @throws RepositoryNotEmptyException
     *         The specified repository contains images. To delete a repository that contains images, you must force the
     *         deletion with the <code>force</code> parameter.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EcrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EcrClient.DeleteRepository
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/DeleteRepository" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteRepositoryResponse deleteRepository(Consumer<DeleteRepositoryRequest.Builder> deleteRepositoryRequest)
            throws ServerException, InvalidParameterException, RepositoryNotFoundException, RepositoryNotEmptyException,
            AwsServiceException, SdkClientException, EcrException {
        return deleteRepository(DeleteRepositoryRequest.builder().applyMutation(deleteRepositoryRequest).build());
    }

    /**
     * <p>
     * Deletes the repository policy from a specified repository.
     * </p>
     *
     * @param deleteRepositoryPolicyRequest
     * @return Result of the DeleteRepositoryPolicy operation returned by the service.
     * @throws ServerException
     *         These errors are usually caused by a server-side issue.
     * @throws InvalidParameterException
     *         The specified parameter is invalid. Review the available parameters for the API request.
     * @throws RepositoryNotFoundException
     *         The specified repository could not be found. Check the spelling of the specified repository and ensure
     *         that you are performing operations on the correct registry.
     * @throws RepositoryPolicyNotFoundException
     *         The specified repository and registry combination does not have an associated repository policy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EcrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EcrClient.DeleteRepositoryPolicy
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/DeleteRepositoryPolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteRepositoryPolicyResponse deleteRepositoryPolicy(DeleteRepositoryPolicyRequest deleteRepositoryPolicyRequest)
            throws ServerException, InvalidParameterException, RepositoryNotFoundException, RepositoryPolicyNotFoundException,
            AwsServiceException, SdkClientException, EcrException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the repository policy from a specified repository.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteRepositoryPolicyRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteRepositoryPolicyRequest#builder()}
     * </p>
     *
     * @param deleteRepositoryPolicyRequest
     *        A {@link Consumer} that will call methods on {@link DeleteRepositoryPolicyRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteRepositoryPolicy operation returned by the service.
     * @throws ServerException
     *         These errors are usually caused by a server-side issue.
     * @throws InvalidParameterException
     *         The specified parameter is invalid. Review the available parameters for the API request.
     * @throws RepositoryNotFoundException
     *         The specified repository could not be found. Check the spelling of the specified repository and ensure
     *         that you are performing operations on the correct registry.
     * @throws RepositoryPolicyNotFoundException
     *         The specified repository and registry combination does not have an associated repository policy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EcrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EcrClient.DeleteRepositoryPolicy
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/DeleteRepositoryPolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteRepositoryPolicyResponse deleteRepositoryPolicy(
            Consumer<DeleteRepositoryPolicyRequest.Builder> deleteRepositoryPolicyRequest) throws ServerException,
            InvalidParameterException, RepositoryNotFoundException, RepositoryPolicyNotFoundException, AwsServiceException,
            SdkClientException, EcrException {
        return deleteRepositoryPolicy(DeleteRepositoryPolicyRequest.builder().applyMutation(deleteRepositoryPolicyRequest)
                .build());
    }

    /**
     * <p>
     * Describes the image scan findings for the specified image.
     * </p>
     *
     * @param describeImageScanFindingsRequest
     * @return Result of the DescribeImageScanFindings operation returned by the service.
     * @throws ServerException
     *         These errors are usually caused by a server-side issue.
     * @throws InvalidParameterException
     *         The specified parameter is invalid. Review the available parameters for the API request.
     * @throws RepositoryNotFoundException
     *         The specified repository could not be found. Check the spelling of the specified repository and ensure
     *         that you are performing operations on the correct registry.
     * @throws ImageNotFoundException
     *         The image requested does not exist in the specified repository.
     * @throws ScanNotFoundException
     *         The specified image scan could not be found. Ensure that image scanning is enabled on the repository and
     *         try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EcrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EcrClient.DescribeImageScanFindings
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/DescribeImageScanFindings" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeImageScanFindingsResponse describeImageScanFindings(
            DescribeImageScanFindingsRequest describeImageScanFindingsRequest) throws ServerException, InvalidParameterException,
            RepositoryNotFoundException, ImageNotFoundException, ScanNotFoundException, AwsServiceException, SdkClientException,
            EcrException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the image scan findings for the specified image.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeImageScanFindingsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeImageScanFindingsRequest#builder()}
     * </p>
     *
     * @param describeImageScanFindingsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeImageScanFindingsRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeImageScanFindings operation returned by the service.
     * @throws ServerException
     *         These errors are usually caused by a server-side issue.
     * @throws InvalidParameterException
     *         The specified parameter is invalid. Review the available parameters for the API request.
     * @throws RepositoryNotFoundException
     *         The specified repository could not be found. Check the spelling of the specified repository and ensure
     *         that you are performing operations on the correct registry.
     * @throws ImageNotFoundException
     *         The image requested does not exist in the specified repository.
     * @throws ScanNotFoundException
     *         The specified image scan could not be found. Ensure that image scanning is enabled on the repository and
     *         try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EcrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EcrClient.DescribeImageScanFindings
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/DescribeImageScanFindings" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeImageScanFindingsResponse describeImageScanFindings(
            Consumer<DescribeImageScanFindingsRequest.Builder> describeImageScanFindingsRequest) throws ServerException,
            InvalidParameterException, RepositoryNotFoundException, ImageNotFoundException, ScanNotFoundException,
            AwsServiceException, SdkClientException, EcrException {
        return describeImageScanFindings(DescribeImageScanFindingsRequest.builder()
                .applyMutation(describeImageScanFindingsRequest).build());
    }

    /**
     * <p>
     * Describes the image scan findings for the specified image.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeImageScanFindings(software.amazon.awssdk.services.ecr.model.DescribeImageScanFindingsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ecr.paginators.DescribeImageScanFindingsIterable responses = client.describeImageScanFindingsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ecr.paginators.DescribeImageScanFindingsIterable responses = client
     *             .describeImageScanFindingsPaginator(request);
     *     for (software.amazon.awssdk.services.ecr.model.DescribeImageScanFindingsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ecr.paginators.DescribeImageScanFindingsIterable responses = client.describeImageScanFindingsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeImageScanFindings(software.amazon.awssdk.services.ecr.model.DescribeImageScanFindingsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeImageScanFindingsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServerException
     *         These errors are usually caused by a server-side issue.
     * @throws InvalidParameterException
     *         The specified parameter is invalid. Review the available parameters for the API request.
     * @throws RepositoryNotFoundException
     *         The specified repository could not be found. Check the spelling of the specified repository and ensure
     *         that you are performing operations on the correct registry.
     * @throws ImageNotFoundException
     *         The image requested does not exist in the specified repository.
     * @throws ScanNotFoundException
     *         The specified image scan could not be found. Ensure that image scanning is enabled on the repository and
     *         try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EcrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EcrClient.DescribeImageScanFindings
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/DescribeImageScanFindings" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeImageScanFindingsIterable describeImageScanFindingsPaginator(
            DescribeImageScanFindingsRequest describeImageScanFindingsRequest) throws ServerException, InvalidParameterException,
            RepositoryNotFoundException, ImageNotFoundException, ScanNotFoundException, AwsServiceException, SdkClientException,
            EcrException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the image scan findings for the specified image.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeImageScanFindings(software.amazon.awssdk.services.ecr.model.DescribeImageScanFindingsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ecr.paginators.DescribeImageScanFindingsIterable responses = client.describeImageScanFindingsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ecr.paginators.DescribeImageScanFindingsIterable responses = client
     *             .describeImageScanFindingsPaginator(request);
     *     for (software.amazon.awssdk.services.ecr.model.DescribeImageScanFindingsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ecr.paginators.DescribeImageScanFindingsIterable responses = client.describeImageScanFindingsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeImageScanFindings(software.amazon.awssdk.services.ecr.model.DescribeImageScanFindingsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeImageScanFindingsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeImageScanFindingsRequest#builder()}
     * </p>
     *
     * @param describeImageScanFindingsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeImageScanFindingsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServerException
     *         These errors are usually caused by a server-side issue.
     * @throws InvalidParameterException
     *         The specified parameter is invalid. Review the available parameters for the API request.
     * @throws RepositoryNotFoundException
     *         The specified repository could not be found. Check the spelling of the specified repository and ensure
     *         that you are performing operations on the correct registry.
     * @throws ImageNotFoundException
     *         The image requested does not exist in the specified repository.
     * @throws ScanNotFoundException
     *         The specified image scan could not be found. Ensure that image scanning is enabled on the repository and
     *         try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EcrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EcrClient.DescribeImageScanFindings
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/DescribeImageScanFindings" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeImageScanFindingsIterable describeImageScanFindingsPaginator(
            Consumer<DescribeImageScanFindingsRequest.Builder> describeImageScanFindingsRequest) throws ServerException,
            InvalidParameterException, RepositoryNotFoundException, ImageNotFoundException, ScanNotFoundException,
            AwsServiceException, SdkClientException, EcrException {
        return describeImageScanFindingsPaginator(DescribeImageScanFindingsRequest.builder()
                .applyMutation(describeImageScanFindingsRequest).build());
    }

    /**
     * <p>
     * Returns metadata about the images in a repository, including image size, image tags, and creation date.
     * </p>
     * <note>
     * <p>
     * Beginning with Docker version 1.9, the Docker client compresses image layers before pushing them to a V2 Docker
     * registry. The output of the <code>docker images</code> command shows the uncompressed image size, so it may
     * return a larger image size than the image sizes returned by <a>DescribeImages</a>.
     * </p>
     * </note>
     *
     * @param describeImagesRequest
     * @return Result of the DescribeImages operation returned by the service.
     * @throws ServerException
     *         These errors are usually caused by a server-side issue.
     * @throws InvalidParameterException
     *         The specified parameter is invalid. Review the available parameters for the API request.
     * @throws RepositoryNotFoundException
     *         The specified repository could not be found. Check the spelling of the specified repository and ensure
     *         that you are performing operations on the correct registry.
     * @throws ImageNotFoundException
     *         The image requested does not exist in the specified repository.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EcrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EcrClient.DescribeImages
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/DescribeImages" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeImagesResponse describeImages(DescribeImagesRequest describeImagesRequest) throws ServerException,
            InvalidParameterException, RepositoryNotFoundException, ImageNotFoundException, AwsServiceException,
            SdkClientException, EcrException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns metadata about the images in a repository, including image size, image tags, and creation date.
     * </p>
     * <note>
     * <p>
     * Beginning with Docker version 1.9, the Docker client compresses image layers before pushing them to a V2 Docker
     * registry. The output of the <code>docker images</code> command shows the uncompressed image size, so it may
     * return a larger image size than the image sizes returned by <a>DescribeImages</a>.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeImagesRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeImagesRequest#builder()}
     * </p>
     *
     * @param describeImagesRequest
     *        A {@link Consumer} that will call methods on {@link DescribeImagesRequest.Builder} to create a request.
     * @return Result of the DescribeImages operation returned by the service.
     * @throws ServerException
     *         These errors are usually caused by a server-side issue.
     * @throws InvalidParameterException
     *         The specified parameter is invalid. Review the available parameters for the API request.
     * @throws RepositoryNotFoundException
     *         The specified repository could not be found. Check the spelling of the specified repository and ensure
     *         that you are performing operations on the correct registry.
     * @throws ImageNotFoundException
     *         The image requested does not exist in the specified repository.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EcrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EcrClient.DescribeImages
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/DescribeImages" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeImagesResponse describeImages(Consumer<DescribeImagesRequest.Builder> describeImagesRequest)
            throws ServerException, InvalidParameterException, RepositoryNotFoundException, ImageNotFoundException,
            AwsServiceException, SdkClientException, EcrException {
        return describeImages(DescribeImagesRequest.builder().applyMutation(describeImagesRequest).build());
    }

    /**
     * <p>
     * Returns metadata about the images in a repository, including image size, image tags, and creation date.
     * </p>
     * <note>
     * <p>
     * Beginning with Docker version 1.9, the Docker client compresses image layers before pushing them to a V2 Docker
     * registry. The output of the <code>docker images</code> command shows the uncompressed image size, so it may
     * return a larger image size than the image sizes returned by <a>DescribeImages</a>.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of {@link #describeImages(software.amazon.awssdk.services.ecr.model.DescribeImagesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ecr.paginators.DescribeImagesIterable responses = client.describeImagesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ecr.paginators.DescribeImagesIterable responses = client.describeImagesPaginator(request);
     *     for (software.amazon.awssdk.services.ecr.model.DescribeImagesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ecr.paginators.DescribeImagesIterable responses = client.describeImagesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeImages(software.amazon.awssdk.services.ecr.model.DescribeImagesRequest)} operation.</b>
     * </p>
     *
     * @param describeImagesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServerException
     *         These errors are usually caused by a server-side issue.
     * @throws InvalidParameterException
     *         The specified parameter is invalid. Review the available parameters for the API request.
     * @throws RepositoryNotFoundException
     *         The specified repository could not be found. Check the spelling of the specified repository and ensure
     *         that you are performing operations on the correct registry.
     * @throws ImageNotFoundException
     *         The image requested does not exist in the specified repository.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EcrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EcrClient.DescribeImages
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/DescribeImages" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeImagesIterable describeImagesPaginator(DescribeImagesRequest describeImagesRequest) throws ServerException,
            InvalidParameterException, RepositoryNotFoundException, ImageNotFoundException, AwsServiceException,
            SdkClientException, EcrException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns metadata about the images in a repository, including image size, image tags, and creation date.
     * </p>
     * <note>
     * <p>
     * Beginning with Docker version 1.9, the Docker client compresses image layers before pushing them to a V2 Docker
     * registry. The output of the <code>docker images</code> command shows the uncompressed image size, so it may
     * return a larger image size than the image sizes returned by <a>DescribeImages</a>.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of {@link #describeImages(software.amazon.awssdk.services.ecr.model.DescribeImagesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ecr.paginators.DescribeImagesIterable responses = client.describeImagesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ecr.paginators.DescribeImagesIterable responses = client.describeImagesPaginator(request);
     *     for (software.amazon.awssdk.services.ecr.model.DescribeImagesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ecr.paginators.DescribeImagesIterable responses = client.describeImagesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeImages(software.amazon.awssdk.services.ecr.model.DescribeImagesRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeImagesRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeImagesRequest#builder()}
     * </p>
     *
     * @param describeImagesRequest
     *        A {@link Consumer} that will call methods on {@link DescribeImagesRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServerException
     *         These errors are usually caused by a server-side issue.
     * @throws InvalidParameterException
     *         The specified parameter is invalid. Review the available parameters for the API request.
     * @throws RepositoryNotFoundException
     *         The specified repository could not be found. Check the spelling of the specified repository and ensure
     *         that you are performing operations on the correct registry.
     * @throws ImageNotFoundException
     *         The image requested does not exist in the specified repository.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EcrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EcrClient.DescribeImages
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/DescribeImages" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeImagesIterable describeImagesPaginator(Consumer<DescribeImagesRequest.Builder> describeImagesRequest)
            throws ServerException, InvalidParameterException, RepositoryNotFoundException, ImageNotFoundException,
            AwsServiceException, SdkClientException, EcrException {
        return describeImagesPaginator(DescribeImagesRequest.builder().applyMutation(describeImagesRequest).build());
    }

    /**
     * <p>
     * Describes image repositories in a registry.
     * </p>
     *
     * @return Result of the DescribeRepositories operation returned by the service.
     * @throws ServerException
     *         These errors are usually caused by a server-side issue.
     * @throws InvalidParameterException
     *         The specified parameter is invalid. Review the available parameters for the API request.
     * @throws RepositoryNotFoundException
     *         The specified repository could not be found. Check the spelling of the specified repository and ensure
     *         that you are performing operations on the correct registry.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EcrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EcrClient.DescribeRepositories
     * @see #describeRepositories(DescribeRepositoriesRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/DescribeRepositories" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeRepositoriesResponse describeRepositories() throws ServerException, InvalidParameterException,
            RepositoryNotFoundException, AwsServiceException, SdkClientException, EcrException {
        return describeRepositories(DescribeRepositoriesRequest.builder().build());
    }

    /**
     * <p>
     * Describes image repositories in a registry.
     * </p>
     *
     * @param describeRepositoriesRequest
     * @return Result of the DescribeRepositories operation returned by the service.
     * @throws ServerException
     *         These errors are usually caused by a server-side issue.
     * @throws InvalidParameterException
     *         The specified parameter is invalid. Review the available parameters for the API request.
     * @throws RepositoryNotFoundException
     *         The specified repository could not be found. Check the spelling of the specified repository and ensure
     *         that you are performing operations on the correct registry.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EcrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EcrClient.DescribeRepositories
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/DescribeRepositories" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeRepositoriesResponse describeRepositories(DescribeRepositoriesRequest describeRepositoriesRequest)
            throws ServerException, InvalidParameterException, RepositoryNotFoundException, AwsServiceException,
            SdkClientException, EcrException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes image repositories in a registry.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeRepositoriesRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeRepositoriesRequest#builder()}
     * </p>
     *
     * @param describeRepositoriesRequest
     *        A {@link Consumer} that will call methods on {@link DescribeRepositoriesRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeRepositories operation returned by the service.
     * @throws ServerException
     *         These errors are usually caused by a server-side issue.
     * @throws InvalidParameterException
     *         The specified parameter is invalid. Review the available parameters for the API request.
     * @throws RepositoryNotFoundException
     *         The specified repository could not be found. Check the spelling of the specified repository and ensure
     *         that you are performing operations on the correct registry.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EcrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EcrClient.DescribeRepositories
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/DescribeRepositories" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeRepositoriesResponse describeRepositories(
            Consumer<DescribeRepositoriesRequest.Builder> describeRepositoriesRequest) throws ServerException,
            InvalidParameterException, RepositoryNotFoundException, AwsServiceException, SdkClientException, EcrException {
        return describeRepositories(DescribeRepositoriesRequest.builder().applyMutation(describeRepositoriesRequest).build());
    }

    /**
     * <p>
     * Describes image repositories in a registry.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeRepositories(software.amazon.awssdk.services.ecr.model.DescribeRepositoriesRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ecr.paginators.DescribeRepositoriesIterable responses = client.describeRepositoriesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ecr.paginators.DescribeRepositoriesIterable responses = client
     *             .describeRepositoriesPaginator(request);
     *     for (software.amazon.awssdk.services.ecr.model.DescribeRepositoriesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ecr.paginators.DescribeRepositoriesIterable responses = client.describeRepositoriesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeRepositories(software.amazon.awssdk.services.ecr.model.DescribeRepositoriesRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServerException
     *         These errors are usually caused by a server-side issue.
     * @throws InvalidParameterException
     *         The specified parameter is invalid. Review the available parameters for the API request.
     * @throws RepositoryNotFoundException
     *         The specified repository could not be found. Check the spelling of the specified repository and ensure
     *         that you are performing operations on the correct registry.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EcrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EcrClient.DescribeRepositories
     * @see #describeRepositoriesPaginator(DescribeRepositoriesRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/DescribeRepositories" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeRepositoriesIterable describeRepositoriesPaginator() throws ServerException, InvalidParameterException,
            RepositoryNotFoundException, AwsServiceException, SdkClientException, EcrException {
        return describeRepositoriesPaginator(DescribeRepositoriesRequest.builder().build());
    }

    /**
     * <p>
     * Describes image repositories in a registry.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeRepositories(software.amazon.awssdk.services.ecr.model.DescribeRepositoriesRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ecr.paginators.DescribeRepositoriesIterable responses = client.describeRepositoriesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ecr.paginators.DescribeRepositoriesIterable responses = client
     *             .describeRepositoriesPaginator(request);
     *     for (software.amazon.awssdk.services.ecr.model.DescribeRepositoriesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ecr.paginators.DescribeRepositoriesIterable responses = client.describeRepositoriesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeRepositories(software.amazon.awssdk.services.ecr.model.DescribeRepositoriesRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeRepositoriesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServerException
     *         These errors are usually caused by a server-side issue.
     * @throws InvalidParameterException
     *         The specified parameter is invalid. Review the available parameters for the API request.
     * @throws RepositoryNotFoundException
     *         The specified repository could not be found. Check the spelling of the specified repository and ensure
     *         that you are performing operations on the correct registry.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EcrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EcrClient.DescribeRepositories
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/DescribeRepositories" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeRepositoriesIterable describeRepositoriesPaginator(DescribeRepositoriesRequest describeRepositoriesRequest)
            throws ServerException, InvalidParameterException, RepositoryNotFoundException, AwsServiceException,
            SdkClientException, EcrException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes image repositories in a registry.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeRepositories(software.amazon.awssdk.services.ecr.model.DescribeRepositoriesRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ecr.paginators.DescribeRepositoriesIterable responses = client.describeRepositoriesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ecr.paginators.DescribeRepositoriesIterable responses = client
     *             .describeRepositoriesPaginator(request);
     *     for (software.amazon.awssdk.services.ecr.model.DescribeRepositoriesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ecr.paginators.DescribeRepositoriesIterable responses = client.describeRepositoriesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeRepositories(software.amazon.awssdk.services.ecr.model.DescribeRepositoriesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeRepositoriesRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeRepositoriesRequest#builder()}
     * </p>
     *
     * @param describeRepositoriesRequest
     *        A {@link Consumer} that will call methods on {@link DescribeRepositoriesRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServerException
     *         These errors are usually caused by a server-side issue.
     * @throws InvalidParameterException
     *         The specified parameter is invalid. Review the available parameters for the API request.
     * @throws RepositoryNotFoundException
     *         The specified repository could not be found. Check the spelling of the specified repository and ensure
     *         that you are performing operations on the correct registry.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EcrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EcrClient.DescribeRepositories
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/DescribeRepositories" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeRepositoriesIterable describeRepositoriesPaginator(
            Consumer<DescribeRepositoriesRequest.Builder> describeRepositoriesRequest) throws ServerException,
            InvalidParameterException, RepositoryNotFoundException, AwsServiceException, SdkClientException, EcrException {
        return describeRepositoriesPaginator(DescribeRepositoriesRequest.builder().applyMutation(describeRepositoriesRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves a token that is valid for a specified registry for 12 hours. This command allows you to use the
     * <code>docker</code> CLI to push and pull images with Amazon ECR. If you do not specify a registry, the default
     * registry is assumed.
     * </p>
     * <p>
     * The <code>authorizationToken</code> returned for each registry specified is a base64 encoded string that can be
     * decoded and used in a <code>docker login</code> command to authenticate to a registry. The AWS CLI offers an
     * <code>aws ecr get-login</code> command that simplifies the login process.
     * </p>
     *
     * @return Result of the GetAuthorizationToken operation returned by the service.
     * @throws ServerException
     *         These errors are usually caused by a server-side issue.
     * @throws InvalidParameterException
     *         The specified parameter is invalid. Review the available parameters for the API request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EcrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EcrClient.GetAuthorizationToken
     * @see #getAuthorizationToken(GetAuthorizationTokenRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/GetAuthorizationToken" target="_top">AWS API
     *      Documentation</a>
     */
    default GetAuthorizationTokenResponse getAuthorizationToken() throws ServerException, InvalidParameterException,
            AwsServiceException, SdkClientException, EcrException {
        return getAuthorizationToken(GetAuthorizationTokenRequest.builder().build());
    }

    /**
     * <p>
     * Retrieves a token that is valid for a specified registry for 12 hours. This command allows you to use the
     * <code>docker</code> CLI to push and pull images with Amazon ECR. If you do not specify a registry, the default
     * registry is assumed.
     * </p>
     * <p>
     * The <code>authorizationToken</code> returned for each registry specified is a base64 encoded string that can be
     * decoded and used in a <code>docker login</code> command to authenticate to a registry. The AWS CLI offers an
     * <code>aws ecr get-login</code> command that simplifies the login process.
     * </p>
     *
     * @param getAuthorizationTokenRequest
     * @return Result of the GetAuthorizationToken operation returned by the service.
     * @throws ServerException
     *         These errors are usually caused by a server-side issue.
     * @throws InvalidParameterException
     *         The specified parameter is invalid. Review the available parameters for the API request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EcrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EcrClient.GetAuthorizationToken
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/GetAuthorizationToken" target="_top">AWS API
     *      Documentation</a>
     */
    default GetAuthorizationTokenResponse getAuthorizationToken(GetAuthorizationTokenRequest getAuthorizationTokenRequest)
            throws ServerException, InvalidParameterException, AwsServiceException, SdkClientException, EcrException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a token that is valid for a specified registry for 12 hours. This command allows you to use the
     * <code>docker</code> CLI to push and pull images with Amazon ECR. If you do not specify a registry, the default
     * registry is assumed.
     * </p>
     * <p>
     * The <code>authorizationToken</code> returned for each registry specified is a base64 encoded string that can be
     * decoded and used in a <code>docker login</code> command to authenticate to a registry. The AWS CLI offers an
     * <code>aws ecr get-login</code> command that simplifies the login process.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAuthorizationTokenRequest.Builder} avoiding the
     * need to create one manually via {@link GetAuthorizationTokenRequest#builder()}
     * </p>
     *
     * @param getAuthorizationTokenRequest
     *        A {@link Consumer} that will call methods on {@link GetAuthorizationTokenRequest.Builder} to create a
     *        request.
     * @return Result of the GetAuthorizationToken operation returned by the service.
     * @throws ServerException
     *         These errors are usually caused by a server-side issue.
     * @throws InvalidParameterException
     *         The specified parameter is invalid. Review the available parameters for the API request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EcrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EcrClient.GetAuthorizationToken
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/GetAuthorizationToken" target="_top">AWS API
     *      Documentation</a>
     */
    default GetAuthorizationTokenResponse getAuthorizationToken(
            Consumer<GetAuthorizationTokenRequest.Builder> getAuthorizationTokenRequest) throws ServerException,
            InvalidParameterException, AwsServiceException, SdkClientException, EcrException {
        return getAuthorizationToken(GetAuthorizationTokenRequest.builder().applyMutation(getAuthorizationTokenRequest).build());
    }

    /**
     * <p>
     * Retrieves the pre-signed Amazon S3 download URL corresponding to an image layer. You can only get URLs for image
     * layers that are referenced in an image.
     * </p>
     * <note>
     * <p>
     * This operation is used by the Amazon ECR proxy, and it is not intended for general use by customers for pulling
     * and pushing images. In most cases, you should use the <code>docker</code> CLI to pull, tag, and push images.
     * </p>
     * </note>
     *
     * @param getDownloadUrlForLayerRequest
     * @return Result of the GetDownloadUrlForLayer operation returned by the service.
     * @throws ServerException
     *         These errors are usually caused by a server-side issue.
     * @throws InvalidParameterException
     *         The specified parameter is invalid. Review the available parameters for the API request.
     * @throws LayersNotFoundException
     *         The specified layers could not be found, or the specified layer is not valid for this repository.
     * @throws LayerInaccessibleException
     *         The specified layer is not available because it is not associated with an image. Unassociated image
     *         layers may be cleaned up at any time.
     * @throws RepositoryNotFoundException
     *         The specified repository could not be found. Check the spelling of the specified repository and ensure
     *         that you are performing operations on the correct registry.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EcrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EcrClient.GetDownloadUrlForLayer
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/GetDownloadUrlForLayer" target="_top">AWS API
     *      Documentation</a>
     */
    default GetDownloadUrlForLayerResponse getDownloadUrlForLayer(GetDownloadUrlForLayerRequest getDownloadUrlForLayerRequest)
            throws ServerException, InvalidParameterException, LayersNotFoundException, LayerInaccessibleException,
            RepositoryNotFoundException, AwsServiceException, SdkClientException, EcrException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the pre-signed Amazon S3 download URL corresponding to an image layer. You can only get URLs for image
     * layers that are referenced in an image.
     * </p>
     * <note>
     * <p>
     * This operation is used by the Amazon ECR proxy, and it is not intended for general use by customers for pulling
     * and pushing images. In most cases, you should use the <code>docker</code> CLI to pull, tag, and push images.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDownloadUrlForLayerRequest.Builder} avoiding the
     * need to create one manually via {@link GetDownloadUrlForLayerRequest#builder()}
     * </p>
     *
     * @param getDownloadUrlForLayerRequest
     *        A {@link Consumer} that will call methods on {@link GetDownloadUrlForLayerRequest.Builder} to create a
     *        request.
     * @return Result of the GetDownloadUrlForLayer operation returned by the service.
     * @throws ServerException
     *         These errors are usually caused by a server-side issue.
     * @throws InvalidParameterException
     *         The specified parameter is invalid. Review the available parameters for the API request.
     * @throws LayersNotFoundException
     *         The specified layers could not be found, or the specified layer is not valid for this repository.
     * @throws LayerInaccessibleException
     *         The specified layer is not available because it is not associated with an image. Unassociated image
     *         layers may be cleaned up at any time.
     * @throws RepositoryNotFoundException
     *         The specified repository could not be found. Check the spelling of the specified repository and ensure
     *         that you are performing operations on the correct registry.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EcrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EcrClient.GetDownloadUrlForLayer
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/GetDownloadUrlForLayer" target="_top">AWS API
     *      Documentation</a>
     */
    default GetDownloadUrlForLayerResponse getDownloadUrlForLayer(
            Consumer<GetDownloadUrlForLayerRequest.Builder> getDownloadUrlForLayerRequest) throws ServerException,
            InvalidParameterException, LayersNotFoundException, LayerInaccessibleException, RepositoryNotFoundException,
            AwsServiceException, SdkClientException, EcrException {
        return getDownloadUrlForLayer(GetDownloadUrlForLayerRequest.builder().applyMutation(getDownloadUrlForLayerRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves the specified lifecycle policy.
     * </p>
     *
     * @param getLifecyclePolicyRequest
     * @return Result of the GetLifecyclePolicy operation returned by the service.
     * @throws ServerException
     *         These errors are usually caused by a server-side issue.
     * @throws InvalidParameterException
     *         The specified parameter is invalid. Review the available parameters for the API request.
     * @throws RepositoryNotFoundException
     *         The specified repository could not be found. Check the spelling of the specified repository and ensure
     *         that you are performing operations on the correct registry.
     * @throws LifecyclePolicyNotFoundException
     *         The lifecycle policy could not be found, and no policy is set to the repository.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EcrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EcrClient.GetLifecyclePolicy
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/GetLifecyclePolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default GetLifecyclePolicyResponse getLifecyclePolicy(GetLifecyclePolicyRequest getLifecyclePolicyRequest)
            throws ServerException, InvalidParameterException, RepositoryNotFoundException, LifecyclePolicyNotFoundException,
            AwsServiceException, SdkClientException, EcrException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the specified lifecycle policy.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetLifecyclePolicyRequest.Builder} avoiding the
     * need to create one manually via {@link GetLifecyclePolicyRequest#builder()}
     * </p>
     *
     * @param getLifecyclePolicyRequest
     *        A {@link Consumer} that will call methods on {@link GetLifecyclePolicyRequest.Builder} to create a
     *        request.
     * @return Result of the GetLifecyclePolicy operation returned by the service.
     * @throws ServerException
     *         These errors are usually caused by a server-side issue.
     * @throws InvalidParameterException
     *         The specified parameter is invalid. Review the available parameters for the API request.
     * @throws RepositoryNotFoundException
     *         The specified repository could not be found. Check the spelling of the specified repository and ensure
     *         that you are performing operations on the correct registry.
     * @throws LifecyclePolicyNotFoundException
     *         The lifecycle policy could not be found, and no policy is set to the repository.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EcrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EcrClient.GetLifecyclePolicy
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/GetLifecyclePolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default GetLifecyclePolicyResponse getLifecyclePolicy(Consumer<GetLifecyclePolicyRequest.Builder> getLifecyclePolicyRequest)
            throws ServerException, InvalidParameterException, RepositoryNotFoundException, LifecyclePolicyNotFoundException,
            AwsServiceException, SdkClientException, EcrException {
        return getLifecyclePolicy(GetLifecyclePolicyRequest.builder().applyMutation(getLifecyclePolicyRequest).build());
    }

    /**
     * <p>
     * Retrieves the results of the specified lifecycle policy preview request.
     * </p>
     *
     * @param getLifecyclePolicyPreviewRequest
     * @return Result of the GetLifecyclePolicyPreview operation returned by the service.
     * @throws ServerException
     *         These errors are usually caused by a server-side issue.
     * @throws InvalidParameterException
     *         The specified parameter is invalid. Review the available parameters for the API request.
     * @throws RepositoryNotFoundException
     *         The specified repository could not be found. Check the spelling of the specified repository and ensure
     *         that you are performing operations on the correct registry.
     * @throws LifecyclePolicyPreviewNotFoundException
     *         There is no dry run for this repository.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EcrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EcrClient.GetLifecyclePolicyPreview
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/GetLifecyclePolicyPreview" target="_top">AWS
     *      API Documentation</a>
     */
    default GetLifecyclePolicyPreviewResponse getLifecyclePolicyPreview(
            GetLifecyclePolicyPreviewRequest getLifecyclePolicyPreviewRequest) throws ServerException, InvalidParameterException,
            RepositoryNotFoundException, LifecyclePolicyPreviewNotFoundException, AwsServiceException, SdkClientException,
            EcrException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the results of the specified lifecycle policy preview request.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetLifecyclePolicyPreviewRequest.Builder} avoiding
     * the need to create one manually via {@link GetLifecyclePolicyPreviewRequest#builder()}
     * </p>
     *
     * @param getLifecyclePolicyPreviewRequest
     *        A {@link Consumer} that will call methods on {@link GetLifecyclePolicyPreviewRequest.Builder} to create a
     *        request.
     * @return Result of the GetLifecyclePolicyPreview operation returned by the service.
     * @throws ServerException
     *         These errors are usually caused by a server-side issue.
     * @throws InvalidParameterException
     *         The specified parameter is invalid. Review the available parameters for the API request.
     * @throws RepositoryNotFoundException
     *         The specified repository could not be found. Check the spelling of the specified repository and ensure
     *         that you are performing operations on the correct registry.
     * @throws LifecyclePolicyPreviewNotFoundException
     *         There is no dry run for this repository.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EcrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EcrClient.GetLifecyclePolicyPreview
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/GetLifecyclePolicyPreview" target="_top">AWS
     *      API Documentation</a>
     */
    default GetLifecyclePolicyPreviewResponse getLifecyclePolicyPreview(
            Consumer<GetLifecyclePolicyPreviewRequest.Builder> getLifecyclePolicyPreviewRequest) throws ServerException,
            InvalidParameterException, RepositoryNotFoundException, LifecyclePolicyPreviewNotFoundException, AwsServiceException,
            SdkClientException, EcrException {
        return getLifecyclePolicyPreview(GetLifecyclePolicyPreviewRequest.builder()
                .applyMutation(getLifecyclePolicyPreviewRequest).build());
    }

    /**
     * <p>
     * Retrieves the results of the specified lifecycle policy preview request.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getLifecyclePolicyPreview(software.amazon.awssdk.services.ecr.model.GetLifecyclePolicyPreviewRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ecr.paginators.GetLifecyclePolicyPreviewIterable responses = client.getLifecyclePolicyPreviewPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ecr.paginators.GetLifecyclePolicyPreviewIterable responses = client
     *             .getLifecyclePolicyPreviewPaginator(request);
     *     for (software.amazon.awssdk.services.ecr.model.GetLifecyclePolicyPreviewResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ecr.paginators.GetLifecyclePolicyPreviewIterable responses = client.getLifecyclePolicyPreviewPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getLifecyclePolicyPreview(software.amazon.awssdk.services.ecr.model.GetLifecyclePolicyPreviewRequest)}
     * operation.</b>
     * </p>
     *
     * @param getLifecyclePolicyPreviewRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServerException
     *         These errors are usually caused by a server-side issue.
     * @throws InvalidParameterException
     *         The specified parameter is invalid. Review the available parameters for the API request.
     * @throws RepositoryNotFoundException
     *         The specified repository could not be found. Check the spelling of the specified repository and ensure
     *         that you are performing operations on the correct registry.
     * @throws LifecyclePolicyPreviewNotFoundException
     *         There is no dry run for this repository.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EcrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EcrClient.GetLifecyclePolicyPreview
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/GetLifecyclePolicyPreview" target="_top">AWS
     *      API Documentation</a>
     */
    default GetLifecyclePolicyPreviewIterable getLifecyclePolicyPreviewPaginator(
            GetLifecyclePolicyPreviewRequest getLifecyclePolicyPreviewRequest) throws ServerException, InvalidParameterException,
            RepositoryNotFoundException, LifecyclePolicyPreviewNotFoundException, AwsServiceException, SdkClientException,
            EcrException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the results of the specified lifecycle policy preview request.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getLifecyclePolicyPreview(software.amazon.awssdk.services.ecr.model.GetLifecyclePolicyPreviewRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ecr.paginators.GetLifecyclePolicyPreviewIterable responses = client.getLifecyclePolicyPreviewPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ecr.paginators.GetLifecyclePolicyPreviewIterable responses = client
     *             .getLifecyclePolicyPreviewPaginator(request);
     *     for (software.amazon.awssdk.services.ecr.model.GetLifecyclePolicyPreviewResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ecr.paginators.GetLifecyclePolicyPreviewIterable responses = client.getLifecyclePolicyPreviewPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getLifecyclePolicyPreview(software.amazon.awssdk.services.ecr.model.GetLifecyclePolicyPreviewRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetLifecyclePolicyPreviewRequest.Builder} avoiding
     * the need to create one manually via {@link GetLifecyclePolicyPreviewRequest#builder()}
     * </p>
     *
     * @param getLifecyclePolicyPreviewRequest
     *        A {@link Consumer} that will call methods on {@link GetLifecyclePolicyPreviewRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServerException
     *         These errors are usually caused by a server-side issue.
     * @throws InvalidParameterException
     *         The specified parameter is invalid. Review the available parameters for the API request.
     * @throws RepositoryNotFoundException
     *         The specified repository could not be found. Check the spelling of the specified repository and ensure
     *         that you are performing operations on the correct registry.
     * @throws LifecyclePolicyPreviewNotFoundException
     *         There is no dry run for this repository.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EcrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EcrClient.GetLifecyclePolicyPreview
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/GetLifecyclePolicyPreview" target="_top">AWS
     *      API Documentation</a>
     */
    default GetLifecyclePolicyPreviewIterable getLifecyclePolicyPreviewPaginator(
            Consumer<GetLifecyclePolicyPreviewRequest.Builder> getLifecyclePolicyPreviewRequest) throws ServerException,
            InvalidParameterException, RepositoryNotFoundException, LifecyclePolicyPreviewNotFoundException, AwsServiceException,
            SdkClientException, EcrException {
        return getLifecyclePolicyPreviewPaginator(GetLifecyclePolicyPreviewRequest.builder()
                .applyMutation(getLifecyclePolicyPreviewRequest).build());
    }

    /**
     * <p>
     * Retrieves the repository policy for a specified repository.
     * </p>
     *
     * @param getRepositoryPolicyRequest
     * @return Result of the GetRepositoryPolicy operation returned by the service.
     * @throws ServerException
     *         These errors are usually caused by a server-side issue.
     * @throws InvalidParameterException
     *         The specified parameter is invalid. Review the available parameters for the API request.
     * @throws RepositoryNotFoundException
     *         The specified repository could not be found. Check the spelling of the specified repository and ensure
     *         that you are performing operations on the correct registry.
     * @throws RepositoryPolicyNotFoundException
     *         The specified repository and registry combination does not have an associated repository policy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EcrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EcrClient.GetRepositoryPolicy
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/GetRepositoryPolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default GetRepositoryPolicyResponse getRepositoryPolicy(GetRepositoryPolicyRequest getRepositoryPolicyRequest)
            throws ServerException, InvalidParameterException, RepositoryNotFoundException, RepositoryPolicyNotFoundException,
            AwsServiceException, SdkClientException, EcrException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the repository policy for a specified repository.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetRepositoryPolicyRequest.Builder} avoiding the
     * need to create one manually via {@link GetRepositoryPolicyRequest#builder()}
     * </p>
     *
     * @param getRepositoryPolicyRequest
     *        A {@link Consumer} that will call methods on {@link GetRepositoryPolicyRequest.Builder} to create a
     *        request.
     * @return Result of the GetRepositoryPolicy operation returned by the service.
     * @throws ServerException
     *         These errors are usually caused by a server-side issue.
     * @throws InvalidParameterException
     *         The specified parameter is invalid. Review the available parameters for the API request.
     * @throws RepositoryNotFoundException
     *         The specified repository could not be found. Check the spelling of the specified repository and ensure
     *         that you are performing operations on the correct registry.
     * @throws RepositoryPolicyNotFoundException
     *         The specified repository and registry combination does not have an associated repository policy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EcrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EcrClient.GetRepositoryPolicy
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/GetRepositoryPolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default GetRepositoryPolicyResponse getRepositoryPolicy(
            Consumer<GetRepositoryPolicyRequest.Builder> getRepositoryPolicyRequest) throws ServerException,
            InvalidParameterException, RepositoryNotFoundException, RepositoryPolicyNotFoundException, AwsServiceException,
            SdkClientException, EcrException {
        return getRepositoryPolicy(GetRepositoryPolicyRequest.builder().applyMutation(getRepositoryPolicyRequest).build());
    }

    /**
     * <p>
     * Notify Amazon ECR that you intend to upload an image layer.
     * </p>
     * <note>
     * <p>
     * This operation is used by the Amazon ECR proxy, and it is not intended for general use by customers for pulling
     * and pushing images. In most cases, you should use the <code>docker</code> CLI to pull, tag, and push images.
     * </p>
     * </note>
     *
     * @param initiateLayerUploadRequest
     * @return Result of the InitiateLayerUpload operation returned by the service.
     * @throws ServerException
     *         These errors are usually caused by a server-side issue.
     * @throws InvalidParameterException
     *         The specified parameter is invalid. Review the available parameters for the API request.
     * @throws RepositoryNotFoundException
     *         The specified repository could not be found. Check the spelling of the specified repository and ensure
     *         that you are performing operations on the correct registry.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EcrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EcrClient.InitiateLayerUpload
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/InitiateLayerUpload" target="_top">AWS API
     *      Documentation</a>
     */
    default InitiateLayerUploadResponse initiateLayerUpload(InitiateLayerUploadRequest initiateLayerUploadRequest)
            throws ServerException, InvalidParameterException, RepositoryNotFoundException, AwsServiceException,
            SdkClientException, EcrException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Notify Amazon ECR that you intend to upload an image layer.
     * </p>
     * <note>
     * <p>
     * This operation is used by the Amazon ECR proxy, and it is not intended for general use by customers for pulling
     * and pushing images. In most cases, you should use the <code>docker</code> CLI to pull, tag, and push images.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link InitiateLayerUploadRequest.Builder} avoiding the
     * need to create one manually via {@link InitiateLayerUploadRequest#builder()}
     * </p>
     *
     * @param initiateLayerUploadRequest
     *        A {@link Consumer} that will call methods on {@link InitiateLayerUploadRequest.Builder} to create a
     *        request.
     * @return Result of the InitiateLayerUpload operation returned by the service.
     * @throws ServerException
     *         These errors are usually caused by a server-side issue.
     * @throws InvalidParameterException
     *         The specified parameter is invalid. Review the available parameters for the API request.
     * @throws RepositoryNotFoundException
     *         The specified repository could not be found. Check the spelling of the specified repository and ensure
     *         that you are performing operations on the correct registry.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EcrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EcrClient.InitiateLayerUpload
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/InitiateLayerUpload" target="_top">AWS API
     *      Documentation</a>
     */
    default InitiateLayerUploadResponse initiateLayerUpload(
            Consumer<InitiateLayerUploadRequest.Builder> initiateLayerUploadRequest) throws ServerException,
            InvalidParameterException, RepositoryNotFoundException, AwsServiceException, SdkClientException, EcrException {
        return initiateLayerUpload(InitiateLayerUploadRequest.builder().applyMutation(initiateLayerUploadRequest).build());
    }

    /**
     * <p>
     * Lists all the image IDs for a given repository.
     * </p>
     * <p>
     * You can filter images based on whether or not they are tagged by setting the <code>tagStatus</code> parameter to
     * <code>TAGGED</code> or <code>UNTAGGED</code>. For example, you can filter your results to return only
     * <code>UNTAGGED</code> images and then pipe that result to a <a>BatchDeleteImage</a> operation to delete them. Or,
     * you can filter your results to return only <code>TAGGED</code> images to list all of the tags in your repository.
     * </p>
     *
     * @param listImagesRequest
     * @return Result of the ListImages operation returned by the service.
     * @throws ServerException
     *         These errors are usually caused by a server-side issue.
     * @throws InvalidParameterException
     *         The specified parameter is invalid. Review the available parameters for the API request.
     * @throws RepositoryNotFoundException
     *         The specified repository could not be found. Check the spelling of the specified repository and ensure
     *         that you are performing operations on the correct registry.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EcrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EcrClient.ListImages
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/ListImages" target="_top">AWS API
     *      Documentation</a>
     */
    default ListImagesResponse listImages(ListImagesRequest listImagesRequest) throws ServerException, InvalidParameterException,
            RepositoryNotFoundException, AwsServiceException, SdkClientException, EcrException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all the image IDs for a given repository.
     * </p>
     * <p>
     * You can filter images based on whether or not they are tagged by setting the <code>tagStatus</code> parameter to
     * <code>TAGGED</code> or <code>UNTAGGED</code>. For example, you can filter your results to return only
     * <code>UNTAGGED</code> images and then pipe that result to a <a>BatchDeleteImage</a> operation to delete them. Or,
     * you can filter your results to return only <code>TAGGED</code> images to list all of the tags in your repository.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListImagesRequest.Builder} avoiding the need to
     * create one manually via {@link ListImagesRequest#builder()}
     * </p>
     *
     * @param listImagesRequest
     *        A {@link Consumer} that will call methods on {@link ListImagesRequest.Builder} to create a request.
     * @return Result of the ListImages operation returned by the service.
     * @throws ServerException
     *         These errors are usually caused by a server-side issue.
     * @throws InvalidParameterException
     *         The specified parameter is invalid. Review the available parameters for the API request.
     * @throws RepositoryNotFoundException
     *         The specified repository could not be found. Check the spelling of the specified repository and ensure
     *         that you are performing operations on the correct registry.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EcrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EcrClient.ListImages
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/ListImages" target="_top">AWS API
     *      Documentation</a>
     */
    default ListImagesResponse listImages(Consumer<ListImagesRequest.Builder> listImagesRequest) throws ServerException,
            InvalidParameterException, RepositoryNotFoundException, AwsServiceException, SdkClientException, EcrException {
        return listImages(ListImagesRequest.builder().applyMutation(listImagesRequest).build());
    }

    /**
     * <p>
     * Lists all the image IDs for a given repository.
     * </p>
     * <p>
     * You can filter images based on whether or not they are tagged by setting the <code>tagStatus</code> parameter to
     * <code>TAGGED</code> or <code>UNTAGGED</code>. For example, you can filter your results to return only
     * <code>UNTAGGED</code> images and then pipe that result to a <a>BatchDeleteImage</a> operation to delete them. Or,
     * you can filter your results to return only <code>TAGGED</code> images to list all of the tags in your repository.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listImages(software.amazon.awssdk.services.ecr.model.ListImagesRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ecr.paginators.ListImagesIterable responses = client.listImagesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ecr.paginators.ListImagesIterable responses = client.listImagesPaginator(request);
     *     for (software.amazon.awssdk.services.ecr.model.ListImagesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ecr.paginators.ListImagesIterable responses = client.listImagesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listImages(software.amazon.awssdk.services.ecr.model.ListImagesRequest)} operation.</b>
     * </p>
     *
     * @param listImagesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServerException
     *         These errors are usually caused by a server-side issue.
     * @throws InvalidParameterException
     *         The specified parameter is invalid. Review the available parameters for the API request.
     * @throws RepositoryNotFoundException
     *         The specified repository could not be found. Check the spelling of the specified repository and ensure
     *         that you are performing operations on the correct registry.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EcrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EcrClient.ListImages
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/ListImages" target="_top">AWS API
     *      Documentation</a>
     */
    default ListImagesIterable listImagesPaginator(ListImagesRequest listImagesRequest) throws ServerException,
            InvalidParameterException, RepositoryNotFoundException, AwsServiceException, SdkClientException, EcrException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all the image IDs for a given repository.
     * </p>
     * <p>
     * You can filter images based on whether or not they are tagged by setting the <code>tagStatus</code> parameter to
     * <code>TAGGED</code> or <code>UNTAGGED</code>. For example, you can filter your results to return only
     * <code>UNTAGGED</code> images and then pipe that result to a <a>BatchDeleteImage</a> operation to delete them. Or,
     * you can filter your results to return only <code>TAGGED</code> images to list all of the tags in your repository.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listImages(software.amazon.awssdk.services.ecr.model.ListImagesRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ecr.paginators.ListImagesIterable responses = client.listImagesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ecr.paginators.ListImagesIterable responses = client.listImagesPaginator(request);
     *     for (software.amazon.awssdk.services.ecr.model.ListImagesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ecr.paginators.ListImagesIterable responses = client.listImagesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listImages(software.amazon.awssdk.services.ecr.model.ListImagesRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListImagesRequest.Builder} avoiding the need to
     * create one manually via {@link ListImagesRequest#builder()}
     * </p>
     *
     * @param listImagesRequest
     *        A {@link Consumer} that will call methods on {@link ListImagesRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServerException
     *         These errors are usually caused by a server-side issue.
     * @throws InvalidParameterException
     *         The specified parameter is invalid. Review the available parameters for the API request.
     * @throws RepositoryNotFoundException
     *         The specified repository could not be found. Check the spelling of the specified repository and ensure
     *         that you are performing operations on the correct registry.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EcrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EcrClient.ListImages
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/ListImages" target="_top">AWS API
     *      Documentation</a>
     */
    default ListImagesIterable listImagesPaginator(Consumer<ListImagesRequest.Builder> listImagesRequest) throws ServerException,
            InvalidParameterException, RepositoryNotFoundException, AwsServiceException, SdkClientException, EcrException {
        return listImagesPaginator(ListImagesRequest.builder().applyMutation(listImagesRequest).build());
    }

    /**
     * <p>
     * List the tags for an Amazon ECR resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws InvalidParameterException
     *         The specified parameter is invalid. Review the available parameters for the API request.
     * @throws RepositoryNotFoundException
     *         The specified repository could not be found. Check the spelling of the specified repository and ensure
     *         that you are performing operations on the correct registry.
     * @throws ServerException
     *         These errors are usually caused by a server-side issue.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EcrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EcrClient.ListTagsForResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/ListTagsForResource" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws InvalidParameterException, RepositoryNotFoundException, ServerException, AwsServiceException,
            SdkClientException, EcrException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List the tags for an Amazon ECR resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on {@link ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws InvalidParameterException
     *         The specified parameter is invalid. Review the available parameters for the API request.
     * @throws RepositoryNotFoundException
     *         The specified repository could not be found. Check the spelling of the specified repository and ensure
     *         that you are performing operations on the correct registry.
     * @throws ServerException
     *         These errors are usually caused by a server-side issue.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EcrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EcrClient.ListTagsForResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/ListTagsForResource" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws InvalidParameterException,
            RepositoryNotFoundException, ServerException, AwsServiceException, SdkClientException, EcrException {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Creates or updates the image manifest and tags associated with an image.
     * </p>
     * <note>
     * <p>
     * This operation is used by the Amazon ECR proxy, and it is not intended for general use by customers for pulling
     * and pushing images. In most cases, you should use the <code>docker</code> CLI to pull, tag, and push images.
     * </p>
     * </note>
     *
     * @param putImageRequest
     * @return Result of the PutImage operation returned by the service.
     * @throws ServerException
     *         These errors are usually caused by a server-side issue.
     * @throws InvalidParameterException
     *         The specified parameter is invalid. Review the available parameters for the API request.
     * @throws RepositoryNotFoundException
     *         The specified repository could not be found. Check the spelling of the specified repository and ensure
     *         that you are performing operations on the correct registry.
     * @throws ImageAlreadyExistsException
     *         The specified image has already been pushed, and there were no changes to the manifest or image tag after
     *         the last push.
     * @throws LayersNotFoundException
     *         The specified layers could not be found, or the specified layer is not valid for this repository.
     * @throws LimitExceededException
     *         The operation did not succeed because it would have exceeded a service limit for your account. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/AmazonECR/latest/userguide/service_limits.html">Amazon ECR Default
     *         Service Limits</a> in the Amazon Elastic Container Registry User Guide.
     * @throws ImageTagAlreadyExistsException
     *         The specified image is tagged with a tag that already exists. The repository is configured for tag
     *         immutability.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EcrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EcrClient.PutImage
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/PutImage" target="_top">AWS API
     *      Documentation</a>
     */
    default PutImageResponse putImage(PutImageRequest putImageRequest) throws ServerException, InvalidParameterException,
            RepositoryNotFoundException, ImageAlreadyExistsException, LayersNotFoundException, LimitExceededException,
            ImageTagAlreadyExistsException, AwsServiceException, SdkClientException, EcrException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates or updates the image manifest and tags associated with an image.
     * </p>
     * <note>
     * <p>
     * This operation is used by the Amazon ECR proxy, and it is not intended for general use by customers for pulling
     * and pushing images. In most cases, you should use the <code>docker</code> CLI to pull, tag, and push images.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutImageRequest.Builder} avoiding the need to
     * create one manually via {@link PutImageRequest#builder()}
     * </p>
     *
     * @param putImageRequest
     *        A {@link Consumer} that will call methods on {@link PutImageRequest.Builder} to create a request.
     * @return Result of the PutImage operation returned by the service.
     * @throws ServerException
     *         These errors are usually caused by a server-side issue.
     * @throws InvalidParameterException
     *         The specified parameter is invalid. Review the available parameters for the API request.
     * @throws RepositoryNotFoundException
     *         The specified repository could not be found. Check the spelling of the specified repository and ensure
     *         that you are performing operations on the correct registry.
     * @throws ImageAlreadyExistsException
     *         The specified image has already been pushed, and there were no changes to the manifest or image tag after
     *         the last push.
     * @throws LayersNotFoundException
     *         The specified layers could not be found, or the specified layer is not valid for this repository.
     * @throws LimitExceededException
     *         The operation did not succeed because it would have exceeded a service limit for your account. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/AmazonECR/latest/userguide/service_limits.html">Amazon ECR Default
     *         Service Limits</a> in the Amazon Elastic Container Registry User Guide.
     * @throws ImageTagAlreadyExistsException
     *         The specified image is tagged with a tag that already exists. The repository is configured for tag
     *         immutability.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EcrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EcrClient.PutImage
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/PutImage" target="_top">AWS API
     *      Documentation</a>
     */
    default PutImageResponse putImage(Consumer<PutImageRequest.Builder> putImageRequest) throws ServerException,
            InvalidParameterException, RepositoryNotFoundException, ImageAlreadyExistsException, LayersNotFoundException,
            LimitExceededException, ImageTagAlreadyExistsException, AwsServiceException, SdkClientException, EcrException {
        return putImage(PutImageRequest.builder().applyMutation(putImageRequest).build());
    }

    /**
     * <p>
     * Updates the image scanning configuration for a repository.
     * </p>
     *
     * @param putImageScanningConfigurationRequest
     * @return Result of the PutImageScanningConfiguration operation returned by the service.
     * @throws ServerException
     *         These errors are usually caused by a server-side issue.
     * @throws InvalidParameterException
     *         The specified parameter is invalid. Review the available parameters for the API request.
     * @throws RepositoryNotFoundException
     *         The specified repository could not be found. Check the spelling of the specified repository and ensure
     *         that you are performing operations on the correct registry.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EcrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EcrClient.PutImageScanningConfiguration
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/PutImageScanningConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default PutImageScanningConfigurationResponse putImageScanningConfiguration(
            PutImageScanningConfigurationRequest putImageScanningConfigurationRequest) throws ServerException,
            InvalidParameterException, RepositoryNotFoundException, AwsServiceException, SdkClientException, EcrException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the image scanning configuration for a repository.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutImageScanningConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link PutImageScanningConfigurationRequest#builder()}
     * </p>
     *
     * @param putImageScanningConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link PutImageScanningConfigurationRequest.Builder} to
     *        create a request.
     * @return Result of the PutImageScanningConfiguration operation returned by the service.
     * @throws ServerException
     *         These errors are usually caused by a server-side issue.
     * @throws InvalidParameterException
     *         The specified parameter is invalid. Review the available parameters for the API request.
     * @throws RepositoryNotFoundException
     *         The specified repository could not be found. Check the spelling of the specified repository and ensure
     *         that you are performing operations on the correct registry.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EcrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EcrClient.PutImageScanningConfiguration
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/PutImageScanningConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default PutImageScanningConfigurationResponse putImageScanningConfiguration(
            Consumer<PutImageScanningConfigurationRequest.Builder> putImageScanningConfigurationRequest) throws ServerException,
            InvalidParameterException, RepositoryNotFoundException, AwsServiceException, SdkClientException, EcrException {
        return putImageScanningConfiguration(PutImageScanningConfigurationRequest.builder()
                .applyMutation(putImageScanningConfigurationRequest).build());
    }

    /**
     * <p>
     * Updates the image tag mutability settings for a repository. When a repository is configured with tag
     * immutability, all image tags within the repository will be prevented them from being overwritten. For more
     * information, see <a href="https://docs.aws.amazon.com/AmazonECR/latest/userguide/image-tag-mutability.html">Image
     * Tag Mutability</a> in the <i>Amazon Elastic Container Registry User Guide</i>.
     * </p>
     *
     * @param putImageTagMutabilityRequest
     * @return Result of the PutImageTagMutability operation returned by the service.
     * @throws ServerException
     *         These errors are usually caused by a server-side issue.
     * @throws InvalidParameterException
     *         The specified parameter is invalid. Review the available parameters for the API request.
     * @throws RepositoryNotFoundException
     *         The specified repository could not be found. Check the spelling of the specified repository and ensure
     *         that you are performing operations on the correct registry.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EcrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EcrClient.PutImageTagMutability
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/PutImageTagMutability" target="_top">AWS API
     *      Documentation</a>
     */
    default PutImageTagMutabilityResponse putImageTagMutability(PutImageTagMutabilityRequest putImageTagMutabilityRequest)
            throws ServerException, InvalidParameterException, RepositoryNotFoundException, AwsServiceException,
            SdkClientException, EcrException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the image tag mutability settings for a repository. When a repository is configured with tag
     * immutability, all image tags within the repository will be prevented them from being overwritten. For more
     * information, see <a href="https://docs.aws.amazon.com/AmazonECR/latest/userguide/image-tag-mutability.html">Image
     * Tag Mutability</a> in the <i>Amazon Elastic Container Registry User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutImageTagMutabilityRequest.Builder} avoiding the
     * need to create one manually via {@link PutImageTagMutabilityRequest#builder()}
     * </p>
     *
     * @param putImageTagMutabilityRequest
     *        A {@link Consumer} that will call methods on {@link PutImageTagMutabilityRequest.Builder} to create a
     *        request.
     * @return Result of the PutImageTagMutability operation returned by the service.
     * @throws ServerException
     *         These errors are usually caused by a server-side issue.
     * @throws InvalidParameterException
     *         The specified parameter is invalid. Review the available parameters for the API request.
     * @throws RepositoryNotFoundException
     *         The specified repository could not be found. Check the spelling of the specified repository and ensure
     *         that you are performing operations on the correct registry.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EcrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EcrClient.PutImageTagMutability
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/PutImageTagMutability" target="_top">AWS API
     *      Documentation</a>
     */
    default PutImageTagMutabilityResponse putImageTagMutability(
            Consumer<PutImageTagMutabilityRequest.Builder> putImageTagMutabilityRequest) throws ServerException,
            InvalidParameterException, RepositoryNotFoundException, AwsServiceException, SdkClientException, EcrException {
        return putImageTagMutability(PutImageTagMutabilityRequest.builder().applyMutation(putImageTagMutabilityRequest).build());
    }

    /**
     * <p>
     * Creates or updates a lifecycle policy. For information about lifecycle policy syntax, see <a
     * href="https://docs.aws.amazon.com/AmazonECR/latest/userguide/LifecyclePolicies.html">Lifecycle Policy
     * Template</a>.
     * </p>
     *
     * @param putLifecyclePolicyRequest
     * @return Result of the PutLifecyclePolicy operation returned by the service.
     * @throws ServerException
     *         These errors are usually caused by a server-side issue.
     * @throws InvalidParameterException
     *         The specified parameter is invalid. Review the available parameters for the API request.
     * @throws RepositoryNotFoundException
     *         The specified repository could not be found. Check the spelling of the specified repository and ensure
     *         that you are performing operations on the correct registry.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EcrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EcrClient.PutLifecyclePolicy
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/PutLifecyclePolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default PutLifecyclePolicyResponse putLifecyclePolicy(PutLifecyclePolicyRequest putLifecyclePolicyRequest)
            throws ServerException, InvalidParameterException, RepositoryNotFoundException, AwsServiceException,
            SdkClientException, EcrException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates or updates a lifecycle policy. For information about lifecycle policy syntax, see <a
     * href="https://docs.aws.amazon.com/AmazonECR/latest/userguide/LifecyclePolicies.html">Lifecycle Policy
     * Template</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutLifecyclePolicyRequest.Builder} avoiding the
     * need to create one manually via {@link PutLifecyclePolicyRequest#builder()}
     * </p>
     *
     * @param putLifecyclePolicyRequest
     *        A {@link Consumer} that will call methods on {@link PutLifecyclePolicyRequest.Builder} to create a
     *        request.
     * @return Result of the PutLifecyclePolicy operation returned by the service.
     * @throws ServerException
     *         These errors are usually caused by a server-side issue.
     * @throws InvalidParameterException
     *         The specified parameter is invalid. Review the available parameters for the API request.
     * @throws RepositoryNotFoundException
     *         The specified repository could not be found. Check the spelling of the specified repository and ensure
     *         that you are performing operations on the correct registry.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EcrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EcrClient.PutLifecyclePolicy
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/PutLifecyclePolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default PutLifecyclePolicyResponse putLifecyclePolicy(Consumer<PutLifecyclePolicyRequest.Builder> putLifecyclePolicyRequest)
            throws ServerException, InvalidParameterException, RepositoryNotFoundException, AwsServiceException,
            SdkClientException, EcrException {
        return putLifecyclePolicy(PutLifecyclePolicyRequest.builder().applyMutation(putLifecyclePolicyRequest).build());
    }

    /**
     * <p>
     * Applies a repository policy on a specified repository to control access permissions. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonECR/latest/userguide/RepositoryPolicies.html">Amazon ECR Repository
     * Policies</a> in the <i>Amazon Elastic Container Registry User Guide</i>.
     * </p>
     *
     * @param setRepositoryPolicyRequest
     * @return Result of the SetRepositoryPolicy operation returned by the service.
     * @throws ServerException
     *         These errors are usually caused by a server-side issue.
     * @throws InvalidParameterException
     *         The specified parameter is invalid. Review the available parameters for the API request.
     * @throws RepositoryNotFoundException
     *         The specified repository could not be found. Check the spelling of the specified repository and ensure
     *         that you are performing operations on the correct registry.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EcrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EcrClient.SetRepositoryPolicy
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/SetRepositoryPolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default SetRepositoryPolicyResponse setRepositoryPolicy(SetRepositoryPolicyRequest setRepositoryPolicyRequest)
            throws ServerException, InvalidParameterException, RepositoryNotFoundException, AwsServiceException,
            SdkClientException, EcrException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Applies a repository policy on a specified repository to control access permissions. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonECR/latest/userguide/RepositoryPolicies.html">Amazon ECR Repository
     * Policies</a> in the <i>Amazon Elastic Container Registry User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SetRepositoryPolicyRequest.Builder} avoiding the
     * need to create one manually via {@link SetRepositoryPolicyRequest#builder()}
     * </p>
     *
     * @param setRepositoryPolicyRequest
     *        A {@link Consumer} that will call methods on {@link SetRepositoryPolicyRequest.Builder} to create a
     *        request.
     * @return Result of the SetRepositoryPolicy operation returned by the service.
     * @throws ServerException
     *         These errors are usually caused by a server-side issue.
     * @throws InvalidParameterException
     *         The specified parameter is invalid. Review the available parameters for the API request.
     * @throws RepositoryNotFoundException
     *         The specified repository could not be found. Check the spelling of the specified repository and ensure
     *         that you are performing operations on the correct registry.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EcrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EcrClient.SetRepositoryPolicy
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/SetRepositoryPolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default SetRepositoryPolicyResponse setRepositoryPolicy(
            Consumer<SetRepositoryPolicyRequest.Builder> setRepositoryPolicyRequest) throws ServerException,
            InvalidParameterException, RepositoryNotFoundException, AwsServiceException, SdkClientException, EcrException {
        return setRepositoryPolicy(SetRepositoryPolicyRequest.builder().applyMutation(setRepositoryPolicyRequest).build());
    }

    /**
     * <p>
     * Starts an image vulnerability scan. An image scan can only be started once per day on an individual image. This
     * limit includes if an image was scanned on initial push. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonECR/latest/userguide/image-scanning.html">Image Scanning</a> in the
     * <i>Amazon Elastic Container Registry User Guide</i>.
     * </p>
     *
     * @param startImageScanRequest
     * @return Result of the StartImageScan operation returned by the service.
     * @throws ServerException
     *         These errors are usually caused by a server-side issue.
     * @throws InvalidParameterException
     *         The specified parameter is invalid. Review the available parameters for the API request.
     * @throws RepositoryNotFoundException
     *         The specified repository could not be found. Check the spelling of the specified repository and ensure
     *         that you are performing operations on the correct registry.
     * @throws ImageNotFoundException
     *         The image requested does not exist in the specified repository.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EcrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EcrClient.StartImageScan
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/StartImageScan" target="_top">AWS API
     *      Documentation</a>
     */
    default StartImageScanResponse startImageScan(StartImageScanRequest startImageScanRequest) throws ServerException,
            InvalidParameterException, RepositoryNotFoundException, ImageNotFoundException, AwsServiceException,
            SdkClientException, EcrException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts an image vulnerability scan. An image scan can only be started once per day on an individual image. This
     * limit includes if an image was scanned on initial push. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonECR/latest/userguide/image-scanning.html">Image Scanning</a> in the
     * <i>Amazon Elastic Container Registry User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartImageScanRequest.Builder} avoiding the need to
     * create one manually via {@link StartImageScanRequest#builder()}
     * </p>
     *
     * @param startImageScanRequest
     *        A {@link Consumer} that will call methods on {@link StartImageScanRequest.Builder} to create a request.
     * @return Result of the StartImageScan operation returned by the service.
     * @throws ServerException
     *         These errors are usually caused by a server-side issue.
     * @throws InvalidParameterException
     *         The specified parameter is invalid. Review the available parameters for the API request.
     * @throws RepositoryNotFoundException
     *         The specified repository could not be found. Check the spelling of the specified repository and ensure
     *         that you are performing operations on the correct registry.
     * @throws ImageNotFoundException
     *         The image requested does not exist in the specified repository.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EcrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EcrClient.StartImageScan
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/StartImageScan" target="_top">AWS API
     *      Documentation</a>
     */
    default StartImageScanResponse startImageScan(Consumer<StartImageScanRequest.Builder> startImageScanRequest)
            throws ServerException, InvalidParameterException, RepositoryNotFoundException, ImageNotFoundException,
            AwsServiceException, SdkClientException, EcrException {
        return startImageScan(StartImageScanRequest.builder().applyMutation(startImageScanRequest).build());
    }

    /**
     * <p>
     * Starts a preview of the specified lifecycle policy. This allows you to see the results before creating the
     * lifecycle policy.
     * </p>
     *
     * @param startLifecyclePolicyPreviewRequest
     * @return Result of the StartLifecyclePolicyPreview operation returned by the service.
     * @throws ServerException
     *         These errors are usually caused by a server-side issue.
     * @throws InvalidParameterException
     *         The specified parameter is invalid. Review the available parameters for the API request.
     * @throws RepositoryNotFoundException
     *         The specified repository could not be found. Check the spelling of the specified repository and ensure
     *         that you are performing operations on the correct registry.
     * @throws LifecyclePolicyNotFoundException
     *         The lifecycle policy could not be found, and no policy is set to the repository.
     * @throws LifecyclePolicyPreviewInProgressException
     *         The previous lifecycle policy preview request has not completed. Please try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EcrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EcrClient.StartLifecyclePolicyPreview
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/StartLifecyclePolicyPreview"
     *      target="_top">AWS API Documentation</a>
     */
    default StartLifecyclePolicyPreviewResponse startLifecyclePolicyPreview(
            StartLifecyclePolicyPreviewRequest startLifecyclePolicyPreviewRequest) throws ServerException,
            InvalidParameterException, RepositoryNotFoundException, LifecyclePolicyNotFoundException,
            LifecyclePolicyPreviewInProgressException, AwsServiceException, SdkClientException, EcrException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts a preview of the specified lifecycle policy. This allows you to see the results before creating the
     * lifecycle policy.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartLifecyclePolicyPreviewRequest.Builder}
     * avoiding the need to create one manually via {@link StartLifecyclePolicyPreviewRequest#builder()}
     * </p>
     *
     * @param startLifecyclePolicyPreviewRequest
     *        A {@link Consumer} that will call methods on {@link StartLifecyclePolicyPreviewRequest.Builder} to create
     *        a request.
     * @return Result of the StartLifecyclePolicyPreview operation returned by the service.
     * @throws ServerException
     *         These errors are usually caused by a server-side issue.
     * @throws InvalidParameterException
     *         The specified parameter is invalid. Review the available parameters for the API request.
     * @throws RepositoryNotFoundException
     *         The specified repository could not be found. Check the spelling of the specified repository and ensure
     *         that you are performing operations on the correct registry.
     * @throws LifecyclePolicyNotFoundException
     *         The lifecycle policy could not be found, and no policy is set to the repository.
     * @throws LifecyclePolicyPreviewInProgressException
     *         The previous lifecycle policy preview request has not completed. Please try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EcrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EcrClient.StartLifecyclePolicyPreview
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/StartLifecyclePolicyPreview"
     *      target="_top">AWS API Documentation</a>
     */
    default StartLifecyclePolicyPreviewResponse startLifecyclePolicyPreview(
            Consumer<StartLifecyclePolicyPreviewRequest.Builder> startLifecyclePolicyPreviewRequest) throws ServerException,
            InvalidParameterException, RepositoryNotFoundException, LifecyclePolicyNotFoundException,
            LifecyclePolicyPreviewInProgressException, AwsServiceException, SdkClientException, EcrException {
        return startLifecyclePolicyPreview(StartLifecyclePolicyPreviewRequest.builder()
                .applyMutation(startLifecyclePolicyPreviewRequest).build());
    }

    /**
     * <p>
     * Adds specified tags to a resource with the specified ARN. Existing tags on a resource are not changed if they are
     * not specified in the request parameters.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws InvalidParameterException
     *         The specified parameter is invalid. Review the available parameters for the API request.
     * @throws InvalidTagParameterException
     *         An invalid parameter has been specified. Tag keys can have a maximum character length of 128 characters,
     *         and tag values can have a maximum length of 256 characters.
     * @throws TooManyTagsException
     *         The list of tags on the repository is over the limit. The maximum number of tags that can be applied to a
     *         repository is 50.
     * @throws RepositoryNotFoundException
     *         The specified repository could not be found. Check the spelling of the specified repository and ensure
     *         that you are performing operations on the correct registry.
     * @throws ServerException
     *         These errors are usually caused by a server-side issue.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EcrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EcrClient.TagResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws InvalidParameterException,
            InvalidTagParameterException, TooManyTagsException, RepositoryNotFoundException, ServerException,
            AwsServiceException, SdkClientException, EcrException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds specified tags to a resource with the specified ARN. Existing tags on a resource are not changed if they are
     * not specified in the request parameters.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on {@link TagResourceRequest.Builder} to create a request.
     * @return Result of the TagResource operation returned by the service.
     * @throws InvalidParameterException
     *         The specified parameter is invalid. Review the available parameters for the API request.
     * @throws InvalidTagParameterException
     *         An invalid parameter has been specified. Tag keys can have a maximum character length of 128 characters,
     *         and tag values can have a maximum length of 256 characters.
     * @throws TooManyTagsException
     *         The list of tags on the repository is over the limit. The maximum number of tags that can be applied to a
     *         repository is 50.
     * @throws RepositoryNotFoundException
     *         The specified repository could not be found. Check the spelling of the specified repository and ensure
     *         that you are performing operations on the correct registry.
     * @throws ServerException
     *         These errors are usually caused by a server-side issue.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EcrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EcrClient.TagResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest)
            throws InvalidParameterException, InvalidTagParameterException, TooManyTagsException, RepositoryNotFoundException,
            ServerException, AwsServiceException, SdkClientException, EcrException {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Deletes specified tags from a resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws InvalidParameterException
     *         The specified parameter is invalid. Review the available parameters for the API request.
     * @throws InvalidTagParameterException
     *         An invalid parameter has been specified. Tag keys can have a maximum character length of 128 characters,
     *         and tag values can have a maximum length of 256 characters.
     * @throws TooManyTagsException
     *         The list of tags on the repository is over the limit. The maximum number of tags that can be applied to a
     *         repository is 50.
     * @throws RepositoryNotFoundException
     *         The specified repository could not be found. Check the spelling of the specified repository and ensure
     *         that you are performing operations on the correct registry.
     * @throws ServerException
     *         These errors are usually caused by a server-side issue.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EcrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EcrClient.UntagResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws InvalidParameterException,
            InvalidTagParameterException, TooManyTagsException, RepositoryNotFoundException, ServerException,
            AwsServiceException, SdkClientException, EcrException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes specified tags from a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on {@link UntagResourceRequest.Builder} to create a request.
     * @return Result of the UntagResource operation returned by the service.
     * @throws InvalidParameterException
     *         The specified parameter is invalid. Review the available parameters for the API request.
     * @throws InvalidTagParameterException
     *         An invalid parameter has been specified. Tag keys can have a maximum character length of 128 characters,
     *         and tag values can have a maximum length of 256 characters.
     * @throws TooManyTagsException
     *         The list of tags on the repository is over the limit. The maximum number of tags that can be applied to a
     *         repository is 50.
     * @throws RepositoryNotFoundException
     *         The specified repository could not be found. Check the spelling of the specified repository and ensure
     *         that you are performing operations on the correct registry.
     * @throws ServerException
     *         These errors are usually caused by a server-side issue.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EcrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EcrClient.UntagResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest)
            throws InvalidParameterException, InvalidTagParameterException, TooManyTagsException, RepositoryNotFoundException,
            ServerException, AwsServiceException, SdkClientException, EcrException {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Uploads an image layer part to Amazon ECR.
     * </p>
     * <note>
     * <p>
     * This operation is used by the Amazon ECR proxy, and it is not intended for general use by customers for pulling
     * and pushing images. In most cases, you should use the <code>docker</code> CLI to pull, tag, and push images.
     * </p>
     * </note>
     *
     * @param uploadLayerPartRequest
     * @return Result of the UploadLayerPart operation returned by the service.
     * @throws ServerException
     *         These errors are usually caused by a server-side issue.
     * @throws InvalidParameterException
     *         The specified parameter is invalid. Review the available parameters for the API request.
     * @throws InvalidLayerPartException
     *         The layer part size is not valid, or the first byte specified is not consecutive to the last byte of a
     *         previous layer part upload.
     * @throws RepositoryNotFoundException
     *         The specified repository could not be found. Check the spelling of the specified repository and ensure
     *         that you are performing operations on the correct registry.
     * @throws UploadNotFoundException
     *         The upload could not be found, or the specified upload id is not valid for this repository.
     * @throws LimitExceededException
     *         The operation did not succeed because it would have exceeded a service limit for your account. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/AmazonECR/latest/userguide/service_limits.html">Amazon ECR Default
     *         Service Limits</a> in the Amazon Elastic Container Registry User Guide.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EcrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EcrClient.UploadLayerPart
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/UploadLayerPart" target="_top">AWS API
     *      Documentation</a>
     */
    default UploadLayerPartResponse uploadLayerPart(UploadLayerPartRequest uploadLayerPartRequest) throws ServerException,
            InvalidParameterException, InvalidLayerPartException, RepositoryNotFoundException, UploadNotFoundException,
            LimitExceededException, AwsServiceException, SdkClientException, EcrException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Uploads an image layer part to Amazon ECR.
     * </p>
     * <note>
     * <p>
     * This operation is used by the Amazon ECR proxy, and it is not intended for general use by customers for pulling
     * and pushing images. In most cases, you should use the <code>docker</code> CLI to pull, tag, and push images.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UploadLayerPartRequest.Builder} avoiding the need
     * to create one manually via {@link UploadLayerPartRequest#builder()}
     * </p>
     *
     * @param uploadLayerPartRequest
     *        A {@link Consumer} that will call methods on {@link UploadLayerPartRequest.Builder} to create a request.
     * @return Result of the UploadLayerPart operation returned by the service.
     * @throws ServerException
     *         These errors are usually caused by a server-side issue.
     * @throws InvalidParameterException
     *         The specified parameter is invalid. Review the available parameters for the API request.
     * @throws InvalidLayerPartException
     *         The layer part size is not valid, or the first byte specified is not consecutive to the last byte of a
     *         previous layer part upload.
     * @throws RepositoryNotFoundException
     *         The specified repository could not be found. Check the spelling of the specified repository and ensure
     *         that you are performing operations on the correct registry.
     * @throws UploadNotFoundException
     *         The upload could not be found, or the specified upload id is not valid for this repository.
     * @throws LimitExceededException
     *         The operation did not succeed because it would have exceeded a service limit for your account. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/AmazonECR/latest/userguide/service_limits.html">Amazon ECR Default
     *         Service Limits</a> in the Amazon Elastic Container Registry User Guide.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EcrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EcrClient.UploadLayerPart
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/UploadLayerPart" target="_top">AWS API
     *      Documentation</a>
     */
    default UploadLayerPartResponse uploadLayerPart(Consumer<UploadLayerPartRequest.Builder> uploadLayerPartRequest)
            throws ServerException, InvalidParameterException, InvalidLayerPartException, RepositoryNotFoundException,
            UploadNotFoundException, LimitExceededException, AwsServiceException, SdkClientException, EcrException {
        return uploadLayerPart(UploadLayerPartRequest.builder().applyMutation(uploadLayerPartRequest).build());
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of("api.ecr");
    }
}
