/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecr.transform;

import com.fasterxml.jackson.core.JsonToken;
import java.time.Instant;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.ecr.model.Repository;

public class RepositoryUnmarshaller
implements Unmarshaller<Repository, JsonUnmarshallerContext> {
    private static final RepositoryUnmarshaller INSTANCE = new RepositoryUnmarshaller();

    public Repository unmarshall(JsonUnmarshallerContext context) throws Exception {
        Repository.Builder repositoryBuilder = Repository.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("repositoryArn", targetDepth)) {
                    context.nextToken();
                    repositoryBuilder.repositoryArn((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("registryId", targetDepth)) {
                    context.nextToken();
                    repositoryBuilder.registryId((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("repositoryName", targetDepth)) {
                    context.nextToken();
                    repositoryBuilder.repositoryName((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("repositoryUri", targetDepth)) {
                    context.nextToken();
                    repositoryBuilder.repositoryUri((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("createdAt", targetDepth)) {
                    context.nextToken();
                    repositoryBuilder.createdAt((Instant)context.getUnmarshaller(Instant.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (Repository)repositoryBuilder.build();
    }

    public static RepositoryUnmarshaller getInstance() {
        return INSTANCE;
    }
}

