/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecr.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.protocol.OperationInfo;
import software.amazon.awssdk.core.protocol.Protocol;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.ProtocolRequestMarshaller;
import software.amazon.awssdk.core.protocol.json.SdkJsonProtocolFactory;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.services.ecr.model.InitiateLayerUploadRequest;
import software.amazon.awssdk.services.ecr.transform.InitiateLayerUploadRequestModelMarshaller;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class InitiateLayerUploadRequestMarshaller
implements Marshaller<Request<InitiateLayerUploadRequest>, InitiateLayerUploadRequest> {
    private static final OperationInfo SDK_OPERATION_BINDING = OperationInfo.builder().protocol(Protocol.AWS_JSON).requestUri("/").httpMethodName(HttpMethodName.POST).hasExplicitPayloadMember(false).hasPayloadMembers(true).operationIdentifier("AmazonEC2ContainerRegistry_V20150921.InitiateLayerUpload").serviceName("Amazon ECR").build();
    private final SdkJsonProtocolFactory protocolFactory;

    public InitiateLayerUploadRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<InitiateLayerUploadRequest> marshall(InitiateLayerUploadRequest initiateLayerUploadRequest) {
        Validate.paramNotNull((Object)((Object)initiateLayerUploadRequest), (String)"initiateLayerUploadRequest");
        try {
            ProtocolRequestMarshaller protocolMarshaller = this.protocolFactory.createProtocolMarshaller(SDK_OPERATION_BINDING, (SdkRequest)initiateLayerUploadRequest);
            protocolMarshaller.startMarshalling();
            InitiateLayerUploadRequestModelMarshaller.getInstance().marshall(initiateLayerUploadRequest, (ProtocolMarshaller)protocolMarshaller);
            return protocolMarshaller.finishMarshalling();
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

