/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecr.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.core.pagination.SyncPageFetcher;
import software.amazon.awssdk.services.ecr.ECRClient;
import software.amazon.awssdk.services.ecr.model.DescribeImagesRequest;
import software.amazon.awssdk.services.ecr.model.DescribeImagesResponse;
import software.amazon.awssdk.services.ecr.model.ImageDetail;

public class DescribeImagesIterable
implements SdkIterable<DescribeImagesResponse> {
    private final ECRClient client;
    private final DescribeImagesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeImagesIterable(ECRClient client, DescribeImagesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeImagesResponseFetcher();
    }

    public Iterator<DescribeImagesResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public final SdkIterable<ImageDetail> imageDetails() {
        Function<DescribeImagesResponse, Iterator> getIterator = response -> {
            if (response != null && response.imageDetails() != null) {
                return response.imageDetails().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    public final DescribeImagesIterable resume(DescribeImagesResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribeImagesIterable(this.client, (DescribeImagesRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new DescribeImagesIterable(this.client, this.firstRequest){

            @Override
            public Iterator<DescribeImagesResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class DescribeImagesResponseFetcher
    implements SyncPageFetcher<DescribeImagesResponse> {
        private DescribeImagesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeImagesResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public DescribeImagesResponse nextPage(DescribeImagesResponse previousPage) {
            if (previousPage == null) {
                return DescribeImagesIterable.this.client.describeImages(DescribeImagesIterable.this.firstRequest);
            }
            return DescribeImagesIterable.this.client.describeImages((DescribeImagesRequest)((Object)DescribeImagesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

