/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecr.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.ecr.model.ECRResponse;
import software.amazon.awssdk.services.ecr.model.LifecyclePolicyPreviewResult;
import software.amazon.awssdk.services.ecr.model.LifecyclePolicyPreviewResultListCopier;
import software.amazon.awssdk.services.ecr.model.LifecyclePolicyPreviewStatus;
import software.amazon.awssdk.services.ecr.model.LifecyclePolicyPreviewSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetLifecyclePolicyPreviewResponse
extends ECRResponse
implements ToCopyableBuilder<Builder, GetLifecyclePolicyPreviewResponse> {
    private final String registryId;
    private final String repositoryName;
    private final String lifecyclePolicyText;
    private final String status;
    private final String nextToken;
    private final List<LifecyclePolicyPreviewResult> previewResults;
    private final LifecyclePolicyPreviewSummary summary;

    private GetLifecyclePolicyPreviewResponse(BuilderImpl builder) {
        super(builder);
        this.registryId = builder.registryId;
        this.repositoryName = builder.repositoryName;
        this.lifecyclePolicyText = builder.lifecyclePolicyText;
        this.status = builder.status;
        this.nextToken = builder.nextToken;
        this.previewResults = builder.previewResults;
        this.summary = builder.summary;
    }

    public String registryId() {
        return this.registryId;
    }

    public String repositoryName() {
        return this.repositoryName;
    }

    public String lifecyclePolicyText() {
        return this.lifecyclePolicyText;
    }

    public LifecyclePolicyPreviewStatus status() {
        return LifecyclePolicyPreviewStatus.fromValue(this.status);
    }

    public String statusString() {
        return this.status;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public List<LifecyclePolicyPreviewResult> previewResults() {
        return this.previewResults;
    }

    public LifecyclePolicyPreviewSummary summary() {
        return this.summary;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.registryId());
        hashCode = 31 * hashCode + Objects.hashCode(this.repositoryName());
        hashCode = 31 * hashCode + Objects.hashCode(this.lifecyclePolicyText());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusString());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.previewResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.summary());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetLifecyclePolicyPreviewResponse)) {
            return false;
        }
        GetLifecyclePolicyPreviewResponse other = (GetLifecyclePolicyPreviewResponse)((Object)obj);
        return Objects.equals(this.registryId(), other.registryId()) && Objects.equals(this.repositoryName(), other.repositoryName()) && Objects.equals(this.lifecyclePolicyText(), other.lifecyclePolicyText()) && Objects.equals(this.statusString(), other.statusString()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.previewResults(), other.previewResults()) && Objects.equals(this.summary(), other.summary());
    }

    public String toString() {
        return ToString.builder((String)"GetLifecyclePolicyPreviewResponse").add("RegistryId", (Object)this.registryId()).add("RepositoryName", (Object)this.repositoryName()).add("LifecyclePolicyText", (Object)this.lifecyclePolicyText()).add("Status", (Object)this.statusString()).add("NextToken", (Object)this.nextToken()).add("PreviewResults", this.previewResults()).add("Summary", (Object)this.summary()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "registryId": {
                return Optional.of(clazz.cast(this.registryId()));
            }
            case "repositoryName": {
                return Optional.of(clazz.cast(this.repositoryName()));
            }
            case "lifecyclePolicyText": {
                return Optional.of(clazz.cast(this.lifecyclePolicyText()));
            }
            case "status": {
                return Optional.of(clazz.cast(this.statusString()));
            }
            case "nextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
            case "previewResults": {
                return Optional.of(clazz.cast(this.previewResults()));
            }
            case "summary": {
                return Optional.of(clazz.cast(this.summary()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ECRResponse.BuilderImpl
    implements Builder {
        private String registryId;
        private String repositoryName;
        private String lifecyclePolicyText;
        private String status;
        private String nextToken;
        private List<LifecyclePolicyPreviewResult> previewResults;
        private LifecyclePolicyPreviewSummary summary;

        private BuilderImpl() {
        }

        private BuilderImpl(GetLifecyclePolicyPreviewResponse model) {
            this.registryId(model.registryId);
            this.repositoryName(model.repositoryName);
            this.lifecyclePolicyText(model.lifecyclePolicyText);
            this.status(model.status);
            this.nextToken(model.nextToken);
            this.previewResults(model.previewResults);
            this.summary(model.summary);
        }

        public final String getRegistryId() {
            return this.registryId;
        }

        @Override
        public final Builder registryId(String registryId) {
            this.registryId = registryId;
            return this;
        }

        public final void setRegistryId(String registryId) {
            this.registryId = registryId;
        }

        public final String getRepositoryName() {
            return this.repositoryName;
        }

        @Override
        public final Builder repositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
            return this;
        }

        public final void setRepositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
        }

        public final String getLifecyclePolicyText() {
            return this.lifecyclePolicyText;
        }

        @Override
        public final Builder lifecyclePolicyText(String lifecyclePolicyText) {
            this.lifecyclePolicyText = lifecyclePolicyText;
            return this;
        }

        public final void setLifecyclePolicyText(String lifecyclePolicyText) {
            this.lifecyclePolicyText = lifecyclePolicyText;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(LifecyclePolicyPreviewStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<LifecyclePolicyPreviewResult.Builder> getPreviewResults() {
            return this.previewResults != null ? (Collection)this.previewResults.stream().map(LifecyclePolicyPreviewResult::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder previewResults(Collection<LifecyclePolicyPreviewResult> previewResults) {
            this.previewResults = LifecyclePolicyPreviewResultListCopier.copy(previewResults);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder previewResults(LifecyclePolicyPreviewResult ... previewResults) {
            this.previewResults(Arrays.asList(previewResults));
            return this;
        }

        public final void setPreviewResults(Collection<LifecyclePolicyPreviewResult.BuilderImpl> previewResults) {
            this.previewResults = LifecyclePolicyPreviewResultListCopier.copyFromBuilder(previewResults);
        }

        public final LifecyclePolicyPreviewSummary.Builder getSummary() {
            return this.summary != null ? this.summary.toBuilder() : null;
        }

        @Override
        public final Builder summary(LifecyclePolicyPreviewSummary summary) {
            this.summary = summary;
            return this;
        }

        public final void setSummary(LifecyclePolicyPreviewSummary.BuilderImpl summary) {
            this.summary = summary != null ? summary.build() : null;
        }

        @Override
        public GetLifecyclePolicyPreviewResponse build() {
            return new GetLifecyclePolicyPreviewResponse(this);
        }
    }

    public static interface Builder
    extends ECRResponse.Builder,
    CopyableBuilder<Builder, GetLifecyclePolicyPreviewResponse> {
        public Builder registryId(String var1);

        public Builder repositoryName(String var1);

        public Builder lifecyclePolicyText(String var1);

        public Builder status(String var1);

        public Builder status(LifecyclePolicyPreviewStatus var1);

        public Builder nextToken(String var1);

        public Builder previewResults(Collection<LifecyclePolicyPreviewResult> var1);

        public Builder previewResults(LifecyclePolicyPreviewResult ... var1);

        public Builder summary(LifecyclePolicyPreviewSummary var1);

        default public Builder summary(Consumer<LifecyclePolicyPreviewSummary.Builder> summary) {
            return this.summary((LifecyclePolicyPreviewSummary)((LifecyclePolicyPreviewSummary.Builder)LifecyclePolicyPreviewSummary.builder().apply(summary)).build());
        }
    }
}

