/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecr.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.services.ecr.model.ECRResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CompleteLayerUploadResponse
extends ECRResponse
implements ToCopyableBuilder<Builder, CompleteLayerUploadResponse> {
    private final String registryId;
    private final String repositoryName;
    private final String uploadId;
    private final String layerDigest;

    private CompleteLayerUploadResponse(BuilderImpl builder) {
        super(builder);
        this.registryId = builder.registryId;
        this.repositoryName = builder.repositoryName;
        this.uploadId = builder.uploadId;
        this.layerDigest = builder.layerDigest;
    }

    public String registryId() {
        return this.registryId;
    }

    public String repositoryName() {
        return this.repositoryName;
    }

    public String uploadId() {
        return this.uploadId;
    }

    public String layerDigest() {
        return this.layerDigest;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.registryId());
        hashCode = 31 * hashCode + Objects.hashCode(this.repositoryName());
        hashCode = 31 * hashCode + Objects.hashCode(this.uploadId());
        hashCode = 31 * hashCode + Objects.hashCode(this.layerDigest());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CompleteLayerUploadResponse)) {
            return false;
        }
        CompleteLayerUploadResponse other = (CompleteLayerUploadResponse)((Object)obj);
        return Objects.equals(this.registryId(), other.registryId()) && Objects.equals(this.repositoryName(), other.repositoryName()) && Objects.equals(this.uploadId(), other.uploadId()) && Objects.equals(this.layerDigest(), other.layerDigest());
    }

    public String toString() {
        return ToString.builder((String)"CompleteLayerUploadResponse").add("RegistryId", (Object)this.registryId()).add("RepositoryName", (Object)this.repositoryName()).add("UploadId", (Object)this.uploadId()).add("LayerDigest", (Object)this.layerDigest()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "registryId": {
                return Optional.of(clazz.cast(this.registryId()));
            }
            case "repositoryName": {
                return Optional.of(clazz.cast(this.repositoryName()));
            }
            case "uploadId": {
                return Optional.of(clazz.cast(this.uploadId()));
            }
            case "layerDigest": {
                return Optional.of(clazz.cast(this.layerDigest()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ECRResponse.BuilderImpl
    implements Builder {
        private String registryId;
        private String repositoryName;
        private String uploadId;
        private String layerDigest;

        private BuilderImpl() {
        }

        private BuilderImpl(CompleteLayerUploadResponse model) {
            this.registryId(model.registryId);
            this.repositoryName(model.repositoryName);
            this.uploadId(model.uploadId);
            this.layerDigest(model.layerDigest);
        }

        public final String getRegistryId() {
            return this.registryId;
        }

        @Override
        public final Builder registryId(String registryId) {
            this.registryId = registryId;
            return this;
        }

        public final void setRegistryId(String registryId) {
            this.registryId = registryId;
        }

        public final String getRepositoryName() {
            return this.repositoryName;
        }

        @Override
        public final Builder repositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
            return this;
        }

        public final void setRepositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
        }

        public final String getUploadId() {
            return this.uploadId;
        }

        @Override
        public final Builder uploadId(String uploadId) {
            this.uploadId = uploadId;
            return this;
        }

        public final void setUploadId(String uploadId) {
            this.uploadId = uploadId;
        }

        public final String getLayerDigest() {
            return this.layerDigest;
        }

        @Override
        public final Builder layerDigest(String layerDigest) {
            this.layerDigest = layerDigest;
            return this;
        }

        public final void setLayerDigest(String layerDigest) {
            this.layerDigest = layerDigest;
        }

        @Override
        public CompleteLayerUploadResponse build() {
            return new CompleteLayerUploadResponse(this);
        }
    }

    public static interface Builder
    extends ECRResponse.Builder,
    CopyableBuilder<Builder, CompleteLayerUploadResponse> {
        public Builder registryId(String var1);

        public Builder repositoryName(String var1);

        public Builder uploadId(String var1);

        public Builder layerDigest(String var1);
    }
}

