/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecr.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.ecr.model.ECRRequest;
import software.amazon.awssdk.services.ecr.model.LayerDigestListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CompleteLayerUploadRequest
extends ECRRequest
implements ToCopyableBuilder<Builder, CompleteLayerUploadRequest> {
    private final String registryId;
    private final String repositoryName;
    private final String uploadId;
    private final List<String> layerDigests;

    private CompleteLayerUploadRequest(BuilderImpl builder) {
        super(builder);
        this.registryId = builder.registryId;
        this.repositoryName = builder.repositoryName;
        this.uploadId = builder.uploadId;
        this.layerDigests = builder.layerDigests;
    }

    public String registryId() {
        return this.registryId;
    }

    public String repositoryName() {
        return this.repositoryName;
    }

    public String uploadId() {
        return this.uploadId;
    }

    public List<String> layerDigests() {
        return this.layerDigests;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.registryId());
        hashCode = 31 * hashCode + Objects.hashCode(this.repositoryName());
        hashCode = 31 * hashCode + Objects.hashCode(this.uploadId());
        hashCode = 31 * hashCode + Objects.hashCode(this.layerDigests());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CompleteLayerUploadRequest)) {
            return false;
        }
        CompleteLayerUploadRequest other = (CompleteLayerUploadRequest)((Object)obj);
        return Objects.equals(this.registryId(), other.registryId()) && Objects.equals(this.repositoryName(), other.repositoryName()) && Objects.equals(this.uploadId(), other.uploadId()) && Objects.equals(this.layerDigests(), other.layerDigests());
    }

    public String toString() {
        return ToString.builder((String)"CompleteLayerUploadRequest").add("RegistryId", (Object)this.registryId()).add("RepositoryName", (Object)this.repositoryName()).add("UploadId", (Object)this.uploadId()).add("LayerDigests", this.layerDigests()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "registryId": {
                return Optional.of(clazz.cast(this.registryId()));
            }
            case "repositoryName": {
                return Optional.of(clazz.cast(this.repositoryName()));
            }
            case "uploadId": {
                return Optional.of(clazz.cast(this.uploadId()));
            }
            case "layerDigests": {
                return Optional.of(clazz.cast(this.layerDigests()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ECRRequest.BuilderImpl
    implements Builder {
        private String registryId;
        private String repositoryName;
        private String uploadId;
        private List<String> layerDigests;

        private BuilderImpl() {
        }

        private BuilderImpl(CompleteLayerUploadRequest model) {
            this.registryId(model.registryId);
            this.repositoryName(model.repositoryName);
            this.uploadId(model.uploadId);
            this.layerDigests(model.layerDigests);
        }

        public final String getRegistryId() {
            return this.registryId;
        }

        @Override
        public final Builder registryId(String registryId) {
            this.registryId = registryId;
            return this;
        }

        public final void setRegistryId(String registryId) {
            this.registryId = registryId;
        }

        public final String getRepositoryName() {
            return this.repositoryName;
        }

        @Override
        public final Builder repositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
            return this;
        }

        public final void setRepositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
        }

        public final String getUploadId() {
            return this.uploadId;
        }

        @Override
        public final Builder uploadId(String uploadId) {
            this.uploadId = uploadId;
            return this;
        }

        public final void setUploadId(String uploadId) {
            this.uploadId = uploadId;
        }

        public final Collection<String> getLayerDigests() {
            return this.layerDigests;
        }

        @Override
        public final Builder layerDigests(Collection<String> layerDigests) {
            this.layerDigests = LayerDigestListCopier.copy(layerDigests);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder layerDigests(String ... layerDigests) {
            this.layerDigests(Arrays.asList(layerDigests));
            return this;
        }

        public final void setLayerDigests(Collection<String> layerDigests) {
            this.layerDigests = LayerDigestListCopier.copy(layerDigests);
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public CompleteLayerUploadRequest build() {
            return new CompleteLayerUploadRequest(this);
        }
    }

    public static interface Builder
    extends ECRRequest.Builder,
    CopyableBuilder<Builder, CompleteLayerUploadRequest> {
        public Builder registryId(String var1);

        public Builder repositoryName(String var1);

        public Builder uploadId(String var1);

        public Builder layerDigests(Collection<String> var1);

        public Builder layerDigests(String ... var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

