/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecr.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.ecr.model.ECRRequest;
import software.amazon.awssdk.services.ecr.model.ImageIdentifier;
import software.amazon.awssdk.services.ecr.model.ImageIdentifierListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class BatchDeleteImageRequest
extends ECRRequest
implements ToCopyableBuilder<Builder, BatchDeleteImageRequest> {
    private final String registryId;
    private final String repositoryName;
    private final List<ImageIdentifier> imageIds;

    private BatchDeleteImageRequest(BuilderImpl builder) {
        super(builder);
        this.registryId = builder.registryId;
        this.repositoryName = builder.repositoryName;
        this.imageIds = builder.imageIds;
    }

    public String registryId() {
        return this.registryId;
    }

    public String repositoryName() {
        return this.repositoryName;
    }

    public List<ImageIdentifier> imageIds() {
        return this.imageIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.registryId());
        hashCode = 31 * hashCode + Objects.hashCode(this.repositoryName());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageIds());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchDeleteImageRequest)) {
            return false;
        }
        BatchDeleteImageRequest other = (BatchDeleteImageRequest)((Object)obj);
        return Objects.equals(this.registryId(), other.registryId()) && Objects.equals(this.repositoryName(), other.repositoryName()) && Objects.equals(this.imageIds(), other.imageIds());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.registryId() != null) {
            sb.append("RegistryId: ").append(this.registryId()).append(",");
        }
        if (this.repositoryName() != null) {
            sb.append("RepositoryName: ").append(this.repositoryName()).append(",");
        }
        if (this.imageIds() != null) {
            sb.append("ImageIds: ").append(this.imageIds()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "registryId": {
                return Optional.of(clazz.cast(this.registryId()));
            }
            case "repositoryName": {
                return Optional.of(clazz.cast(this.repositoryName()));
            }
            case "imageIds": {
                return Optional.of(clazz.cast(this.imageIds()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ECRRequest.BuilderImpl
    implements Builder {
        private String registryId;
        private String repositoryName;
        private List<ImageIdentifier> imageIds;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchDeleteImageRequest model) {
            this.registryId(model.registryId);
            this.repositoryName(model.repositoryName);
            this.imageIds(model.imageIds);
        }

        public final String getRegistryId() {
            return this.registryId;
        }

        @Override
        public final Builder registryId(String registryId) {
            this.registryId = registryId;
            return this;
        }

        public final void setRegistryId(String registryId) {
            this.registryId = registryId;
        }

        public final String getRepositoryName() {
            return this.repositoryName;
        }

        @Override
        public final Builder repositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
            return this;
        }

        public final void setRepositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
        }

        public final Collection<ImageIdentifier.Builder> getImageIds() {
            return this.imageIds != null ? (Collection)this.imageIds.stream().map(ImageIdentifier::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder imageIds(Collection<ImageIdentifier> imageIds) {
            this.imageIds = ImageIdentifierListCopier.copy(imageIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder imageIds(ImageIdentifier ... imageIds) {
            this.imageIds(Arrays.asList(imageIds));
            return this;
        }

        public final void setImageIds(Collection<ImageIdentifier.BuilderImpl> imageIds) {
            this.imageIds = ImageIdentifierListCopier.copyFromBuilder(imageIds);
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public BatchDeleteImageRequest build() {
            return new BatchDeleteImageRequest(this);
        }
    }

    public static interface Builder
    extends ECRRequest.Builder,
    CopyableBuilder<Builder, BatchDeleteImageRequest> {
        public Builder registryId(String var1);

        public Builder repositoryName(String var1);

        public Builder imageIds(Collection<ImageIdentifier> var1);

        public Builder imageIds(ImageIdentifier ... var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

