/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecr.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.ecr.model.ImageFailure;

@SdkInternalApi
public class ImageFailureMarshaller {
    private static final MarshallingInfo<StructuredPojo> IMAGEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("imageId").build();
    private static final MarshallingInfo<String> FAILURECODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("failureCode").build();
    private static final MarshallingInfo<String> FAILUREREASON_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("failureReason").build();
    private static final ImageFailureMarshaller INSTANCE = new ImageFailureMarshaller();

    public static ImageFailureMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ImageFailure imageFailure, ProtocolMarshaller protocolMarshaller) {
        if (imageFailure == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)imageFailure.imageId(), IMAGEID_BINDING);
            protocolMarshaller.marshall((Object)imageFailure.failureCodeString(), FAILURECODE_BINDING);
            protocolMarshaller.marshall((Object)imageFailure.failureReason(), FAILUREREASON_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

