/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecr.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.ecr.model.AuthorizationData;

@SdkInternalApi
public class AuthorizationDataMarshaller {
    private static final MarshallingInfo<String> AUTHORIZATIONTOKEN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("authorizationToken").build();
    private static final MarshallingInfo<Instant> EXPIRESAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("expiresAt").build();
    private static final MarshallingInfo<String> PROXYENDPOINT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("proxyEndpoint").build();
    private static final AuthorizationDataMarshaller INSTANCE = new AuthorizationDataMarshaller();

    public static AuthorizationDataMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(AuthorizationData authorizationData, ProtocolMarshaller protocolMarshaller) {
        if (authorizationData == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)authorizationData.authorizationToken(), AUTHORIZATIONTOKEN_BINDING);
            protocolMarshaller.marshall((Object)authorizationData.expiresAt(), EXPIRESAT_BINDING);
            protocolMarshaller.marshall((Object)authorizationData.proxyEndpoint(), PROXYENDPOINT_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

