/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecr.model;

import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.ecr.model.ListImagesFilter;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListImagesRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, ListImagesRequest> {
    private final String registryId;
    private final String repositoryName;
    private final String nextToken;
    private final Integer maxResults;
    private final ListImagesFilter filter;

    private ListImagesRequest(BuilderImpl builder) {
        this.registryId = builder.registryId;
        this.repositoryName = builder.repositoryName;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.filter = builder.filter;
    }

    public String registryId() {
        return this.registryId;
    }

    public String repositoryName() {
        return this.repositoryName;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Integer maxResults() {
        return this.maxResults;
    }

    public ListImagesFilter filter() {
        return this.filter;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.registryId() == null ? 0 : this.registryId().hashCode());
        hashCode = 31 * hashCode + (this.repositoryName() == null ? 0 : this.repositoryName().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        hashCode = 31 * hashCode + (this.maxResults() == null ? 0 : this.maxResults().hashCode());
        hashCode = 31 * hashCode + (this.filter() == null ? 0 : this.filter().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListImagesRequest)) {
            return false;
        }
        ListImagesRequest other = (ListImagesRequest)((Object)obj);
        if (other.registryId() == null ^ this.registryId() == null) {
            return false;
        }
        if (other.registryId() != null && !other.registryId().equals(this.registryId())) {
            return false;
        }
        if (other.repositoryName() == null ^ this.repositoryName() == null) {
            return false;
        }
        if (other.repositoryName() != null && !other.repositoryName().equals(this.repositoryName())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        if (other.maxResults() == null ^ this.maxResults() == null) {
            return false;
        }
        if (other.maxResults() != null && !other.maxResults().equals(this.maxResults())) {
            return false;
        }
        if (other.filter() == null ^ this.filter() == null) {
            return false;
        }
        return other.filter() == null || other.filter().equals(this.filter());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.registryId() != null) {
            sb.append("RegistryId: ").append(this.registryId()).append(",");
        }
        if (this.repositoryName() != null) {
            sb.append("RepositoryName: ").append(this.repositoryName()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (this.maxResults() != null) {
            sb.append("MaxResults: ").append(this.maxResults()).append(",");
        }
        if (this.filter() != null) {
            sb.append("Filter: ").append(this.filter()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "registryId": {
                return Optional.of(clazz.cast(this.registryId()));
            }
            case "repositoryName": {
                return Optional.of(clazz.cast(this.repositoryName()));
            }
            case "nextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
            case "maxResults": {
                return Optional.of(clazz.cast(this.maxResults()));
            }
            case "filter": {
                return Optional.of(clazz.cast(this.filter()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String registryId;
        private String repositoryName;
        private String nextToken;
        private Integer maxResults;
        private ListImagesFilter filter;

        private BuilderImpl() {
        }

        private BuilderImpl(ListImagesRequest model) {
            this.registryId(model.registryId);
            this.repositoryName(model.repositoryName);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
            this.filter(model.filter);
        }

        public final String getRegistryId() {
            return this.registryId;
        }

        @Override
        public final Builder registryId(String registryId) {
            this.registryId = registryId;
            return this;
        }

        public final void setRegistryId(String registryId) {
            this.registryId = registryId;
        }

        public final String getRepositoryName() {
            return this.repositoryName;
        }

        @Override
        public final Builder repositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
            return this;
        }

        public final void setRepositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final ListImagesFilter.Builder getFilter() {
            return this.filter != null ? this.filter.toBuilder() : null;
        }

        @Override
        public final Builder filter(ListImagesFilter filter) {
            this.filter = filter;
            return this;
        }

        public final void setFilter(ListImagesFilter.BuilderImpl filter) {
            this.filter = filter != null ? filter.build() : null;
        }

        public ListImagesRequest build() {
            return new ListImagesRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListImagesRequest> {
        public Builder registryId(String var1);

        public Builder repositoryName(String var1);

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder filter(ListImagesFilter var1);
    }
}

