/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecr.transform;

import java.time.Instant;
import java.util.List;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.ecr.model.ImageDetail;

@SdkInternalApi
public class ImageDetailMarshaller {
    private static final MarshallingInfo<String> REGISTRYID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("registryId").build();
    private static final MarshallingInfo<String> REPOSITORYNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("repositoryName").build();
    private static final MarshallingInfo<String> IMAGEDIGEST_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("imageDigest").build();
    private static final MarshallingInfo<List> IMAGETAGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("imageTags").build();
    private static final MarshallingInfo<Long> IMAGESIZEINBYTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("imageSizeInBytes").build();
    private static final MarshallingInfo<Instant> IMAGEPUSHEDAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("imagePushedAt").build();
    private static final ImageDetailMarshaller instance = new ImageDetailMarshaller();

    public static ImageDetailMarshaller getInstance() {
        return instance;
    }

    public void marshall(ImageDetail imageDetail, ProtocolMarshaller protocolMarshaller) {
        if (imageDetail == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)imageDetail.registryId(), REGISTRYID_BINDING);
            protocolMarshaller.marshall((Object)imageDetail.repositoryName(), REPOSITORYNAME_BINDING);
            protocolMarshaller.marshall((Object)imageDetail.imageDigest(), IMAGEDIGEST_BINDING);
            protocolMarshaller.marshall(imageDetail.imageTags(), IMAGETAGS_BINDING);
            protocolMarshaller.marshall((Object)imageDetail.imageSizeInBytes(), IMAGESIZEINBYTES_BINDING);
            protocolMarshaller.marshall((Object)imageDetail.imagePushedAt(), IMAGEPUSHEDAT_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

