/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecr.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.ecr.model.ImageFailureCode;
import software.amazon.awssdk.services.ecr.model.ImageIdentifier;
import software.amazon.awssdk.services.ecr.transform.ImageFailureMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ImageFailure
implements StructuredPojo,
ToCopyableBuilder<Builder, ImageFailure> {
    private final ImageIdentifier imageId;
    private final String failureCode;
    private final String failureReason;

    private ImageFailure(BuilderImpl builder) {
        this.imageId = builder.imageId;
        this.failureCode = builder.failureCode;
        this.failureReason = builder.failureReason;
    }

    public ImageIdentifier imageId() {
        return this.imageId;
    }

    public String failureCode() {
        return this.failureCode;
    }

    public String failureReason() {
        return this.failureReason;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.imageId() == null ? 0 : this.imageId().hashCode());
        hashCode = 31 * hashCode + (this.failureCode() == null ? 0 : this.failureCode().hashCode());
        hashCode = 31 * hashCode + (this.failureReason() == null ? 0 : this.failureReason().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImageFailure)) {
            return false;
        }
        ImageFailure other = (ImageFailure)obj;
        if (other.imageId() == null ^ this.imageId() == null) {
            return false;
        }
        if (other.imageId() != null && !other.imageId().equals(this.imageId())) {
            return false;
        }
        if (other.failureCode() == null ^ this.failureCode() == null) {
            return false;
        }
        if (other.failureCode() != null && !other.failureCode().equals(this.failureCode())) {
            return false;
        }
        if (other.failureReason() == null ^ this.failureReason() == null) {
            return false;
        }
        return other.failureReason() == null || other.failureReason().equals(this.failureReason());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.imageId() != null) {
            sb.append("ImageId: ").append(this.imageId()).append(",");
        }
        if (this.failureCode() != null) {
            sb.append("FailureCode: ").append(this.failureCode()).append(",");
        }
        if (this.failureReason() != null) {
            sb.append("FailureReason: ").append(this.failureReason()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ImageFailureMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private ImageIdentifier imageId;
        private String failureCode;
        private String failureReason;

        private BuilderImpl() {
        }

        private BuilderImpl(ImageFailure model) {
            this.setImageId(model.imageId);
            this.setFailureCode(model.failureCode);
            this.setFailureReason(model.failureReason);
        }

        public final ImageIdentifier getImageId() {
            return this.imageId;
        }

        @Override
        public final Builder imageId(ImageIdentifier imageId) {
            this.imageId = imageId;
            return this;
        }

        public final void setImageId(ImageIdentifier imageId) {
            this.imageId = imageId;
        }

        public final String getFailureCode() {
            return this.failureCode;
        }

        @Override
        public final Builder failureCode(String failureCode) {
            this.failureCode = failureCode;
            return this;
        }

        @Override
        public final Builder failureCode(ImageFailureCode failureCode) {
            this.failureCode(failureCode.toString());
            return this;
        }

        public final void setFailureCode(String failureCode) {
            this.failureCode = failureCode;
        }

        public final void setFailureCode(ImageFailureCode failureCode) {
            this.failureCode(failureCode.toString());
        }

        public final String getFailureReason() {
            return this.failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        public ImageFailure build() {
            return new ImageFailure(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ImageFailure> {
        public Builder imageId(ImageIdentifier var1);

        public Builder failureCode(String var1);

        public Builder failureCode(ImageFailureCode var1);

        public Builder failureReason(String var1);
    }
}

