/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecr.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.ecr.model.Repository;
import software.amazon.awssdk.services.ecr.model.RepositoryListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeRepositoriesResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeRepositoriesResponse> {
    private final List<Repository> repositories;
    private final String nextToken;

    private DescribeRepositoriesResponse(BuilderImpl builder) {
        this.repositories = builder.repositories;
        this.nextToken = builder.nextToken;
    }

    public List<Repository> repositories() {
        return this.repositories;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.repositories() == null ? 0 : this.repositories().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeRepositoriesResponse)) {
            return false;
        }
        DescribeRepositoriesResponse other = (DescribeRepositoriesResponse)((Object)obj);
        if (other.repositories() == null ^ this.repositories() == null) {
            return false;
        }
        if (other.repositories() != null && !other.repositories().equals(this.repositories())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.repositories() != null) {
            sb.append("Repositories: ").append(this.repositories()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<Repository> repositories;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeRepositoriesResponse model) {
            this.setRepositories(model.repositories);
            this.setNextToken(model.nextToken);
        }

        public final Collection<Repository> getRepositories() {
            return this.repositories;
        }

        @Override
        public final Builder repositories(Collection<Repository> repositories) {
            this.repositories = RepositoryListCopier.copy(repositories);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder repositories(Repository ... repositories) {
            this.repositories(Arrays.asList(repositories));
            return this;
        }

        public final void setRepositories(Collection<Repository> repositories) {
            this.repositories = RepositoryListCopier.copy(repositories);
        }

        @SafeVarargs
        public final void setRepositories(Repository ... repositories) {
            this.repositories(Arrays.asList(repositories));
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public DescribeRepositoriesResponse build() {
            return new DescribeRepositoriesResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeRepositoriesResponse> {
        public Builder repositories(Collection<Repository> var1);

        public Builder repositories(Repository ... var1);

        public Builder nextToken(String var1);
    }
}

