/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecr.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.ecr.model.UploadLayerPartRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class UploadLayerPartRequestModelMarshaller {
    private static final MarshallingInfo<String> REGISTRYID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("registryId").isBinary(false).build();
    private static final MarshallingInfo<String> REPOSITORYNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("repositoryName").isBinary(false).build();
    private static final MarshallingInfo<String> UPLOADID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("uploadId").isBinary(false).build();
    private static final MarshallingInfo<Long> PARTFIRSTBYTE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("partFirstByte").isBinary(false).build();
    private static final MarshallingInfo<Long> PARTLASTBYTE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("partLastByte").isBinary(false).build();
    private static final MarshallingInfo<SdkBytes> LAYERPARTBLOB_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.SDK_BYTES).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("layerPartBlob").isBinary(false).build();
    private static final UploadLayerPartRequestModelMarshaller INSTANCE = new UploadLayerPartRequestModelMarshaller();

    private UploadLayerPartRequestModelMarshaller() {
    }

    public static UploadLayerPartRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(UploadLayerPartRequest uploadLayerPartRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)uploadLayerPartRequest), (String)"uploadLayerPartRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)uploadLayerPartRequest.registryId(), REGISTRYID_BINDING);
            protocolMarshaller.marshall((Object)uploadLayerPartRequest.repositoryName(), REPOSITORYNAME_BINDING);
            protocolMarshaller.marshall((Object)uploadLayerPartRequest.uploadId(), UPLOADID_BINDING);
            protocolMarshaller.marshall((Object)uploadLayerPartRequest.partFirstByte(), PARTFIRSTBYTE_BINDING);
            protocolMarshaller.marshall((Object)uploadLayerPartRequest.partLastByte(), PARTLASTBYTE_BINDING);
            protocolMarshaller.marshall((Object)uploadLayerPartRequest.layerPartBlob(), LAYERPARTBLOB_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

