/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecr.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.ecr.model.ImageTagListCopier;
import software.amazon.awssdk.services.ecr.model.LifecyclePolicyRuleAction;
import software.amazon.awssdk.services.ecr.transform.LifecyclePolicyPreviewResultMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LifecyclePolicyPreviewResult
implements StructuredPojo,
ToCopyableBuilder<Builder, LifecyclePolicyPreviewResult> {
    private final List<String> imageTags;
    private final String imageDigest;
    private final Instant imagePushedAt;
    private final LifecyclePolicyRuleAction action;
    private final Integer appliedRulePriority;

    private LifecyclePolicyPreviewResult(BuilderImpl builder) {
        this.imageTags = builder.imageTags;
        this.imageDigest = builder.imageDigest;
        this.imagePushedAt = builder.imagePushedAt;
        this.action = builder.action;
        this.appliedRulePriority = builder.appliedRulePriority;
    }

    public List<String> imageTags() {
        return this.imageTags;
    }

    public String imageDigest() {
        return this.imageDigest;
    }

    public Instant imagePushedAt() {
        return this.imagePushedAt;
    }

    public LifecyclePolicyRuleAction action() {
        return this.action;
    }

    public Integer appliedRulePriority() {
        return this.appliedRulePriority;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.imageTags());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageDigest());
        hashCode = 31 * hashCode + Objects.hashCode(this.imagePushedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.action());
        hashCode = 31 * hashCode + Objects.hashCode(this.appliedRulePriority());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LifecyclePolicyPreviewResult)) {
            return false;
        }
        LifecyclePolicyPreviewResult other = (LifecyclePolicyPreviewResult)obj;
        return Objects.equals(this.imageTags(), other.imageTags()) && Objects.equals(this.imageDigest(), other.imageDigest()) && Objects.equals(this.imagePushedAt(), other.imagePushedAt()) && Objects.equals(this.action(), other.action()) && Objects.equals(this.appliedRulePriority(), other.appliedRulePriority());
    }

    public String toString() {
        return ToString.builder((String)"LifecyclePolicyPreviewResult").add("ImageTags", this.imageTags()).add("ImageDigest", (Object)this.imageDigest()).add("ImagePushedAt", (Object)this.imagePushedAt()).add("Action", (Object)this.action()).add("AppliedRulePriority", (Object)this.appliedRulePriority()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "imageTags": {
                return Optional.ofNullable(clazz.cast(this.imageTags()));
            }
            case "imageDigest": {
                return Optional.ofNullable(clazz.cast(this.imageDigest()));
            }
            case "imagePushedAt": {
                return Optional.ofNullable(clazz.cast(this.imagePushedAt()));
            }
            case "action": {
                return Optional.ofNullable(clazz.cast(this.action()));
            }
            case "appliedRulePriority": {
                return Optional.ofNullable(clazz.cast(this.appliedRulePriority()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        LifecyclePolicyPreviewResultMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> imageTags = DefaultSdkAutoConstructList.getInstance();
        private String imageDigest;
        private Instant imagePushedAt;
        private LifecyclePolicyRuleAction action;
        private Integer appliedRulePriority;

        private BuilderImpl() {
        }

        private BuilderImpl(LifecyclePolicyPreviewResult model) {
            this.imageTags(model.imageTags);
            this.imageDigest(model.imageDigest);
            this.imagePushedAt(model.imagePushedAt);
            this.action(model.action);
            this.appliedRulePriority(model.appliedRulePriority);
        }

        public final Collection<String> getImageTags() {
            return this.imageTags;
        }

        @Override
        public final Builder imageTags(Collection<String> imageTags) {
            this.imageTags = ImageTagListCopier.copy(imageTags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder imageTags(String ... imageTags) {
            this.imageTags(Arrays.asList(imageTags));
            return this;
        }

        public final void setImageTags(Collection<String> imageTags) {
            this.imageTags = ImageTagListCopier.copy(imageTags);
        }

        public final String getImageDigest() {
            return this.imageDigest;
        }

        @Override
        public final Builder imageDigest(String imageDigest) {
            this.imageDigest = imageDigest;
            return this;
        }

        public final void setImageDigest(String imageDigest) {
            this.imageDigest = imageDigest;
        }

        public final Instant getImagePushedAt() {
            return this.imagePushedAt;
        }

        @Override
        public final Builder imagePushedAt(Instant imagePushedAt) {
            this.imagePushedAt = imagePushedAt;
            return this;
        }

        public final void setImagePushedAt(Instant imagePushedAt) {
            this.imagePushedAt = imagePushedAt;
        }

        public final LifecyclePolicyRuleAction.Builder getAction() {
            return this.action != null ? this.action.toBuilder() : null;
        }

        @Override
        public final Builder action(LifecyclePolicyRuleAction action) {
            this.action = action;
            return this;
        }

        public final void setAction(LifecyclePolicyRuleAction.BuilderImpl action) {
            this.action = action != null ? action.build() : null;
        }

        public final Integer getAppliedRulePriority() {
            return this.appliedRulePriority;
        }

        @Override
        public final Builder appliedRulePriority(Integer appliedRulePriority) {
            this.appliedRulePriority = appliedRulePriority;
            return this;
        }

        public final void setAppliedRulePriority(Integer appliedRulePriority) {
            this.appliedRulePriority = appliedRulePriority;
        }

        public LifecyclePolicyPreviewResult build() {
            return new LifecyclePolicyPreviewResult(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, LifecyclePolicyPreviewResult> {
        public Builder imageTags(Collection<String> var1);

        public Builder imageTags(String ... var1);

        public Builder imageDigest(String var1);

        public Builder imagePushedAt(Instant var1);

        public Builder action(LifecyclePolicyRuleAction var1);

        default public Builder action(Consumer<LifecyclePolicyRuleAction.Builder> action) {
            return this.action((LifecyclePolicyRuleAction)((LifecyclePolicyRuleAction.Builder)LifecyclePolicyRuleAction.builder().applyMutation(action)).build());
        }

        public Builder appliedRulePriority(Integer var1);
    }
}

