/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecr.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.ecr.model.EcrRequest;
import software.amazon.awssdk.services.ecr.model.ImageIdentifier;
import software.amazon.awssdk.services.ecr.model.ImageIdentifierListCopier;
import software.amazon.awssdk.services.ecr.model.MediaTypeListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchGetImageRequest
extends EcrRequest
implements ToCopyableBuilder<Builder, BatchGetImageRequest> {
    private final String registryId;
    private final String repositoryName;
    private final List<ImageIdentifier> imageIds;
    private final List<String> acceptedMediaTypes;

    private BatchGetImageRequest(BuilderImpl builder) {
        super(builder);
        this.registryId = builder.registryId;
        this.repositoryName = builder.repositoryName;
        this.imageIds = builder.imageIds;
        this.acceptedMediaTypes = builder.acceptedMediaTypes;
    }

    public String registryId() {
        return this.registryId;
    }

    public String repositoryName() {
        return this.repositoryName;
    }

    public List<ImageIdentifier> imageIds() {
        return this.imageIds;
    }

    public List<String> acceptedMediaTypes() {
        return this.acceptedMediaTypes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.registryId());
        hashCode = 31 * hashCode + Objects.hashCode(this.repositoryName());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageIds());
        hashCode = 31 * hashCode + Objects.hashCode(this.acceptedMediaTypes());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetImageRequest)) {
            return false;
        }
        BatchGetImageRequest other = (BatchGetImageRequest)((Object)obj);
        return Objects.equals(this.registryId(), other.registryId()) && Objects.equals(this.repositoryName(), other.repositoryName()) && Objects.equals(this.imageIds(), other.imageIds()) && Objects.equals(this.acceptedMediaTypes(), other.acceptedMediaTypes());
    }

    public String toString() {
        return ToString.builder((String)"BatchGetImageRequest").add("RegistryId", (Object)this.registryId()).add("RepositoryName", (Object)this.repositoryName()).add("ImageIds", this.imageIds()).add("AcceptedMediaTypes", this.acceptedMediaTypes()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "registryId": {
                return Optional.ofNullable(clazz.cast(this.registryId()));
            }
            case "repositoryName": {
                return Optional.ofNullable(clazz.cast(this.repositoryName()));
            }
            case "imageIds": {
                return Optional.ofNullable(clazz.cast(this.imageIds()));
            }
            case "acceptedMediaTypes": {
                return Optional.ofNullable(clazz.cast(this.acceptedMediaTypes()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends EcrRequest.BuilderImpl
    implements Builder {
        private String registryId;
        private String repositoryName;
        private List<ImageIdentifier> imageIds = DefaultSdkAutoConstructList.getInstance();
        private List<String> acceptedMediaTypes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetImageRequest model) {
            super(model);
            this.registryId(model.registryId);
            this.repositoryName(model.repositoryName);
            this.imageIds(model.imageIds);
            this.acceptedMediaTypes(model.acceptedMediaTypes);
        }

        public final String getRegistryId() {
            return this.registryId;
        }

        @Override
        public final Builder registryId(String registryId) {
            this.registryId = registryId;
            return this;
        }

        public final void setRegistryId(String registryId) {
            this.registryId = registryId;
        }

        public final String getRepositoryName() {
            return this.repositoryName;
        }

        @Override
        public final Builder repositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
            return this;
        }

        public final void setRepositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
        }

        public final Collection<ImageIdentifier.Builder> getImageIds() {
            return this.imageIds != null ? (Collection)this.imageIds.stream().map(ImageIdentifier::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder imageIds(Collection<ImageIdentifier> imageIds) {
            this.imageIds = ImageIdentifierListCopier.copy(imageIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder imageIds(ImageIdentifier ... imageIds) {
            this.imageIds(Arrays.asList(imageIds));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder imageIds(Consumer<ImageIdentifier.Builder> ... imageIds) {
            this.imageIds(Stream.of(imageIds).map(c -> (ImageIdentifier)((ImageIdentifier.Builder)ImageIdentifier.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setImageIds(Collection<ImageIdentifier.BuilderImpl> imageIds) {
            this.imageIds = ImageIdentifierListCopier.copyFromBuilder(imageIds);
        }

        public final Collection<String> getAcceptedMediaTypes() {
            return this.acceptedMediaTypes;
        }

        @Override
        public final Builder acceptedMediaTypes(Collection<String> acceptedMediaTypes) {
            this.acceptedMediaTypes = MediaTypeListCopier.copy(acceptedMediaTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder acceptedMediaTypes(String ... acceptedMediaTypes) {
            this.acceptedMediaTypes(Arrays.asList(acceptedMediaTypes));
            return this;
        }

        public final void setAcceptedMediaTypes(Collection<String> acceptedMediaTypes) {
            this.acceptedMediaTypes = MediaTypeListCopier.copy(acceptedMediaTypes);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchGetImageRequest build() {
            return new BatchGetImageRequest(this);
        }
    }

    public static interface Builder
    extends EcrRequest.Builder,
    CopyableBuilder<Builder, BatchGetImageRequest> {
        public Builder registryId(String var1);

        public Builder repositoryName(String var1);

        public Builder imageIds(Collection<ImageIdentifier> var1);

        public Builder imageIds(ImageIdentifier ... var1);

        public Builder imageIds(Consumer<ImageIdentifier.Builder> ... var1);

        public Builder acceptedMediaTypes(Collection<String> var1);

        public Builder acceptedMediaTypes(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

