/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecr.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.ecr.model.Layer;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class LayerMarshaller {
    private static final MarshallingInfo<String> LAYERDIGEST_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("layerDigest").isBinary(false).build();
    private static final MarshallingInfo<String> LAYERAVAILABILITY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("layerAvailability").isBinary(false).build();
    private static final MarshallingInfo<Long> LAYERSIZE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("layerSize").isBinary(false).build();
    private static final MarshallingInfo<String> MEDIATYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("mediaType").isBinary(false).build();
    private static final LayerMarshaller INSTANCE = new LayerMarshaller();

    private LayerMarshaller() {
    }

    public static LayerMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Layer layer, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)layer, (String)"layer");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)layer.layerDigest(), LAYERDIGEST_BINDING);
            protocolMarshaller.marshall((Object)layer.layerAvailabilityAsString(), LAYERAVAILABILITY_BINDING);
            protocolMarshaller.marshall((Object)layer.layerSize(), LAYERSIZE_BINDING);
            protocolMarshaller.marshall((Object)layer.mediaType(), MEDIATYPE_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

