/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecr.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.ecr.EcrClient;
import software.amazon.awssdk.services.ecr.model.DescribeRepositoriesRequest;
import software.amazon.awssdk.services.ecr.model.DescribeRepositoriesResponse;
import software.amazon.awssdk.services.ecr.model.Repository;

public class DescribeRepositoriesIterable
implements SdkIterable<DescribeRepositoriesResponse> {
    private final EcrClient client;
    private final DescribeRepositoriesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeRepositoriesIterable(EcrClient client, DescribeRepositoriesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeRepositoriesResponseFetcher();
    }

    public Iterator<DescribeRepositoriesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Repository> repositories() {
        Function<DescribeRepositoriesResponse, Iterator> getIterator = response -> {
            if (response != null && response.repositories() != null) {
                return response.repositories().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private final DescribeRepositoriesIterable resume(DescribeRepositoriesResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribeRepositoriesIterable(this.client, (DescribeRepositoriesRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new DescribeRepositoriesIterable(this.client, this.firstRequest){

            @Override
            public Iterator<DescribeRepositoriesResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class DescribeRepositoriesResponseFetcher
    implements SyncPageFetcher<DescribeRepositoriesResponse> {
        private DescribeRepositoriesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeRepositoriesResponse previousPage) {
            return previousPage.nextToken() != null && !SdkAutoConstructList.class.isInstance(previousPage.nextToken()) && !SdkAutoConstructMap.class.isInstance(previousPage.nextToken());
        }

        public DescribeRepositoriesResponse nextPage(DescribeRepositoriesResponse previousPage) {
            if (previousPage == null) {
                return DescribeRepositoriesIterable.this.client.describeRepositories(DescribeRepositoriesIterable.this.firstRequest);
            }
            return DescribeRepositoriesIterable.this.client.describeRepositories((DescribeRepositoriesRequest)((Object)DescribeRepositoriesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

