/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecr.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.ecr.model.LayerAvailability;
import software.amazon.awssdk.services.ecr.transform.LayerMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Layer
implements StructuredPojo,
ToCopyableBuilder<Builder, Layer> {
    private final String layerDigest;
    private final String layerAvailability;
    private final Long layerSize;
    private final String mediaType;

    private Layer(BuilderImpl builder) {
        this.layerDigest = builder.layerDigest;
        this.layerAvailability = builder.layerAvailability;
        this.layerSize = builder.layerSize;
        this.mediaType = builder.mediaType;
    }

    public String layerDigest() {
        return this.layerDigest;
    }

    public LayerAvailability layerAvailability() {
        return LayerAvailability.fromValue(this.layerAvailability);
    }

    public String layerAvailabilityAsString() {
        return this.layerAvailability;
    }

    public Long layerSize() {
        return this.layerSize;
    }

    public String mediaType() {
        return this.mediaType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.layerDigest());
        hashCode = 31 * hashCode + Objects.hashCode(this.layerAvailabilityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.layerSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.mediaType());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Layer)) {
            return false;
        }
        Layer other = (Layer)obj;
        return Objects.equals(this.layerDigest(), other.layerDigest()) && Objects.equals(this.layerAvailabilityAsString(), other.layerAvailabilityAsString()) && Objects.equals(this.layerSize(), other.layerSize()) && Objects.equals(this.mediaType(), other.mediaType());
    }

    public String toString() {
        return ToString.builder((String)"Layer").add("LayerDigest", (Object)this.layerDigest()).add("LayerAvailability", (Object)this.layerAvailabilityAsString()).add("LayerSize", (Object)this.layerSize()).add("MediaType", (Object)this.mediaType()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "layerDigest": {
                return Optional.ofNullable(clazz.cast(this.layerDigest()));
            }
            case "layerAvailability": {
                return Optional.ofNullable(clazz.cast(this.layerAvailabilityAsString()));
            }
            case "layerSize": {
                return Optional.ofNullable(clazz.cast(this.layerSize()));
            }
            case "mediaType": {
                return Optional.ofNullable(clazz.cast(this.mediaType()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        LayerMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String layerDigest;
        private String layerAvailability;
        private Long layerSize;
        private String mediaType;

        private BuilderImpl() {
        }

        private BuilderImpl(Layer model) {
            this.layerDigest(model.layerDigest);
            this.layerAvailability(model.layerAvailability);
            this.layerSize(model.layerSize);
            this.mediaType(model.mediaType);
        }

        public final String getLayerDigest() {
            return this.layerDigest;
        }

        @Override
        public final Builder layerDigest(String layerDigest) {
            this.layerDigest = layerDigest;
            return this;
        }

        public final void setLayerDigest(String layerDigest) {
            this.layerDigest = layerDigest;
        }

        public final String getLayerAvailability() {
            return this.layerAvailability;
        }

        @Override
        public final Builder layerAvailability(String layerAvailability) {
            this.layerAvailability = layerAvailability;
            return this;
        }

        @Override
        public final Builder layerAvailability(LayerAvailability layerAvailability) {
            this.layerAvailability(layerAvailability.toString());
            return this;
        }

        public final void setLayerAvailability(String layerAvailability) {
            this.layerAvailability = layerAvailability;
        }

        public final Long getLayerSize() {
            return this.layerSize;
        }

        @Override
        public final Builder layerSize(Long layerSize) {
            this.layerSize = layerSize;
            return this;
        }

        public final void setLayerSize(Long layerSize) {
            this.layerSize = layerSize;
        }

        public final String getMediaType() {
            return this.mediaType;
        }

        @Override
        public final Builder mediaType(String mediaType) {
            this.mediaType = mediaType;
            return this;
        }

        public final void setMediaType(String mediaType) {
            this.mediaType = mediaType;
        }

        public Layer build() {
            return new Layer(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Layer> {
        public Builder layerDigest(String var1);

        public Builder layerAvailability(String var1);

        public Builder layerAvailability(LayerAvailability var1);

        public Builder layerSize(Long var1);

        public Builder mediaType(String var1);
    }
}

