/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecr.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.services.ecr.model.EcrResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteLifecyclePolicyResponse
extends EcrResponse
implements ToCopyableBuilder<Builder, DeleteLifecyclePolicyResponse> {
    private final String registryId;
    private final String repositoryName;
    private final String lifecyclePolicyText;
    private final Instant lastEvaluatedAt;

    private DeleteLifecyclePolicyResponse(BuilderImpl builder) {
        super(builder);
        this.registryId = builder.registryId;
        this.repositoryName = builder.repositoryName;
        this.lifecyclePolicyText = builder.lifecyclePolicyText;
        this.lastEvaluatedAt = builder.lastEvaluatedAt;
    }

    public String registryId() {
        return this.registryId;
    }

    public String repositoryName() {
        return this.repositoryName;
    }

    public String lifecyclePolicyText() {
        return this.lifecyclePolicyText;
    }

    public Instant lastEvaluatedAt() {
        return this.lastEvaluatedAt;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.registryId());
        hashCode = 31 * hashCode + Objects.hashCode(this.repositoryName());
        hashCode = 31 * hashCode + Objects.hashCode(this.lifecyclePolicyText());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastEvaluatedAt());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteLifecyclePolicyResponse)) {
            return false;
        }
        DeleteLifecyclePolicyResponse other = (DeleteLifecyclePolicyResponse)((Object)obj);
        return Objects.equals(this.registryId(), other.registryId()) && Objects.equals(this.repositoryName(), other.repositoryName()) && Objects.equals(this.lifecyclePolicyText(), other.lifecyclePolicyText()) && Objects.equals(this.lastEvaluatedAt(), other.lastEvaluatedAt());
    }

    public String toString() {
        return ToString.builder((String)"DeleteLifecyclePolicyResponse").add("RegistryId", (Object)this.registryId()).add("RepositoryName", (Object)this.repositoryName()).add("LifecyclePolicyText", (Object)this.lifecyclePolicyText()).add("LastEvaluatedAt", (Object)this.lastEvaluatedAt()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "registryId": {
                return Optional.ofNullable(clazz.cast(this.registryId()));
            }
            case "repositoryName": {
                return Optional.ofNullable(clazz.cast(this.repositoryName()));
            }
            case "lifecyclePolicyText": {
                return Optional.ofNullable(clazz.cast(this.lifecyclePolicyText()));
            }
            case "lastEvaluatedAt": {
                return Optional.ofNullable(clazz.cast(this.lastEvaluatedAt()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends EcrResponse.BuilderImpl
    implements Builder {
        private String registryId;
        private String repositoryName;
        private String lifecyclePolicyText;
        private Instant lastEvaluatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteLifecyclePolicyResponse model) {
            super(model);
            this.registryId(model.registryId);
            this.repositoryName(model.repositoryName);
            this.lifecyclePolicyText(model.lifecyclePolicyText);
            this.lastEvaluatedAt(model.lastEvaluatedAt);
        }

        public final String getRegistryId() {
            return this.registryId;
        }

        @Override
        public final Builder registryId(String registryId) {
            this.registryId = registryId;
            return this;
        }

        public final void setRegistryId(String registryId) {
            this.registryId = registryId;
        }

        public final String getRepositoryName() {
            return this.repositoryName;
        }

        @Override
        public final Builder repositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
            return this;
        }

        public final void setRepositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
        }

        public final String getLifecyclePolicyText() {
            return this.lifecyclePolicyText;
        }

        @Override
        public final Builder lifecyclePolicyText(String lifecyclePolicyText) {
            this.lifecyclePolicyText = lifecyclePolicyText;
            return this;
        }

        public final void setLifecyclePolicyText(String lifecyclePolicyText) {
            this.lifecyclePolicyText = lifecyclePolicyText;
        }

        public final Instant getLastEvaluatedAt() {
            return this.lastEvaluatedAt;
        }

        @Override
        public final Builder lastEvaluatedAt(Instant lastEvaluatedAt) {
            this.lastEvaluatedAt = lastEvaluatedAt;
            return this;
        }

        public final void setLastEvaluatedAt(Instant lastEvaluatedAt) {
            this.lastEvaluatedAt = lastEvaluatedAt;
        }

        @Override
        public DeleteLifecyclePolicyResponse build() {
            return new DeleteLifecyclePolicyResponse(this);
        }
    }

    public static interface Builder
    extends EcrResponse.Builder,
    CopyableBuilder<Builder, DeleteLifecyclePolicyResponse> {
        public Builder registryId(String var1);

        public Builder repositoryName(String var1);

        public Builder lifecyclePolicyText(String var1);

        public Builder lastEvaluatedAt(Instant var1);
    }
}

