/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecr.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.ecr.model.PutImageRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class PutImageRequestModelMarshaller {
    private static final MarshallingInfo<String> REGISTRYID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("registryId").isBinary(false).build();
    private static final MarshallingInfo<String> REPOSITORYNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("repositoryName").isBinary(false).build();
    private static final MarshallingInfo<String> IMAGEMANIFEST_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("imageManifest").isBinary(false).build();
    private static final MarshallingInfo<String> IMAGETAG_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("imageTag").isBinary(false).build();
    private static final PutImageRequestModelMarshaller INSTANCE = new PutImageRequestModelMarshaller();

    private PutImageRequestModelMarshaller() {
    }

    public static PutImageRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(PutImageRequest putImageRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)putImageRequest), (String)"putImageRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)putImageRequest.registryId(), REGISTRYID_BINDING);
            protocolMarshaller.marshall((Object)putImageRequest.repositoryName(), REPOSITORYNAME_BINDING);
            protocolMarshaller.marshall((Object)putImageRequest.imageManifest(), IMAGEMANIFEST_BINDING);
            protocolMarshaller.marshall((Object)putImageRequest.imageTag(), IMAGETAG_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

