/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecr.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.pagination.async.SdkPublisher;
import software.amazon.awssdk.services.ecr.ECRAsyncClient;
import software.amazon.awssdk.services.ecr.model.ImageIdentifier;
import software.amazon.awssdk.services.ecr.model.ListImagesRequest;
import software.amazon.awssdk.services.ecr.model.ListImagesResponse;

public class ListImagesPublisher
implements SdkPublisher<ListImagesResponse> {
    private final ECRAsyncClient client;
    private final ListImagesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListImagesPublisher(ECRAsyncClient client, ListImagesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListImagesPublisher(ECRAsyncClient client, ListImagesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListImagesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListImagesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)new ResponsesSubscription(subscriber, this.nextPageFetcher));
    }

    public final SdkPublisher<ImageIdentifier> imageIds() {
        Function<ListImagesResponse, Iterator> getIterator = response -> {
            if (response != null && response.imageIds() != null) {
                return response.imageIds().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsPublisher((AsyncPageFetcher)new ListImagesResponseFetcher(), getIterator, this.isLastPage);
    }

    public final ListImagesPublisher resume(ListImagesResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListImagesPublisher(this.client, (ListImagesRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListImagesPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super ListImagesResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class ListImagesResponseFetcher
    implements AsyncPageFetcher<ListImagesResponse> {
        private ListImagesResponseFetcher() {
        }

        public boolean hasNextPage(ListImagesResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public CompletableFuture<ListImagesResponse> nextPage(ListImagesResponse previousPage) {
            if (previousPage == null) {
                return ListImagesPublisher.this.client.listImages(ListImagesPublisher.this.firstRequest);
            }
            return ListImagesPublisher.this.client.listImages((ListImagesRequest)((Object)ListImagesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

