/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecr.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.pagination.async.SdkPublisher;
import software.amazon.awssdk.services.ecr.ECRAsyncClient;
import software.amazon.awssdk.services.ecr.model.DescribeImagesRequest;
import software.amazon.awssdk.services.ecr.model.DescribeImagesResponse;
import software.amazon.awssdk.services.ecr.model.ImageDetail;

public class DescribeImagesPublisher
implements SdkPublisher<DescribeImagesResponse> {
    private final ECRAsyncClient client;
    private final DescribeImagesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeImagesPublisher(ECRAsyncClient client, DescribeImagesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeImagesPublisher(ECRAsyncClient client, DescribeImagesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeImagesResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeImagesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)new ResponsesSubscription(subscriber, this.nextPageFetcher));
    }

    public final SdkPublisher<ImageDetail> imageDetails() {
        Function<DescribeImagesResponse, Iterator> getIterator = response -> {
            if (response != null && response.imageDetails() != null) {
                return response.imageDetails().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsPublisher((AsyncPageFetcher)new DescribeImagesResponseFetcher(), getIterator, this.isLastPage);
    }

    public final DescribeImagesPublisher resume(DescribeImagesResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribeImagesPublisher(this.client, (DescribeImagesRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new DescribeImagesPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super DescribeImagesResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class DescribeImagesResponseFetcher
    implements AsyncPageFetcher<DescribeImagesResponse> {
        private DescribeImagesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeImagesResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public CompletableFuture<DescribeImagesResponse> nextPage(DescribeImagesResponse previousPage) {
            if (previousPage == null) {
                return DescribeImagesPublisher.this.client.describeImages(DescribeImagesPublisher.this.firstRequest);
            }
            return DescribeImagesPublisher.this.client.describeImages((DescribeImagesRequest)((Object)DescribeImagesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

