/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecr.model;

import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.core.runtime.StandardMemberCopier;
import software.amazon.awssdk.services.ecr.model.ECRRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UploadLayerPartRequest
extends ECRRequest
implements ToCopyableBuilder<Builder, UploadLayerPartRequest> {
    private final String registryId;
    private final String repositoryName;
    private final String uploadId;
    private final Long partFirstByte;
    private final Long partLastByte;
    private final ByteBuffer layerPartBlob;

    private UploadLayerPartRequest(BuilderImpl builder) {
        super(builder);
        this.registryId = builder.registryId;
        this.repositoryName = builder.repositoryName;
        this.uploadId = builder.uploadId;
        this.partFirstByte = builder.partFirstByte;
        this.partLastByte = builder.partLastByte;
        this.layerPartBlob = builder.layerPartBlob;
    }

    public String registryId() {
        return this.registryId;
    }

    public String repositoryName() {
        return this.repositoryName;
    }

    public String uploadId() {
        return this.uploadId;
    }

    public Long partFirstByte() {
        return this.partFirstByte;
    }

    public Long partLastByte() {
        return this.partLastByte;
    }

    public ByteBuffer layerPartBlob() {
        return this.layerPartBlob == null ? null : this.layerPartBlob.asReadOnlyBuffer();
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.registryId());
        hashCode = 31 * hashCode + Objects.hashCode(this.repositoryName());
        hashCode = 31 * hashCode + Objects.hashCode(this.uploadId());
        hashCode = 31 * hashCode + Objects.hashCode(this.partFirstByte());
        hashCode = 31 * hashCode + Objects.hashCode(this.partLastByte());
        hashCode = 31 * hashCode + Objects.hashCode(this.layerPartBlob());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UploadLayerPartRequest)) {
            return false;
        }
        UploadLayerPartRequest other = (UploadLayerPartRequest)((Object)obj);
        return Objects.equals(this.registryId(), other.registryId()) && Objects.equals(this.repositoryName(), other.repositoryName()) && Objects.equals(this.uploadId(), other.uploadId()) && Objects.equals(this.partFirstByte(), other.partFirstByte()) && Objects.equals(this.partLastByte(), other.partLastByte()) && Objects.equals(this.layerPartBlob(), other.layerPartBlob());
    }

    public String toString() {
        return ToString.builder((String)"UploadLayerPartRequest").add("RegistryId", (Object)this.registryId()).add("RepositoryName", (Object)this.repositoryName()).add("UploadId", (Object)this.uploadId()).add("PartFirstByte", (Object)this.partFirstByte()).add("PartLastByte", (Object)this.partLastByte()).add("LayerPartBlob", (Object)this.layerPartBlob()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "registryId": {
                return Optional.of(clazz.cast(this.registryId()));
            }
            case "repositoryName": {
                return Optional.of(clazz.cast(this.repositoryName()));
            }
            case "uploadId": {
                return Optional.of(clazz.cast(this.uploadId()));
            }
            case "partFirstByte": {
                return Optional.of(clazz.cast(this.partFirstByte()));
            }
            case "partLastByte": {
                return Optional.of(clazz.cast(this.partLastByte()));
            }
            case "layerPartBlob": {
                return Optional.of(clazz.cast(this.layerPartBlob()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ECRRequest.BuilderImpl
    implements Builder {
        private String registryId;
        private String repositoryName;
        private String uploadId;
        private Long partFirstByte;
        private Long partLastByte;
        private ByteBuffer layerPartBlob;

        private BuilderImpl() {
        }

        private BuilderImpl(UploadLayerPartRequest model) {
            super(model);
            this.registryId(model.registryId);
            this.repositoryName(model.repositoryName);
            this.uploadId(model.uploadId);
            this.partFirstByte(model.partFirstByte);
            this.partLastByte(model.partLastByte);
            this.layerPartBlob(model.layerPartBlob);
        }

        public final String getRegistryId() {
            return this.registryId;
        }

        @Override
        public final Builder registryId(String registryId) {
            this.registryId = registryId;
            return this;
        }

        public final void setRegistryId(String registryId) {
            this.registryId = registryId;
        }

        public final String getRepositoryName() {
            return this.repositoryName;
        }

        @Override
        public final Builder repositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
            return this;
        }

        public final void setRepositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
        }

        public final String getUploadId() {
            return this.uploadId;
        }

        @Override
        public final Builder uploadId(String uploadId) {
            this.uploadId = uploadId;
            return this;
        }

        public final void setUploadId(String uploadId) {
            this.uploadId = uploadId;
        }

        public final Long getPartFirstByte() {
            return this.partFirstByte;
        }

        @Override
        public final Builder partFirstByte(Long partFirstByte) {
            this.partFirstByte = partFirstByte;
            return this;
        }

        public final void setPartFirstByte(Long partFirstByte) {
            this.partFirstByte = partFirstByte;
        }

        public final Long getPartLastByte() {
            return this.partLastByte;
        }

        @Override
        public final Builder partLastByte(Long partLastByte) {
            this.partLastByte = partLastByte;
            return this;
        }

        public final void setPartLastByte(Long partLastByte) {
            this.partLastByte = partLastByte;
        }

        public final ByteBuffer getLayerPartBlob() {
            return this.layerPartBlob;
        }

        @Override
        public final Builder layerPartBlob(ByteBuffer layerPartBlob) {
            this.layerPartBlob = StandardMemberCopier.copy((ByteBuffer)layerPartBlob);
            return this;
        }

        public final void setLayerPartBlob(ByteBuffer layerPartBlob) {
            this.layerPartBlob = StandardMemberCopier.copy((ByteBuffer)layerPartBlob);
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public UploadLayerPartRequest build() {
            return new UploadLayerPartRequest(this);
        }
    }

    public static interface Builder
    extends ECRRequest.Builder,
    CopyableBuilder<Builder, UploadLayerPartRequest> {
        public Builder registryId(String var1);

        public Builder repositoryName(String var1);

        public Builder uploadId(String var1);

        public Builder partFirstByte(Long var1);

        public Builder partLastByte(Long var1);

        public Builder layerPartBlob(ByteBuffer var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> var1);
    }
}

