/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecr.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.ecr.model.ImageIdentifier;
import software.amazon.awssdk.services.ecr.model.ImageIdentifierListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListImagesResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListImagesResponse> {
    private final List<ImageIdentifier> imageIds;
    private final String nextToken;

    private ListImagesResponse(BuilderImpl builder) {
        this.imageIds = builder.imageIds;
        this.nextToken = builder.nextToken;
    }

    public List<ImageIdentifier> imageIds() {
        return this.imageIds;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.imageIds() == null ? 0 : this.imageIds().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListImagesResponse)) {
            return false;
        }
        ListImagesResponse other = (ListImagesResponse)((Object)obj);
        if (other.imageIds() == null ^ this.imageIds() == null) {
            return false;
        }
        if (other.imageIds() != null && !other.imageIds().equals(this.imageIds())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.imageIds() != null) {
            sb.append("ImageIds: ").append(this.imageIds()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<ImageIdentifier> imageIds;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListImagesResponse model) {
            this.setImageIds(model.imageIds);
            this.setNextToken(model.nextToken);
        }

        public final Collection<ImageIdentifier> getImageIds() {
            return this.imageIds;
        }

        @Override
        public final Builder imageIds(Collection<ImageIdentifier> imageIds) {
            this.imageIds = ImageIdentifierListCopier.copy(imageIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder imageIds(ImageIdentifier ... imageIds) {
            if (this.imageIds == null) {
                this.imageIds = new ArrayList<ImageIdentifier>(imageIds.length);
            }
            for (ImageIdentifier e : imageIds) {
                this.imageIds.add(e);
            }
            return this;
        }

        public final void setImageIds(Collection<ImageIdentifier> imageIds) {
            this.imageIds = ImageIdentifierListCopier.copy(imageIds);
        }

        @SafeVarargs
        public final void setImageIds(ImageIdentifier ... imageIds) {
            if (this.imageIds == null) {
                this.imageIds = new ArrayList<ImageIdentifier>(imageIds.length);
            }
            for (ImageIdentifier e : imageIds) {
                this.imageIds.add(e);
            }
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public ListImagesResponse build() {
            return new ListImagesResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListImagesResponse> {
        public Builder imageIds(Collection<ImageIdentifier> var1);

        public Builder imageIds(ImageIdentifier ... var1);

        public Builder nextToken(String var1);
    }
}

