/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecr.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.ecr.model.Layer;
import software.amazon.awssdk.services.ecr.model.LayerFailure;
import software.amazon.awssdk.services.ecr.model.LayerFailureListCopier;
import software.amazon.awssdk.services.ecr.model.LayerListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class BatchCheckLayerAvailabilityResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, BatchCheckLayerAvailabilityResponse> {
    private final List<Layer> layers;
    private final List<LayerFailure> failures;

    private BatchCheckLayerAvailabilityResponse(BuilderImpl builder) {
        this.layers = builder.layers;
        this.failures = builder.failures;
    }

    public List<Layer> layers() {
        return this.layers;
    }

    public List<LayerFailure> failures() {
        return this.failures;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.layers() == null ? 0 : this.layers().hashCode());
        hashCode = 31 * hashCode + (this.failures() == null ? 0 : this.failures().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchCheckLayerAvailabilityResponse)) {
            return false;
        }
        BatchCheckLayerAvailabilityResponse other = (BatchCheckLayerAvailabilityResponse)((Object)obj);
        if (other.layers() == null ^ this.layers() == null) {
            return false;
        }
        if (other.layers() != null && !other.layers().equals(this.layers())) {
            return false;
        }
        if (other.failures() == null ^ this.failures() == null) {
            return false;
        }
        return other.failures() == null || other.failures().equals(this.failures());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.layers() != null) {
            sb.append("Layers: ").append(this.layers()).append(",");
        }
        if (this.failures() != null) {
            sb.append("Failures: ").append(this.failures()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<Layer> layers;
        private List<LayerFailure> failures;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchCheckLayerAvailabilityResponse model) {
            this.setLayers(model.layers);
            this.setFailures(model.failures);
        }

        public final Collection<Layer> getLayers() {
            return this.layers;
        }

        @Override
        public final Builder layers(Collection<Layer> layers) {
            this.layers = LayerListCopier.copy(layers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder layers(Layer ... layers) {
            if (this.layers == null) {
                this.layers = new ArrayList<Layer>(layers.length);
            }
            for (Layer e : layers) {
                this.layers.add(e);
            }
            return this;
        }

        public final void setLayers(Collection<Layer> layers) {
            this.layers = LayerListCopier.copy(layers);
        }

        @SafeVarargs
        public final void setLayers(Layer ... layers) {
            if (this.layers == null) {
                this.layers = new ArrayList<Layer>(layers.length);
            }
            for (Layer e : layers) {
                this.layers.add(e);
            }
        }

        public final Collection<LayerFailure> getFailures() {
            return this.failures;
        }

        @Override
        public final Builder failures(Collection<LayerFailure> failures) {
            this.failures = LayerFailureListCopier.copy(failures);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failures(LayerFailure ... failures) {
            if (this.failures == null) {
                this.failures = new ArrayList<LayerFailure>(failures.length);
            }
            for (LayerFailure e : failures) {
                this.failures.add(e);
            }
            return this;
        }

        public final void setFailures(Collection<LayerFailure> failures) {
            this.failures = LayerFailureListCopier.copy(failures);
        }

        @SafeVarargs
        public final void setFailures(LayerFailure ... failures) {
            if (this.failures == null) {
                this.failures = new ArrayList<LayerFailure>(failures.length);
            }
            for (LayerFailure e : failures) {
                this.failures.add(e);
            }
        }

        public BatchCheckLayerAvailabilityResponse build() {
            return new BatchCheckLayerAvailabilityResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, BatchCheckLayerAvailabilityResponse> {
        public Builder layers(Collection<Layer> var1);

        public Builder layers(Layer ... var1);

        public Builder failures(Collection<LayerFailure> var1);

        public Builder failures(LayerFailure ... var1);
    }
}

