/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2instanceconnect;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.services.ec2instanceconnect.model.SendSshPublicKeyRequest;
import software.amazon.awssdk.services.ec2instanceconnect.model.SendSshPublicKeyResponse;

/**
 * Service client for accessing EC2 Instance Connect asynchronously. This can be created using the static
 * {@link #builder()} method.
 *
 * <p>
 * AWS EC2 Connect Service is a service that enables system administrators to publish temporary SSH keys to their EC2
 * instances in order to establish connections to their instances without leaving a permanent authentication option.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public interface Ec2InstanceConnectAsyncClient extends SdkClient {
    String SERVICE_NAME = "ec2-instance-connect";

    /**
     * Create a {@link Ec2InstanceConnectAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static Ec2InstanceConnectAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link Ec2InstanceConnectAsyncClient}.
     */
    static Ec2InstanceConnectAsyncClientBuilder builder() {
        return new DefaultEc2InstanceConnectAsyncClientBuilder();
    }

    /**
     * <p>
     * Pushes an SSH public key to a particular OS user on a given EC2 instance for 60 seconds.
     * </p>
     *
     * @param sendSshPublicKeyRequest
     * @return A Java Future containing the result of the SendSSHPublicKey operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AuthException Indicates that either your AWS credentials are invalid or you do not have access to the
     *         EC2 instance.</li>
     *         <li>InvalidArgsException Indicates that you provided bad input. Ensure you have a valid instance ID, the
     *         correct zone, and a valid SSH public key.</li>
     *         <li>ServiceException Indicates that the service encountered an error. Follow the message's instructions
     *         and try again.</li>
     *         <li>ThrottlingException Indicates you have been making requests too frequently and have been throttled.
     *         Wait for a while and try again. If higher call volume is warranted contact AWS Support.</li>
     *         <li>Ec2InstanceNotFoundException Indicates that the instance requested was not found in the given zone.
     *         Check that you have provided a valid instance ID and the correct zone.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2InstanceConnectException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample Ec2InstanceConnectAsyncClient.SendSSHPublicKey
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-instance-connect-2018-04-02/SendSSHPublicKey"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<SendSshPublicKeyResponse> sendSSHPublicKey(SendSshPublicKeyRequest sendSshPublicKeyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Pushes an SSH public key to a particular OS user on a given EC2 instance for 60 seconds.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SendSshPublicKeyRequest.Builder} avoiding the need
     * to create one manually via {@link SendSshPublicKeyRequest#builder()}
     * </p>
     *
     * @param sendSshPublicKeyRequest
     *        A {@link Consumer} that will call methods on {@link SendSSHPublicKeyRequest.Builder} to create a request.
     * @return A Java Future containing the result of the SendSSHPublicKey operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AuthException Indicates that either your AWS credentials are invalid or you do not have access to the
     *         EC2 instance.</li>
     *         <li>InvalidArgsException Indicates that you provided bad input. Ensure you have a valid instance ID, the
     *         correct zone, and a valid SSH public key.</li>
     *         <li>ServiceException Indicates that the service encountered an error. Follow the message's instructions
     *         and try again.</li>
     *         <li>ThrottlingException Indicates you have been making requests too frequently and have been throttled.
     *         Wait for a while and try again. If higher call volume is warranted contact AWS Support.</li>
     *         <li>Ec2InstanceNotFoundException Indicates that the instance requested was not found in the given zone.
     *         Check that you have provided a valid instance ID and the correct zone.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2InstanceConnectException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample Ec2InstanceConnectAsyncClient.SendSSHPublicKey
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-instance-connect-2018-04-02/SendSSHPublicKey"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<SendSshPublicKeyResponse> sendSSHPublicKey(
            Consumer<SendSshPublicKeyRequest.Builder> sendSshPublicKeyRequest) {
        return sendSSHPublicKey(SendSshPublicKeyRequest.builder().applyMutation(sendSshPublicKeyRequest).build());
    }
}
