/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.AvailabilityZoneMessage;
import software.amazon.awssdk.services.ec2.model.AvailabilityZoneMessageListCopier;
import software.amazon.awssdk.services.ec2.model.AvailabilityZoneState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AvailabilityZone
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AvailabilityZone> {
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AvailabilityZone.getter(AvailabilityZone::stateAsString)).setter(AvailabilityZone.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ZoneState").unmarshallLocationName("zoneState").build()}).build();
    private static final SdkField<List<AvailabilityZoneMessage>> MESSAGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(AvailabilityZone.getter(AvailabilityZone::messages)).setter(AvailabilityZone.setter(Builder::messages)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MessageSet").unmarshallLocationName("messageSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AvailabilityZoneMessage::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> REGION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AvailabilityZone.getter(AvailabilityZone::regionName)).setter(AvailabilityZone.setter(Builder::regionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegionName").unmarshallLocationName("regionName").build()}).build();
    private static final SdkField<String> ZONE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AvailabilityZone.getter(AvailabilityZone::zoneName)).setter(AvailabilityZone.setter(Builder::zoneName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ZoneName").unmarshallLocationName("zoneName").build()}).build();
    private static final SdkField<String> ZONE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AvailabilityZone.getter(AvailabilityZone::zoneId)).setter(AvailabilityZone.setter(Builder::zoneId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ZoneId").unmarshallLocationName("zoneId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATE_FIELD, MESSAGES_FIELD, REGION_NAME_FIELD, ZONE_NAME_FIELD, ZONE_ID_FIELD));
    private static final long serialVersionUID = 1L;
    private final String state;
    private final List<AvailabilityZoneMessage> messages;
    private final String regionName;
    private final String zoneName;
    private final String zoneId;

    private AvailabilityZone(BuilderImpl builder) {
        this.state = builder.state;
        this.messages = builder.messages;
        this.regionName = builder.regionName;
        this.zoneName = builder.zoneName;
        this.zoneId = builder.zoneId;
    }

    public AvailabilityZoneState state() {
        return AvailabilityZoneState.fromValue(this.state);
    }

    public String stateAsString() {
        return this.state;
    }

    public List<AvailabilityZoneMessage> messages() {
        return this.messages;
    }

    public String regionName() {
        return this.regionName;
    }

    public String zoneName() {
        return this.zoneName;
    }

    public String zoneId() {
        return this.zoneId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.messages());
        hashCode = 31 * hashCode + Objects.hashCode(this.regionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.zoneName());
        hashCode = 31 * hashCode + Objects.hashCode(this.zoneId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AvailabilityZone)) {
            return false;
        }
        AvailabilityZone other = (AvailabilityZone)obj;
        return Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.messages(), other.messages()) && Objects.equals(this.regionName(), other.regionName()) && Objects.equals(this.zoneName(), other.zoneName()) && Objects.equals(this.zoneId(), other.zoneId());
    }

    public String toString() {
        return ToString.builder((String)"AvailabilityZone").add("State", (Object)this.stateAsString()).add("Messages", this.messages()).add("RegionName", (Object)this.regionName()).add("ZoneName", (Object)this.zoneName()).add("ZoneId", (Object)this.zoneId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "Messages": {
                return Optional.ofNullable(clazz.cast(this.messages()));
            }
            case "RegionName": {
                return Optional.ofNullable(clazz.cast(this.regionName()));
            }
            case "ZoneName": {
                return Optional.ofNullable(clazz.cast(this.zoneName()));
            }
            case "ZoneId": {
                return Optional.ofNullable(clazz.cast(this.zoneId()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AvailabilityZone, T> g) {
        return obj -> g.apply((AvailabilityZone)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String state;
        private List<AvailabilityZoneMessage> messages = DefaultSdkAutoConstructList.getInstance();
        private String regionName;
        private String zoneName;
        private String zoneId;

        private BuilderImpl() {
        }

        private BuilderImpl(AvailabilityZone model) {
            this.state(model.state);
            this.messages(model.messages);
            this.regionName(model.regionName);
            this.zoneName(model.zoneName);
            this.zoneId(model.zoneId);
        }

        public final String getStateAsString() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(AvailabilityZoneState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final Collection<AvailabilityZoneMessage.Builder> getMessages() {
            return this.messages != null ? (Collection)this.messages.stream().map(AvailabilityZoneMessage::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder messages(Collection<AvailabilityZoneMessage> messages) {
            this.messages = AvailabilityZoneMessageListCopier.copy(messages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder messages(AvailabilityZoneMessage ... messages) {
            this.messages(Arrays.asList(messages));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder messages(Consumer<AvailabilityZoneMessage.Builder> ... messages) {
            this.messages(Stream.of(messages).map(c -> (AvailabilityZoneMessage)((AvailabilityZoneMessage.Builder)AvailabilityZoneMessage.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setMessages(Collection<AvailabilityZoneMessage.BuilderImpl> messages) {
            this.messages = AvailabilityZoneMessageListCopier.copyFromBuilder(messages);
        }

        public final String getRegionName() {
            return this.regionName;
        }

        @Override
        public final Builder regionName(String regionName) {
            this.regionName = regionName;
            return this;
        }

        public final void setRegionName(String regionName) {
            this.regionName = regionName;
        }

        public final String getZoneName() {
            return this.zoneName;
        }

        @Override
        public final Builder zoneName(String zoneName) {
            this.zoneName = zoneName;
            return this;
        }

        public final void setZoneName(String zoneName) {
            this.zoneName = zoneName;
        }

        public final String getZoneId() {
            return this.zoneId;
        }

        @Override
        public final Builder zoneId(String zoneId) {
            this.zoneId = zoneId;
            return this;
        }

        public final void setZoneId(String zoneId) {
            this.zoneId = zoneId;
        }

        public AvailabilityZone build() {
            return new AvailabilityZone(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AvailabilityZone> {
        public Builder state(String var1);

        public Builder state(AvailabilityZoneState var1);

        public Builder messages(Collection<AvailabilityZoneMessage> var1);

        public Builder messages(AvailabilityZoneMessage ... var1);

        public Builder messages(Consumer<AvailabilityZoneMessage.Builder> ... var1);

        public Builder regionName(String var1);

        public Builder zoneName(String var1);

        public Builder zoneId(String var1);
    }
}

