/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.PlacementGroupState;
import software.amazon.awssdk.services.ec2.model.PlacementStrategy;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PlacementGroup
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PlacementGroup> {
    private static final SdkField<String> GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PlacementGroup.getter(PlacementGroup::groupName)).setter(PlacementGroup.setter(Builder::groupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupName").unmarshallLocationName("groupName").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PlacementGroup.getter(PlacementGroup::stateAsString)).setter(PlacementGroup.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").unmarshallLocationName("state").build()}).build();
    private static final SdkField<String> STRATEGY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PlacementGroup.getter(PlacementGroup::strategyAsString)).setter(PlacementGroup.setter(Builder::strategy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Strategy").unmarshallLocationName("strategy").build()}).build();
    private static final SdkField<Integer> PARTITION_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(PlacementGroup.getter(PlacementGroup::partitionCount)).setter(PlacementGroup.setter(Builder::partitionCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PartitionCount").unmarshallLocationName("partitionCount").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GROUP_NAME_FIELD, STATE_FIELD, STRATEGY_FIELD, PARTITION_COUNT_FIELD));
    private static final long serialVersionUID = 1L;
    private final String groupName;
    private final String state;
    private final String strategy;
    private final Integer partitionCount;

    private PlacementGroup(BuilderImpl builder) {
        this.groupName = builder.groupName;
        this.state = builder.state;
        this.strategy = builder.strategy;
        this.partitionCount = builder.partitionCount;
    }

    public String groupName() {
        return this.groupName;
    }

    public PlacementGroupState state() {
        return PlacementGroupState.fromValue(this.state);
    }

    public String stateAsString() {
        return this.state;
    }

    public PlacementStrategy strategy() {
        return PlacementStrategy.fromValue(this.strategy);
    }

    public String strategyAsString() {
        return this.strategy;
    }

    public Integer partitionCount() {
        return this.partitionCount;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.groupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.strategyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.partitionCount());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PlacementGroup)) {
            return false;
        }
        PlacementGroup other = (PlacementGroup)obj;
        return Objects.equals(this.groupName(), other.groupName()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.strategyAsString(), other.strategyAsString()) && Objects.equals(this.partitionCount(), other.partitionCount());
    }

    public String toString() {
        return ToString.builder((String)"PlacementGroup").add("GroupName", (Object)this.groupName()).add("State", (Object)this.stateAsString()).add("Strategy", (Object)this.strategyAsString()).add("PartitionCount", (Object)this.partitionCount()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GroupName": {
                return Optional.ofNullable(clazz.cast(this.groupName()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "Strategy": {
                return Optional.ofNullable(clazz.cast(this.strategyAsString()));
            }
            case "PartitionCount": {
                return Optional.ofNullable(clazz.cast(this.partitionCount()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PlacementGroup, T> g) {
        return obj -> g.apply((PlacementGroup)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String groupName;
        private String state;
        private String strategy;
        private Integer partitionCount;

        private BuilderImpl() {
        }

        private BuilderImpl(PlacementGroup model) {
            this.groupName(model.groupName);
            this.state(model.state);
            this.strategy(model.strategy);
            this.partitionCount(model.partitionCount);
        }

        public final String getGroupName() {
            return this.groupName;
        }

        @Override
        public final Builder groupName(String groupName) {
            this.groupName = groupName;
            return this;
        }

        public final void setGroupName(String groupName) {
            this.groupName = groupName;
        }

        public final String getStateAsString() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(PlacementGroupState state) {
            this.state(state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final String getStrategyAsString() {
            return this.strategy;
        }

        @Override
        public final Builder strategy(String strategy) {
            this.strategy = strategy;
            return this;
        }

        @Override
        public final Builder strategy(PlacementStrategy strategy) {
            this.strategy(strategy.toString());
            return this;
        }

        public final void setStrategy(String strategy) {
            this.strategy = strategy;
        }

        public final Integer getPartitionCount() {
            return this.partitionCount;
        }

        @Override
        public final Builder partitionCount(Integer partitionCount) {
            this.partitionCount = partitionCount;
            return this;
        }

        public final void setPartitionCount(Integer partitionCount) {
            this.partitionCount = partitionCount;
        }

        public PlacementGroup build() {
            return new PlacementGroup(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PlacementGroup> {
        public Builder groupName(String var1);

        public Builder state(String var1);

        public Builder state(PlacementGroupState var1);

        public Builder strategy(String var1);

        public Builder strategy(PlacementStrategy var1);

        public Builder partitionCount(Integer var1);
    }
}

