/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.Affinity;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.HostTenancy;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModifyInstancePlacementRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, ModifyInstancePlacementRequest> {
    private static final SdkField<String> AFFINITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ModifyInstancePlacementRequest.getter(ModifyInstancePlacementRequest::affinityAsString)).setter(ModifyInstancePlacementRequest.setter(Builder::affinity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Affinity").unmarshallLocationName("affinity").build()}).build();
    private static final SdkField<String> GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ModifyInstancePlacementRequest.getter(ModifyInstancePlacementRequest::groupName)).setter(ModifyInstancePlacementRequest.setter(Builder::groupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupName").unmarshallLocationName("GroupName").build()}).build();
    private static final SdkField<String> HOST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ModifyInstancePlacementRequest.getter(ModifyInstancePlacementRequest::hostId)).setter(ModifyInstancePlacementRequest.setter(Builder::hostId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HostId").unmarshallLocationName("hostId").build()}).build();
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ModifyInstancePlacementRequest.getter(ModifyInstancePlacementRequest::instanceId)).setter(ModifyInstancePlacementRequest.setter(Builder::instanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").unmarshallLocationName("instanceId").build()}).build();
    private static final SdkField<String> TENANCY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ModifyInstancePlacementRequest.getter(ModifyInstancePlacementRequest::tenancyAsString)).setter(ModifyInstancePlacementRequest.setter(Builder::tenancy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tenancy").unmarshallLocationName("tenancy").build()}).build();
    private static final SdkField<Integer> PARTITION_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(ModifyInstancePlacementRequest.getter(ModifyInstancePlacementRequest::partitionNumber)).setter(ModifyInstancePlacementRequest.setter(Builder::partitionNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PartitionNumber").unmarshallLocationName("PartitionNumber").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AFFINITY_FIELD, GROUP_NAME_FIELD, HOST_ID_FIELD, INSTANCE_ID_FIELD, TENANCY_FIELD, PARTITION_NUMBER_FIELD));
    private final String affinity;
    private final String groupName;
    private final String hostId;
    private final String instanceId;
    private final String tenancy;
    private final Integer partitionNumber;

    private ModifyInstancePlacementRequest(BuilderImpl builder) {
        super(builder);
        this.affinity = builder.affinity;
        this.groupName = builder.groupName;
        this.hostId = builder.hostId;
        this.instanceId = builder.instanceId;
        this.tenancy = builder.tenancy;
        this.partitionNumber = builder.partitionNumber;
    }

    public Affinity affinity() {
        return Affinity.fromValue(this.affinity);
    }

    public String affinityAsString() {
        return this.affinity;
    }

    public String groupName() {
        return this.groupName;
    }

    public String hostId() {
        return this.hostId;
    }

    public String instanceId() {
        return this.instanceId;
    }

    public HostTenancy tenancy() {
        return HostTenancy.fromValue(this.tenancy);
    }

    public String tenancyAsString() {
        return this.tenancy;
    }

    public Integer partitionNumber() {
        return this.partitionNumber;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.affinityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.groupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hostId());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.tenancyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.partitionNumber());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyInstancePlacementRequest)) {
            return false;
        }
        ModifyInstancePlacementRequest other = (ModifyInstancePlacementRequest)((Object)obj);
        return Objects.equals(this.affinityAsString(), other.affinityAsString()) && Objects.equals(this.groupName(), other.groupName()) && Objects.equals(this.hostId(), other.hostId()) && Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.tenancyAsString(), other.tenancyAsString()) && Objects.equals(this.partitionNumber(), other.partitionNumber());
    }

    public String toString() {
        return ToString.builder((String)"ModifyInstancePlacementRequest").add("Affinity", (Object)this.affinityAsString()).add("GroupName", (Object)this.groupName()).add("HostId", (Object)this.hostId()).add("InstanceId", (Object)this.instanceId()).add("Tenancy", (Object)this.tenancyAsString()).add("PartitionNumber", (Object)this.partitionNumber()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Affinity": {
                return Optional.ofNullable(clazz.cast(this.affinityAsString()));
            }
            case "GroupName": {
                return Optional.ofNullable(clazz.cast(this.groupName()));
            }
            case "HostId": {
                return Optional.ofNullable(clazz.cast(this.hostId()));
            }
            case "InstanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
            case "Tenancy": {
                return Optional.ofNullable(clazz.cast(this.tenancyAsString()));
            }
            case "PartitionNumber": {
                return Optional.ofNullable(clazz.cast(this.partitionNumber()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifyInstancePlacementRequest, T> g) {
        return obj -> g.apply((ModifyInstancePlacementRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private String affinity;
        private String groupName;
        private String hostId;
        private String instanceId;
        private String tenancy;
        private Integer partitionNumber;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyInstancePlacementRequest model) {
            super(model);
            this.affinity(model.affinity);
            this.groupName(model.groupName);
            this.hostId(model.hostId);
            this.instanceId(model.instanceId);
            this.tenancy(model.tenancy);
            this.partitionNumber(model.partitionNumber);
        }

        public final String getAffinityAsString() {
            return this.affinity;
        }

        @Override
        public final Builder affinity(String affinity) {
            this.affinity = affinity;
            return this;
        }

        @Override
        public final Builder affinity(Affinity affinity) {
            this.affinity(affinity.toString());
            return this;
        }

        public final void setAffinity(String affinity) {
            this.affinity = affinity;
        }

        public final String getGroupName() {
            return this.groupName;
        }

        @Override
        public final Builder groupName(String groupName) {
            this.groupName = groupName;
            return this;
        }

        public final void setGroupName(String groupName) {
            this.groupName = groupName;
        }

        public final String getHostId() {
            return this.hostId;
        }

        @Override
        public final Builder hostId(String hostId) {
            this.hostId = hostId;
            return this;
        }

        public final void setHostId(String hostId) {
            this.hostId = hostId;
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final String getTenancyAsString() {
            return this.tenancy;
        }

        @Override
        public final Builder tenancy(String tenancy) {
            this.tenancy = tenancy;
            return this;
        }

        @Override
        public final Builder tenancy(HostTenancy tenancy) {
            this.tenancy(tenancy.toString());
            return this;
        }

        public final void setTenancy(String tenancy) {
            this.tenancy = tenancy;
        }

        public final Integer getPartitionNumber() {
            return this.partitionNumber;
        }

        @Override
        public final Builder partitionNumber(Integer partitionNumber) {
            this.partitionNumber = partitionNumber;
            return this;
        }

        public final void setPartitionNumber(Integer partitionNumber) {
            this.partitionNumber = partitionNumber;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyInstancePlacementRequest build() {
            return new ModifyInstancePlacementRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ModifyInstancePlacementRequest> {
        public Builder affinity(String var1);

        public Builder affinity(Affinity var1);

        public Builder groupName(String var1);

        public Builder hostId(String var1);

        public Builder instanceId(String var1);

        public Builder tenancy(String var1);

        public Builder tenancy(HostTenancy var1);

        public Builder partitionNumber(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

