/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.ConnectionLogOptions;
import software.amazon.awssdk.services.ec2.model.DnsServersOptionsModifyStructure;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModifyClientVpnEndpointRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, ModifyClientVpnEndpointRequest> {
    private static final SdkField<String> CLIENT_VPN_ENDPOINT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ModifyClientVpnEndpointRequest.getter(ModifyClientVpnEndpointRequest::clientVpnEndpointId)).setter(ModifyClientVpnEndpointRequest.setter(Builder::clientVpnEndpointId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientVpnEndpointId").unmarshallLocationName("ClientVpnEndpointId").build()}).build();
    private static final SdkField<String> SERVER_CERTIFICATE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ModifyClientVpnEndpointRequest.getter(ModifyClientVpnEndpointRequest::serverCertificateArn)).setter(ModifyClientVpnEndpointRequest.setter(Builder::serverCertificateArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerCertificateArn").unmarshallLocationName("ServerCertificateArn").build()}).build();
    private static final SdkField<ConnectionLogOptions> CONNECTION_LOG_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(ModifyClientVpnEndpointRequest.getter(ModifyClientVpnEndpointRequest::connectionLogOptions)).setter(ModifyClientVpnEndpointRequest.setter(Builder::connectionLogOptions)).constructor(ConnectionLogOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionLogOptions").unmarshallLocationName("ConnectionLogOptions").build()}).build();
    private static final SdkField<DnsServersOptionsModifyStructure> DNS_SERVERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(ModifyClientVpnEndpointRequest.getter(ModifyClientVpnEndpointRequest::dnsServers)).setter(ModifyClientVpnEndpointRequest.setter(Builder::dnsServers)).constructor(DnsServersOptionsModifyStructure::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DnsServers").unmarshallLocationName("DnsServers").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ModifyClientVpnEndpointRequest.getter(ModifyClientVpnEndpointRequest::description)).setter(ModifyClientVpnEndpointRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").unmarshallLocationName("Description").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_VPN_ENDPOINT_ID_FIELD, SERVER_CERTIFICATE_ARN_FIELD, CONNECTION_LOG_OPTIONS_FIELD, DNS_SERVERS_FIELD, DESCRIPTION_FIELD));
    private final String clientVpnEndpointId;
    private final String serverCertificateArn;
    private final ConnectionLogOptions connectionLogOptions;
    private final DnsServersOptionsModifyStructure dnsServers;
    private final String description;

    private ModifyClientVpnEndpointRequest(BuilderImpl builder) {
        super(builder);
        this.clientVpnEndpointId = builder.clientVpnEndpointId;
        this.serverCertificateArn = builder.serverCertificateArn;
        this.connectionLogOptions = builder.connectionLogOptions;
        this.dnsServers = builder.dnsServers;
        this.description = builder.description;
    }

    public String clientVpnEndpointId() {
        return this.clientVpnEndpointId;
    }

    public String serverCertificateArn() {
        return this.serverCertificateArn;
    }

    public ConnectionLogOptions connectionLogOptions() {
        return this.connectionLogOptions;
    }

    public DnsServersOptionsModifyStructure dnsServers() {
        return this.dnsServers;
    }

    public String description() {
        return this.description;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clientVpnEndpointId());
        hashCode = 31 * hashCode + Objects.hashCode(this.serverCertificateArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionLogOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.dnsServers());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyClientVpnEndpointRequest)) {
            return false;
        }
        ModifyClientVpnEndpointRequest other = (ModifyClientVpnEndpointRequest)((Object)obj);
        return Objects.equals(this.clientVpnEndpointId(), other.clientVpnEndpointId()) && Objects.equals(this.serverCertificateArn(), other.serverCertificateArn()) && Objects.equals(this.connectionLogOptions(), other.connectionLogOptions()) && Objects.equals(this.dnsServers(), other.dnsServers()) && Objects.equals(this.description(), other.description());
    }

    public String toString() {
        return ToString.builder((String)"ModifyClientVpnEndpointRequest").add("ClientVpnEndpointId", (Object)this.clientVpnEndpointId()).add("ServerCertificateArn", (Object)this.serverCertificateArn()).add("ConnectionLogOptions", (Object)this.connectionLogOptions()).add("DnsServers", (Object)this.dnsServers()).add("Description", (Object)this.description()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClientVpnEndpointId": {
                return Optional.ofNullable(clazz.cast(this.clientVpnEndpointId()));
            }
            case "ServerCertificateArn": {
                return Optional.ofNullable(clazz.cast(this.serverCertificateArn()));
            }
            case "ConnectionLogOptions": {
                return Optional.ofNullable(clazz.cast(this.connectionLogOptions()));
            }
            case "DnsServers": {
                return Optional.ofNullable(clazz.cast(this.dnsServers()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifyClientVpnEndpointRequest, T> g) {
        return obj -> g.apply((ModifyClientVpnEndpointRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private String clientVpnEndpointId;
        private String serverCertificateArn;
        private ConnectionLogOptions connectionLogOptions;
        private DnsServersOptionsModifyStructure dnsServers;
        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyClientVpnEndpointRequest model) {
            super(model);
            this.clientVpnEndpointId(model.clientVpnEndpointId);
            this.serverCertificateArn(model.serverCertificateArn);
            this.connectionLogOptions(model.connectionLogOptions);
            this.dnsServers(model.dnsServers);
            this.description(model.description);
        }

        public final String getClientVpnEndpointId() {
            return this.clientVpnEndpointId;
        }

        @Override
        public final Builder clientVpnEndpointId(String clientVpnEndpointId) {
            this.clientVpnEndpointId = clientVpnEndpointId;
            return this;
        }

        public final void setClientVpnEndpointId(String clientVpnEndpointId) {
            this.clientVpnEndpointId = clientVpnEndpointId;
        }

        public final String getServerCertificateArn() {
            return this.serverCertificateArn;
        }

        @Override
        public final Builder serverCertificateArn(String serverCertificateArn) {
            this.serverCertificateArn = serverCertificateArn;
            return this;
        }

        public final void setServerCertificateArn(String serverCertificateArn) {
            this.serverCertificateArn = serverCertificateArn;
        }

        public final ConnectionLogOptions.Builder getConnectionLogOptions() {
            return this.connectionLogOptions != null ? this.connectionLogOptions.toBuilder() : null;
        }

        @Override
        public final Builder connectionLogOptions(ConnectionLogOptions connectionLogOptions) {
            this.connectionLogOptions = connectionLogOptions;
            return this;
        }

        public final void setConnectionLogOptions(ConnectionLogOptions.BuilderImpl connectionLogOptions) {
            this.connectionLogOptions = connectionLogOptions != null ? connectionLogOptions.build() : null;
        }

        public final DnsServersOptionsModifyStructure.Builder getDnsServers() {
            return this.dnsServers != null ? this.dnsServers.toBuilder() : null;
        }

        @Override
        public final Builder dnsServers(DnsServersOptionsModifyStructure dnsServers) {
            this.dnsServers = dnsServers;
            return this;
        }

        public final void setDnsServers(DnsServersOptionsModifyStructure.BuilderImpl dnsServers) {
            this.dnsServers = dnsServers != null ? dnsServers.build() : null;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyClientVpnEndpointRequest build() {
            return new ModifyClientVpnEndpointRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ModifyClientVpnEndpointRequest> {
        public Builder clientVpnEndpointId(String var1);

        public Builder serverCertificateArn(String var1);

        public Builder connectionLogOptions(ConnectionLogOptions var1);

        default public Builder connectionLogOptions(Consumer<ConnectionLogOptions.Builder> connectionLogOptions) {
            return this.connectionLogOptions((ConnectionLogOptions)((ConnectionLogOptions.Builder)ConnectionLogOptions.builder().applyMutation(connectionLogOptions)).build());
        }

        public Builder dnsServers(DnsServersOptionsModifyStructure var1);

        default public Builder dnsServers(Consumer<DnsServersOptionsModifyStructure.Builder> dnsServers) {
            return this.dnsServers((DnsServersOptionsModifyStructure)((DnsServersOptionsModifyStructure.Builder)DnsServersOptionsModifyStructure.builder().applyMutation(dnsServers)).build());
        }

        public Builder description(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

