/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.InstanceInterruptionBehavior;
import software.amazon.awssdk.services.ec2.model.SpotInstanceType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LaunchTemplateSpotMarketOptionsRequest
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LaunchTemplateSpotMarketOptionsRequest> {
    private static final SdkField<String> MAX_PRICE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(LaunchTemplateSpotMarketOptionsRequest.getter(LaunchTemplateSpotMarketOptionsRequest::maxPrice)).setter(LaunchTemplateSpotMarketOptionsRequest.setter(Builder::maxPrice)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxPrice").unmarshallLocationName("MaxPrice").build()}).build();
    private static final SdkField<String> SPOT_INSTANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(LaunchTemplateSpotMarketOptionsRequest.getter(LaunchTemplateSpotMarketOptionsRequest::spotInstanceTypeAsString)).setter(LaunchTemplateSpotMarketOptionsRequest.setter(Builder::spotInstanceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpotInstanceType").unmarshallLocationName("SpotInstanceType").build()}).build();
    private static final SdkField<Integer> BLOCK_DURATION_MINUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(LaunchTemplateSpotMarketOptionsRequest.getter(LaunchTemplateSpotMarketOptionsRequest::blockDurationMinutes)).setter(LaunchTemplateSpotMarketOptionsRequest.setter(Builder::blockDurationMinutes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BlockDurationMinutes").unmarshallLocationName("BlockDurationMinutes").build()}).build();
    private static final SdkField<Instant> VALID_UNTIL_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(LaunchTemplateSpotMarketOptionsRequest.getter(LaunchTemplateSpotMarketOptionsRequest::validUntil)).setter(LaunchTemplateSpotMarketOptionsRequest.setter(Builder::validUntil)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValidUntil").unmarshallLocationName("ValidUntil").build()}).build();
    private static final SdkField<String> INSTANCE_INTERRUPTION_BEHAVIOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(LaunchTemplateSpotMarketOptionsRequest.getter(LaunchTemplateSpotMarketOptionsRequest::instanceInterruptionBehaviorAsString)).setter(LaunchTemplateSpotMarketOptionsRequest.setter(Builder::instanceInterruptionBehavior)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceInterruptionBehavior").unmarshallLocationName("InstanceInterruptionBehavior").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAX_PRICE_FIELD, SPOT_INSTANCE_TYPE_FIELD, BLOCK_DURATION_MINUTES_FIELD, VALID_UNTIL_FIELD, INSTANCE_INTERRUPTION_BEHAVIOR_FIELD));
    private static final long serialVersionUID = 1L;
    private final String maxPrice;
    private final String spotInstanceType;
    private final Integer blockDurationMinutes;
    private final Instant validUntil;
    private final String instanceInterruptionBehavior;

    private LaunchTemplateSpotMarketOptionsRequest(BuilderImpl builder) {
        this.maxPrice = builder.maxPrice;
        this.spotInstanceType = builder.spotInstanceType;
        this.blockDurationMinutes = builder.blockDurationMinutes;
        this.validUntil = builder.validUntil;
        this.instanceInterruptionBehavior = builder.instanceInterruptionBehavior;
    }

    public String maxPrice() {
        return this.maxPrice;
    }

    public SpotInstanceType spotInstanceType() {
        return SpotInstanceType.fromValue(this.spotInstanceType);
    }

    public String spotInstanceTypeAsString() {
        return this.spotInstanceType;
    }

    public Integer blockDurationMinutes() {
        return this.blockDurationMinutes;
    }

    public Instant validUntil() {
        return this.validUntil;
    }

    public InstanceInterruptionBehavior instanceInterruptionBehavior() {
        return InstanceInterruptionBehavior.fromValue(this.instanceInterruptionBehavior);
    }

    public String instanceInterruptionBehaviorAsString() {
        return this.instanceInterruptionBehavior;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.maxPrice());
        hashCode = 31 * hashCode + Objects.hashCode(this.spotInstanceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.blockDurationMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(this.validUntil());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceInterruptionBehaviorAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LaunchTemplateSpotMarketOptionsRequest)) {
            return false;
        }
        LaunchTemplateSpotMarketOptionsRequest other = (LaunchTemplateSpotMarketOptionsRequest)obj;
        return Objects.equals(this.maxPrice(), other.maxPrice()) && Objects.equals(this.spotInstanceTypeAsString(), other.spotInstanceTypeAsString()) && Objects.equals(this.blockDurationMinutes(), other.blockDurationMinutes()) && Objects.equals(this.validUntil(), other.validUntil()) && Objects.equals(this.instanceInterruptionBehaviorAsString(), other.instanceInterruptionBehaviorAsString());
    }

    public String toString() {
        return ToString.builder((String)"LaunchTemplateSpotMarketOptionsRequest").add("MaxPrice", (Object)this.maxPrice()).add("SpotInstanceType", (Object)this.spotInstanceTypeAsString()).add("BlockDurationMinutes", (Object)this.blockDurationMinutes()).add("ValidUntil", (Object)this.validUntil()).add("InstanceInterruptionBehavior", (Object)this.instanceInterruptionBehaviorAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MaxPrice": {
                return Optional.ofNullable(clazz.cast(this.maxPrice()));
            }
            case "SpotInstanceType": {
                return Optional.ofNullable(clazz.cast(this.spotInstanceTypeAsString()));
            }
            case "BlockDurationMinutes": {
                return Optional.ofNullable(clazz.cast(this.blockDurationMinutes()));
            }
            case "ValidUntil": {
                return Optional.ofNullable(clazz.cast(this.validUntil()));
            }
            case "InstanceInterruptionBehavior": {
                return Optional.ofNullable(clazz.cast(this.instanceInterruptionBehaviorAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LaunchTemplateSpotMarketOptionsRequest, T> g) {
        return obj -> g.apply((LaunchTemplateSpotMarketOptionsRequest)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String maxPrice;
        private String spotInstanceType;
        private Integer blockDurationMinutes;
        private Instant validUntil;
        private String instanceInterruptionBehavior;

        private BuilderImpl() {
        }

        private BuilderImpl(LaunchTemplateSpotMarketOptionsRequest model) {
            this.maxPrice(model.maxPrice);
            this.spotInstanceType(model.spotInstanceType);
            this.blockDurationMinutes(model.blockDurationMinutes);
            this.validUntil(model.validUntil);
            this.instanceInterruptionBehavior(model.instanceInterruptionBehavior);
        }

        public final String getMaxPrice() {
            return this.maxPrice;
        }

        @Override
        public final Builder maxPrice(String maxPrice) {
            this.maxPrice = maxPrice;
            return this;
        }

        public final void setMaxPrice(String maxPrice) {
            this.maxPrice = maxPrice;
        }

        public final String getSpotInstanceTypeAsString() {
            return this.spotInstanceType;
        }

        @Override
        public final Builder spotInstanceType(String spotInstanceType) {
            this.spotInstanceType = spotInstanceType;
            return this;
        }

        @Override
        public final Builder spotInstanceType(SpotInstanceType spotInstanceType) {
            this.spotInstanceType(spotInstanceType.toString());
            return this;
        }

        public final void setSpotInstanceType(String spotInstanceType) {
            this.spotInstanceType = spotInstanceType;
        }

        public final Integer getBlockDurationMinutes() {
            return this.blockDurationMinutes;
        }

        @Override
        public final Builder blockDurationMinutes(Integer blockDurationMinutes) {
            this.blockDurationMinutes = blockDurationMinutes;
            return this;
        }

        public final void setBlockDurationMinutes(Integer blockDurationMinutes) {
            this.blockDurationMinutes = blockDurationMinutes;
        }

        public final Instant getValidUntil() {
            return this.validUntil;
        }

        @Override
        public final Builder validUntil(Instant validUntil) {
            this.validUntil = validUntil;
            return this;
        }

        public final void setValidUntil(Instant validUntil) {
            this.validUntil = validUntil;
        }

        public final String getInstanceInterruptionBehaviorAsString() {
            return this.instanceInterruptionBehavior;
        }

        @Override
        public final Builder instanceInterruptionBehavior(String instanceInterruptionBehavior) {
            this.instanceInterruptionBehavior = instanceInterruptionBehavior;
            return this;
        }

        @Override
        public final Builder instanceInterruptionBehavior(InstanceInterruptionBehavior instanceInterruptionBehavior) {
            this.instanceInterruptionBehavior(instanceInterruptionBehavior.toString());
            return this;
        }

        public final void setInstanceInterruptionBehavior(String instanceInterruptionBehavior) {
            this.instanceInterruptionBehavior = instanceInterruptionBehavior;
        }

        public LaunchTemplateSpotMarketOptionsRequest build() {
            return new LaunchTemplateSpotMarketOptionsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LaunchTemplateSpotMarketOptionsRequest> {
        public Builder maxPrice(String var1);

        public Builder spotInstanceType(String var1);

        public Builder spotInstanceType(SpotInstanceType var1);

        public Builder blockDurationMinutes(Integer var1);

        public Builder validUntil(Instant var1);

        public Builder instanceInterruptionBehavior(String var1);

        public Builder instanceInterruptionBehavior(InstanceInterruptionBehavior var1);
    }
}

