/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.ProductCodeValues;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ProductCode
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ProductCode> {
    private static final SdkField<String> PRODUCT_CODE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ProductCode.getter(ProductCode::productCodeId)).setter(ProductCode.setter(Builder::productCodeId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductCode").unmarshallLocationName("productCode").build()}).build();
    private static final SdkField<String> PRODUCT_CODE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ProductCode.getter(ProductCode::productCodeTypeAsString)).setter(ProductCode.setter(Builder::productCodeType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").unmarshallLocationName("type").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRODUCT_CODE_ID_FIELD, PRODUCT_CODE_TYPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String productCodeId;
    private final String productCodeType;

    private ProductCode(BuilderImpl builder) {
        this.productCodeId = builder.productCodeId;
        this.productCodeType = builder.productCodeType;
    }

    public String productCodeId() {
        return this.productCodeId;
    }

    public ProductCodeValues productCodeType() {
        return ProductCodeValues.fromValue(this.productCodeType);
    }

    public String productCodeTypeAsString() {
        return this.productCodeType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.productCodeId());
        hashCode = 31 * hashCode + Objects.hashCode(this.productCodeTypeAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProductCode)) {
            return false;
        }
        ProductCode other = (ProductCode)obj;
        return Objects.equals(this.productCodeId(), other.productCodeId()) && Objects.equals(this.productCodeTypeAsString(), other.productCodeTypeAsString());
    }

    public String toString() {
        return ToString.builder((String)"ProductCode").add("ProductCodeId", (Object)this.productCodeId()).add("ProductCodeType", (Object)this.productCodeTypeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ProductCodeId": {
                return Optional.ofNullable(clazz.cast(this.productCodeId()));
            }
            case "ProductCodeType": {
                return Optional.ofNullable(clazz.cast(this.productCodeTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ProductCode, T> g) {
        return obj -> g.apply((ProductCode)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String productCodeId;
        private String productCodeType;

        private BuilderImpl() {
        }

        private BuilderImpl(ProductCode model) {
            this.productCodeId(model.productCodeId);
            this.productCodeType(model.productCodeType);
        }

        public final String getProductCodeId() {
            return this.productCodeId;
        }

        @Override
        public final Builder productCodeId(String productCodeId) {
            this.productCodeId = productCodeId;
            return this;
        }

        public final void setProductCodeId(String productCodeId) {
            this.productCodeId = productCodeId;
        }

        public final String getProductCodeTypeAsString() {
            return this.productCodeType;
        }

        @Override
        public final Builder productCodeType(String productCodeType) {
            this.productCodeType = productCodeType;
            return this;
        }

        @Override
        public final Builder productCodeType(ProductCodeValues productCodeType) {
            this.productCodeType(productCodeType.toString());
            return this;
        }

        public final void setProductCodeType(String productCodeType) {
            this.productCodeType = productCodeType;
        }

        public ProductCode build() {
            return new ProductCode(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ProductCode> {
        public Builder productCodeId(String var1);

        public Builder productCodeType(String var1);

        public Builder productCodeType(ProductCodeValues var1);
    }
}

