/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ByoipCidrState {
    ADVERTISED("advertised"),
    DEPROVISIONED("deprovisioned"),
    FAILED_DEPROVISION("failed-deprovision"),
    FAILED_PROVISION("failed-provision"),
    PENDING_ADVERTISING("pending-advertising"),
    PENDING_DEPROVISION("pending-deprovision"),
    PENDING_PROVISION("pending-provision"),
    PENDING_WITHDRAWAL("pending-withdrawal"),
    PROVISIONED("provisioned"),
    PROVISIONED_NOT_PUBLICLY_ADVERTISABLE("provisioned-not-publicly-advertisable"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ByoipCidrState> VALUE_MAP;
    private final String value;

    private ByoipCidrState(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ByoipCidrState fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ByoipCidrState> knownValues() {
        EnumSet<ByoipCidrState> knownValues = EnumSet.allOf(ByoipCidrState.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ByoipCidrState.class, ByoipCidrState::toString);
    }
}

