/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2AsyncClient;
import software.amazon.awssdk.services.ec2.internal.UserAgentUtils;
import software.amazon.awssdk.services.ec2.model.ListSnapshotsInRecycleBinRequest;
import software.amazon.awssdk.services.ec2.model.ListSnapshotsInRecycleBinResponse;
import software.amazon.awssdk.services.ec2.model.SnapshotRecycleBinInfo;

public class ListSnapshotsInRecycleBinPublisher
implements SdkPublisher<ListSnapshotsInRecycleBinResponse> {
    private final Ec2AsyncClient client;
    private final ListSnapshotsInRecycleBinRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListSnapshotsInRecycleBinPublisher(Ec2AsyncClient client, ListSnapshotsInRecycleBinRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListSnapshotsInRecycleBinPublisher(Ec2AsyncClient client, ListSnapshotsInRecycleBinRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListSnapshotsInRecycleBinResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListSnapshotsInRecycleBinResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<SnapshotRecycleBinInfo> snapshots() {
        return this.flatMapIterable(response -> response.snapshots());
    }

    private class ListSnapshotsInRecycleBinResponseFetcher
    implements AsyncPageFetcher<ListSnapshotsInRecycleBinResponse> {
        private ListSnapshotsInRecycleBinResponseFetcher() {
        }

        public boolean hasNextPage(ListSnapshotsInRecycleBinResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListSnapshotsInRecycleBinResponse> nextPage(ListSnapshotsInRecycleBinResponse previousPage) {
            if (previousPage == null) {
                return ListSnapshotsInRecycleBinPublisher.this.client.listSnapshotsInRecycleBin(ListSnapshotsInRecycleBinPublisher.this.firstRequest);
            }
            return ListSnapshotsInRecycleBinPublisher.this.client.listSnapshotsInRecycleBin((ListSnapshotsInRecycleBinRequest)((Object)ListSnapshotsInRecycleBinPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

