/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2AsyncClient;
import software.amazon.awssdk.services.ec2.internal.UserAgentUtils;
import software.amazon.awssdk.services.ec2.model.ClientVpnEndpoint;
import software.amazon.awssdk.services.ec2.model.DescribeClientVpnEndpointsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeClientVpnEndpointsResponse;

public class DescribeClientVpnEndpointsPublisher
implements SdkPublisher<DescribeClientVpnEndpointsResponse> {
    private final Ec2AsyncClient client;
    private final DescribeClientVpnEndpointsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeClientVpnEndpointsPublisher(Ec2AsyncClient client, DescribeClientVpnEndpointsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeClientVpnEndpointsPublisher(Ec2AsyncClient client, DescribeClientVpnEndpointsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeClientVpnEndpointsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeClientVpnEndpointsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ClientVpnEndpoint> clientVpnEndpoints() {
        return this.flatMapIterable(response -> response.clientVpnEndpoints());
    }

    private class DescribeClientVpnEndpointsResponseFetcher
    implements AsyncPageFetcher<DescribeClientVpnEndpointsResponse> {
        private DescribeClientVpnEndpointsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeClientVpnEndpointsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeClientVpnEndpointsResponse> nextPage(DescribeClientVpnEndpointsResponse previousPage) {
            if (previousPage == null) {
                return DescribeClientVpnEndpointsPublisher.this.client.describeClientVpnEndpoints(DescribeClientVpnEndpointsPublisher.this.firstRequest);
            }
            return DescribeClientVpnEndpointsPublisher.this.client.describeClientVpnEndpoints((DescribeClientVpnEndpointsRequest)((Object)DescribeClientVpnEndpointsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

