/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2AsyncClient;
import software.amazon.awssdk.services.ec2.internal.UserAgentUtils;
import software.amazon.awssdk.services.ec2.model.DescribeVpcEndpointServiceConfigurationsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeVpcEndpointServiceConfigurationsResponse;
import software.amazon.awssdk.services.ec2.model.ServiceConfiguration;

public class DescribeVpcEndpointServiceConfigurationsPublisher
implements SdkPublisher<DescribeVpcEndpointServiceConfigurationsResponse> {
    private final Ec2AsyncClient client;
    private final DescribeVpcEndpointServiceConfigurationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeVpcEndpointServiceConfigurationsPublisher(Ec2AsyncClient client, DescribeVpcEndpointServiceConfigurationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeVpcEndpointServiceConfigurationsPublisher(Ec2AsyncClient client, DescribeVpcEndpointServiceConfigurationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeVpcEndpointServiceConfigurationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeVpcEndpointServiceConfigurationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ServiceConfiguration> serviceConfigurations() {
        return this.flatMapIterable(response -> response.serviceConfigurations());
    }

    private class DescribeVpcEndpointServiceConfigurationsResponseFetcher
    implements AsyncPageFetcher<DescribeVpcEndpointServiceConfigurationsResponse> {
        private DescribeVpcEndpointServiceConfigurationsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeVpcEndpointServiceConfigurationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeVpcEndpointServiceConfigurationsResponse> nextPage(DescribeVpcEndpointServiceConfigurationsResponse previousPage) {
            if (previousPage == null) {
                return DescribeVpcEndpointServiceConfigurationsPublisher.this.client.describeVpcEndpointServiceConfigurations(DescribeVpcEndpointServiceConfigurationsPublisher.this.firstRequest);
            }
            return DescribeVpcEndpointServiceConfigurationsPublisher.this.client.describeVpcEndpointServiceConfigurations((DescribeVpcEndpointServiceConfigurationsRequest)((Object)DescribeVpcEndpointServiceConfigurationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

