/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModifyIpamPrefixListResolverTargetRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, ModifyIpamPrefixListResolverTargetRequest> {
    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DryRun").getter(ModifyIpamPrefixListResolverTargetRequest.getter(ModifyIpamPrefixListResolverTargetRequest::dryRun)).setter(ModifyIpamPrefixListResolverTargetRequest.setter(Builder::dryRun)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun").unmarshallLocationName("DryRun").build()}).build();
    private static final SdkField<String> IPAM_PREFIX_LIST_RESOLVER_TARGET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IpamPrefixListResolverTargetId").getter(ModifyIpamPrefixListResolverTargetRequest.getter(ModifyIpamPrefixListResolverTargetRequest::ipamPrefixListResolverTargetId)).setter(ModifyIpamPrefixListResolverTargetRequest.setter(Builder::ipamPrefixListResolverTargetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpamPrefixListResolverTargetId").unmarshallLocationName("IpamPrefixListResolverTargetId").build()}).build();
    private static final SdkField<Long> DESIRED_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("DesiredVersion").getter(ModifyIpamPrefixListResolverTargetRequest.getter(ModifyIpamPrefixListResolverTargetRequest::desiredVersion)).setter(ModifyIpamPrefixListResolverTargetRequest.setter(Builder::desiredVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DesiredVersion").unmarshallLocationName("DesiredVersion").build()}).build();
    private static final SdkField<Boolean> TRACK_LATEST_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("TrackLatestVersion").getter(ModifyIpamPrefixListResolverTargetRequest.getter(ModifyIpamPrefixListResolverTargetRequest::trackLatestVersion)).setter(ModifyIpamPrefixListResolverTargetRequest.setter(Builder::trackLatestVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrackLatestVersion").unmarshallLocationName("TrackLatestVersion").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(ModifyIpamPrefixListResolverTargetRequest.getter(ModifyIpamPrefixListResolverTargetRequest::clientToken)).setter(ModifyIpamPrefixListResolverTargetRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").unmarshallLocationName("ClientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DRY_RUN_FIELD, IPAM_PREFIX_LIST_RESOLVER_TARGET_ID_FIELD, DESIRED_VERSION_FIELD, TRACK_LATEST_VERSION_FIELD, CLIENT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ModifyIpamPrefixListResolverTargetRequest.memberNameToFieldInitializer();
    private final Boolean dryRun;
    private final String ipamPrefixListResolverTargetId;
    private final Long desiredVersion;
    private final Boolean trackLatestVersion;
    private final String clientToken;

    private ModifyIpamPrefixListResolverTargetRequest(BuilderImpl builder) {
        super(builder);
        this.dryRun = builder.dryRun;
        this.ipamPrefixListResolverTargetId = builder.ipamPrefixListResolverTargetId;
        this.desiredVersion = builder.desiredVersion;
        this.trackLatestVersion = builder.trackLatestVersion;
        this.clientToken = builder.clientToken;
    }

    public final Boolean dryRun() {
        return this.dryRun;
    }

    public final String ipamPrefixListResolverTargetId() {
        return this.ipamPrefixListResolverTargetId;
    }

    public final Long desiredVersion() {
        return this.desiredVersion;
    }

    public final Boolean trackLatestVersion() {
        return this.trackLatestVersion;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.dryRun());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipamPrefixListResolverTargetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.desiredVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.trackLatestVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyIpamPrefixListResolverTargetRequest)) {
            return false;
        }
        ModifyIpamPrefixListResolverTargetRequest other = (ModifyIpamPrefixListResolverTargetRequest)((Object)obj);
        return Objects.equals(this.dryRun(), other.dryRun()) && Objects.equals(this.ipamPrefixListResolverTargetId(), other.ipamPrefixListResolverTargetId()) && Objects.equals(this.desiredVersion(), other.desiredVersion()) && Objects.equals(this.trackLatestVersion(), other.trackLatestVersion()) && Objects.equals(this.clientToken(), other.clientToken());
    }

    public final String toString() {
        return ToString.builder((String)"ModifyIpamPrefixListResolverTargetRequest").add("DryRun", (Object)this.dryRun()).add("IpamPrefixListResolverTargetId", (Object)this.ipamPrefixListResolverTargetId()).add("DesiredVersion", (Object)this.desiredVersion()).add("TrackLatestVersion", (Object)this.trackLatestVersion()).add("ClientToken", (Object)this.clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DryRun": {
                return Optional.ofNullable(clazz.cast(this.dryRun()));
            }
            case "IpamPrefixListResolverTargetId": {
                return Optional.ofNullable(clazz.cast(this.ipamPrefixListResolverTargetId()));
            }
            case "DesiredVersion": {
                return Optional.ofNullable(clazz.cast(this.desiredVersion()));
            }
            case "TrackLatestVersion": {
                return Optional.ofNullable(clazz.cast(this.trackLatestVersion()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DryRun", DRY_RUN_FIELD);
        map.put("IpamPrefixListResolverTargetId", IPAM_PREFIX_LIST_RESOLVER_TARGET_ID_FIELD);
        map.put("DesiredVersion", DESIRED_VERSION_FIELD);
        map.put("TrackLatestVersion", TRACK_LATEST_VERSION_FIELD);
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ModifyIpamPrefixListResolverTargetRequest, T> g) {
        return obj -> g.apply((ModifyIpamPrefixListResolverTargetRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private Boolean dryRun;
        private String ipamPrefixListResolverTargetId;
        private Long desiredVersion;
        private Boolean trackLatestVersion;
        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyIpamPrefixListResolverTargetRequest model) {
            super(model);
            this.dryRun(model.dryRun);
            this.ipamPrefixListResolverTargetId(model.ipamPrefixListResolverTargetId);
            this.desiredVersion(model.desiredVersion);
            this.trackLatestVersion(model.trackLatestVersion);
            this.clientToken(model.clientToken);
        }

        public final Boolean getDryRun() {
            return this.dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final String getIpamPrefixListResolverTargetId() {
            return this.ipamPrefixListResolverTargetId;
        }

        public final void setIpamPrefixListResolverTargetId(String ipamPrefixListResolverTargetId) {
            this.ipamPrefixListResolverTargetId = ipamPrefixListResolverTargetId;
        }

        @Override
        public final Builder ipamPrefixListResolverTargetId(String ipamPrefixListResolverTargetId) {
            this.ipamPrefixListResolverTargetId = ipamPrefixListResolverTargetId;
            return this;
        }

        public final Long getDesiredVersion() {
            return this.desiredVersion;
        }

        public final void setDesiredVersion(Long desiredVersion) {
            this.desiredVersion = desiredVersion;
        }

        @Override
        public final Builder desiredVersion(Long desiredVersion) {
            this.desiredVersion = desiredVersion;
            return this;
        }

        public final Boolean getTrackLatestVersion() {
            return this.trackLatestVersion;
        }

        public final void setTrackLatestVersion(Boolean trackLatestVersion) {
            this.trackLatestVersion = trackLatestVersion;
        }

        @Override
        public final Builder trackLatestVersion(Boolean trackLatestVersion) {
            this.trackLatestVersion = trackLatestVersion;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyIpamPrefixListResolverTargetRequest build() {
            return new ModifyIpamPrefixListResolverTargetRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ModifyIpamPrefixListResolverTargetRequest> {
        public Builder dryRun(Boolean var1);

        public Builder ipamPrefixListResolverTargetId(String var1);

        public Builder desiredVersion(Long var1);

        public Builder trackLatestVersion(Boolean var1);

        public Builder clientToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

