/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2AsyncClient;
import software.amazon.awssdk.services.ec2.internal.UserAgentUtils;
import software.amazon.awssdk.services.ec2.model.DescribeIpamPoolsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeIpamPoolsResponse;
import software.amazon.awssdk.services.ec2.model.IpamPool;

public class DescribeIpamPoolsPublisher
implements SdkPublisher<DescribeIpamPoolsResponse> {
    private final Ec2AsyncClient client;
    private final DescribeIpamPoolsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeIpamPoolsPublisher(Ec2AsyncClient client, DescribeIpamPoolsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeIpamPoolsPublisher(Ec2AsyncClient client, DescribeIpamPoolsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeIpamPoolsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeIpamPoolsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<IpamPool> ipamPools() {
        return this.flatMapIterable(response -> response.ipamPools());
    }

    private class DescribeIpamPoolsResponseFetcher
    implements AsyncPageFetcher<DescribeIpamPoolsResponse> {
        private DescribeIpamPoolsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeIpamPoolsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeIpamPoolsResponse> nextPage(DescribeIpamPoolsResponse previousPage) {
            if (previousPage == null) {
                return DescribeIpamPoolsPublisher.this.client.describeIpamPools(DescribeIpamPoolsPublisher.this.firstRequest);
            }
            return DescribeIpamPoolsPublisher.this.client.describeIpamPools((DescribeIpamPoolsRequest)((Object)DescribeIpamPoolsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

