/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.ImageAncestryEntry;
import software.amazon.awssdk.services.ec2.model.ImageAncestryEntryListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetImageAncestryResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, GetImageAncestryResponse> {
    private static final SdkField<List<ImageAncestryEntry>> IMAGE_ANCESTRY_ENTRIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ImageAncestryEntries").getter(GetImageAncestryResponse.getter(GetImageAncestryResponse::imageAncestryEntries)).setter(GetImageAncestryResponse.setter(Builder::imageAncestryEntries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageAncestryEntrySet").unmarshallLocationName("imageAncestryEntrySet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ImageAncestryEntry::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMAGE_ANCESTRY_ENTRIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetImageAncestryResponse.memberNameToFieldInitializer();
    private final List<ImageAncestryEntry> imageAncestryEntries;

    private GetImageAncestryResponse(BuilderImpl builder) {
        super(builder);
        this.imageAncestryEntries = builder.imageAncestryEntries;
    }

    public final boolean hasImageAncestryEntries() {
        return this.imageAncestryEntries != null && !(this.imageAncestryEntries instanceof SdkAutoConstructList);
    }

    public final List<ImageAncestryEntry> imageAncestryEntries() {
        return this.imageAncestryEntries;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasImageAncestryEntries() ? this.imageAncestryEntries() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetImageAncestryResponse)) {
            return false;
        }
        GetImageAncestryResponse other = (GetImageAncestryResponse)((Object)obj);
        return this.hasImageAncestryEntries() == other.hasImageAncestryEntries() && Objects.equals(this.imageAncestryEntries(), other.imageAncestryEntries());
    }

    public final String toString() {
        return ToString.builder((String)"GetImageAncestryResponse").add("ImageAncestryEntries", this.hasImageAncestryEntries() ? this.imageAncestryEntries() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ImageAncestryEntries": {
                return Optional.ofNullable(clazz.cast(this.imageAncestryEntries()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<ImageAncestryEntry>>> map = new HashMap<String, SdkField<List<ImageAncestryEntry>>>();
        map.put("ImageAncestryEntrySet", IMAGE_ANCESTRY_ENTRIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetImageAncestryResponse, T> g) {
        return obj -> g.apply((GetImageAncestryResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private List<ImageAncestryEntry> imageAncestryEntries = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetImageAncestryResponse model) {
            super(model);
            this.imageAncestryEntries(model.imageAncestryEntries);
        }

        public final List<ImageAncestryEntry.Builder> getImageAncestryEntries() {
            List<ImageAncestryEntry.Builder> result = ImageAncestryEntryListCopier.copyToBuilder(this.imageAncestryEntries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setImageAncestryEntries(Collection<ImageAncestryEntry.BuilderImpl> imageAncestryEntries) {
            this.imageAncestryEntries = ImageAncestryEntryListCopier.copyFromBuilder(imageAncestryEntries);
        }

        @Override
        public final Builder imageAncestryEntries(Collection<ImageAncestryEntry> imageAncestryEntries) {
            this.imageAncestryEntries = ImageAncestryEntryListCopier.copy(imageAncestryEntries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder imageAncestryEntries(ImageAncestryEntry ... imageAncestryEntries) {
            this.imageAncestryEntries(Arrays.asList(imageAncestryEntries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder imageAncestryEntries(Consumer<ImageAncestryEntry.Builder> ... imageAncestryEntries) {
            this.imageAncestryEntries(Stream.of(imageAncestryEntries).map(c -> (ImageAncestryEntry)((ImageAncestryEntry.Builder)ImageAncestryEntry.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetImageAncestryResponse build() {
            return new GetImageAncestryResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetImageAncestryResponse> {
        public Builder imageAncestryEntries(Collection<ImageAncestryEntry> var1);

        public Builder imageAncestryEntries(ImageAncestryEntry ... var1);

        public Builder imageAncestryEntries(Consumer<ImageAncestryEntry.Builder> ... var1);
    }
}

