/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ReservationState {
    ACTIVE("active"),
    EXPIRED("expired"),
    CANCELLED("cancelled"),
    SCHEDULED("scheduled"),
    PENDING("pending"),
    FAILED("failed"),
    DELAYED("delayed"),
    UNSUPPORTED("unsupported"),
    PAYMENT_PENDING("payment-pending"),
    PAYMENT_FAILED("payment-failed"),
    RETIRED("retired"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ReservationState> VALUE_MAP;
    private final String value;

    private ReservationState(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ReservationState fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ReservationState> knownValues() {
        EnumSet<ReservationState> knownValues = EnumSet.allOf(ReservationState.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ReservationState.class, ReservationState::toString);
    }
}

