/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.TagSpecification;
import software.amazon.awssdk.services.ec2.model.TagSpecificationListCopier;
import software.amazon.awssdk.services.ec2.model.TransitGatewayAttachmentIdStringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateTransitGatewayMeteringPolicyRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, CreateTransitGatewayMeteringPolicyRequest> {
    private static final SdkField<String> TRANSIT_GATEWAY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TransitGatewayId").getter(CreateTransitGatewayMeteringPolicyRequest.getter(CreateTransitGatewayMeteringPolicyRequest::transitGatewayId)).setter(CreateTransitGatewayMeteringPolicyRequest.setter(Builder::transitGatewayId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitGatewayId").unmarshallLocationName("TransitGatewayId").build()}).build();
    private static final SdkField<List<String>> MIDDLEBOX_ATTACHMENT_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("MiddleboxAttachmentIds").getter(CreateTransitGatewayMeteringPolicyRequest.getter(CreateTransitGatewayMeteringPolicyRequest::middleboxAttachmentIds)).setter(CreateTransitGatewayMeteringPolicyRequest.setter(Builder::middleboxAttachmentIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MiddleboxAttachmentId").unmarshallLocationName("MiddleboxAttachmentId").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").unmarshallLocationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<TagSpecification>> TAG_SPECIFICATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TagSpecifications").getter(CreateTransitGatewayMeteringPolicyRequest.getter(CreateTransitGatewayMeteringPolicyRequest::tagSpecifications)).setter(CreateTransitGatewayMeteringPolicyRequest.setter(Builder::tagSpecifications)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSpecifications").unmarshallLocationName("TagSpecifications").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TagSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DryRun").getter(CreateTransitGatewayMeteringPolicyRequest.getter(CreateTransitGatewayMeteringPolicyRequest::dryRun)).setter(CreateTransitGatewayMeteringPolicyRequest.setter(Builder::dryRun)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun").unmarshallLocationName("DryRun").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRANSIT_GATEWAY_ID_FIELD, MIDDLEBOX_ATTACHMENT_IDS_FIELD, TAG_SPECIFICATIONS_FIELD, DRY_RUN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateTransitGatewayMeteringPolicyRequest.memberNameToFieldInitializer();
    private final String transitGatewayId;
    private final List<String> middleboxAttachmentIds;
    private final List<TagSpecification> tagSpecifications;
    private final Boolean dryRun;

    private CreateTransitGatewayMeteringPolicyRequest(BuilderImpl builder) {
        super(builder);
        this.transitGatewayId = builder.transitGatewayId;
        this.middleboxAttachmentIds = builder.middleboxAttachmentIds;
        this.tagSpecifications = builder.tagSpecifications;
        this.dryRun = builder.dryRun;
    }

    public final String transitGatewayId() {
        return this.transitGatewayId;
    }

    public final boolean hasMiddleboxAttachmentIds() {
        return this.middleboxAttachmentIds != null && !(this.middleboxAttachmentIds instanceof SdkAutoConstructList);
    }

    public final List<String> middleboxAttachmentIds() {
        return this.middleboxAttachmentIds;
    }

    public final boolean hasTagSpecifications() {
        return this.tagSpecifications != null && !(this.tagSpecifications instanceof SdkAutoConstructList);
    }

    public final List<TagSpecification> tagSpecifications() {
        return this.tagSpecifications;
    }

    public final Boolean dryRun() {
        return this.dryRun;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.transitGatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMiddleboxAttachmentIds() ? this.middleboxAttachmentIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTagSpecifications() ? this.tagSpecifications() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.dryRun());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTransitGatewayMeteringPolicyRequest)) {
            return false;
        }
        CreateTransitGatewayMeteringPolicyRequest other = (CreateTransitGatewayMeteringPolicyRequest)((Object)obj);
        return Objects.equals(this.transitGatewayId(), other.transitGatewayId()) && this.hasMiddleboxAttachmentIds() == other.hasMiddleboxAttachmentIds() && Objects.equals(this.middleboxAttachmentIds(), other.middleboxAttachmentIds()) && this.hasTagSpecifications() == other.hasTagSpecifications() && Objects.equals(this.tagSpecifications(), other.tagSpecifications()) && Objects.equals(this.dryRun(), other.dryRun());
    }

    public final String toString() {
        return ToString.builder((String)"CreateTransitGatewayMeteringPolicyRequest").add("TransitGatewayId", (Object)this.transitGatewayId()).add("MiddleboxAttachmentIds", this.hasMiddleboxAttachmentIds() ? this.middleboxAttachmentIds() : null).add("TagSpecifications", this.hasTagSpecifications() ? this.tagSpecifications() : null).add("DryRun", (Object)this.dryRun()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TransitGatewayId": {
                return Optional.ofNullable(clazz.cast(this.transitGatewayId()));
            }
            case "MiddleboxAttachmentIds": {
                return Optional.ofNullable(clazz.cast(this.middleboxAttachmentIds()));
            }
            case "TagSpecifications": {
                return Optional.ofNullable(clazz.cast(this.tagSpecifications()));
            }
            case "DryRun": {
                return Optional.ofNullable(clazz.cast(this.dryRun()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("TransitGatewayId", TRANSIT_GATEWAY_ID_FIELD);
        map.put("MiddleboxAttachmentId", MIDDLEBOX_ATTACHMENT_IDS_FIELD);
        map.put("TagSpecifications", TAG_SPECIFICATIONS_FIELD);
        map.put("DryRun", DRY_RUN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateTransitGatewayMeteringPolicyRequest, T> g) {
        return obj -> g.apply((CreateTransitGatewayMeteringPolicyRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private String transitGatewayId;
        private List<String> middleboxAttachmentIds = DefaultSdkAutoConstructList.getInstance();
        private List<TagSpecification> tagSpecifications = DefaultSdkAutoConstructList.getInstance();
        private Boolean dryRun;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateTransitGatewayMeteringPolicyRequest model) {
            super(model);
            this.transitGatewayId(model.transitGatewayId);
            this.middleboxAttachmentIds(model.middleboxAttachmentIds);
            this.tagSpecifications(model.tagSpecifications);
            this.dryRun(model.dryRun);
        }

        public final String getTransitGatewayId() {
            return this.transitGatewayId;
        }

        public final void setTransitGatewayId(String transitGatewayId) {
            this.transitGatewayId = transitGatewayId;
        }

        @Override
        public final Builder transitGatewayId(String transitGatewayId) {
            this.transitGatewayId = transitGatewayId;
            return this;
        }

        public final Collection<String> getMiddleboxAttachmentIds() {
            if (this.middleboxAttachmentIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.middleboxAttachmentIds;
        }

        public final void setMiddleboxAttachmentIds(Collection<String> middleboxAttachmentIds) {
            this.middleboxAttachmentIds = TransitGatewayAttachmentIdStringListCopier.copy(middleboxAttachmentIds);
        }

        @Override
        public final Builder middleboxAttachmentIds(Collection<String> middleboxAttachmentIds) {
            this.middleboxAttachmentIds = TransitGatewayAttachmentIdStringListCopier.copy(middleboxAttachmentIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder middleboxAttachmentIds(String ... middleboxAttachmentIds) {
            this.middleboxAttachmentIds(Arrays.asList(middleboxAttachmentIds));
            return this;
        }

        public final List<TagSpecification.Builder> getTagSpecifications() {
            List<TagSpecification.Builder> result = TagSpecificationListCopier.copyToBuilder(this.tagSpecifications);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTagSpecifications(Collection<TagSpecification.BuilderImpl> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copyFromBuilder(tagSpecifications);
        }

        @Override
        public final Builder tagSpecifications(Collection<TagSpecification> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copy(tagSpecifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(TagSpecification ... tagSpecifications) {
            this.tagSpecifications(Arrays.asList(tagSpecifications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(Consumer<TagSpecification.Builder> ... tagSpecifications) {
            this.tagSpecifications(Stream.of(tagSpecifications).map(c -> (TagSpecification)((TagSpecification.Builder)TagSpecification.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getDryRun() {
            return this.dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateTransitGatewayMeteringPolicyRequest build() {
            return new CreateTransitGatewayMeteringPolicyRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateTransitGatewayMeteringPolicyRequest> {
        public Builder transitGatewayId(String var1);

        public Builder middleboxAttachmentIds(Collection<String> var1);

        public Builder middleboxAttachmentIds(String ... var1);

        public Builder tagSpecifications(Collection<TagSpecification> var1);

        public Builder tagSpecifications(TagSpecification ... var1);

        public Builder tagSpecifications(Consumer<TagSpecification.Builder> ... var1);

        public Builder dryRun(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

