/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A summary report for the attribute for a Region.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RegionalSummary implements SdkPojo, Serializable, ToCopyableBuilder<RegionalSummary.Builder, RegionalSummary> {
    private static final SdkField<String> REGION_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("RegionName")
            .getter(getter(RegionalSummary::regionName))
            .setter(setter(Builder::regionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegionName")
                    .unmarshallLocationName("regionName").build()).build();

    private static final SdkField<Integer> NUMBER_OF_MATCHED_ACCOUNTS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("NumberOfMatchedAccounts")
            .getter(getter(RegionalSummary::numberOfMatchedAccounts))
            .setter(setter(Builder::numberOfMatchedAccounts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfMatchedAccounts")
                    .unmarshallLocationName("numberOfMatchedAccounts").build()).build();

    private static final SdkField<Integer> NUMBER_OF_UNMATCHED_ACCOUNTS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("NumberOfUnmatchedAccounts")
            .getter(getter(RegionalSummary::numberOfUnmatchedAccounts))
            .setter(setter(Builder::numberOfUnmatchedAccounts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfUnmatchedAccounts")
                    .unmarshallLocationName("numberOfUnmatchedAccounts").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGION_NAME_FIELD,
            NUMBER_OF_MATCHED_ACCOUNTS_FIELD, NUMBER_OF_UNMATCHED_ACCOUNTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String regionName;

    private final Integer numberOfMatchedAccounts;

    private final Integer numberOfUnmatchedAccounts;

    private RegionalSummary(BuilderImpl builder) {
        this.regionName = builder.regionName;
        this.numberOfMatchedAccounts = builder.numberOfMatchedAccounts;
        this.numberOfUnmatchedAccounts = builder.numberOfUnmatchedAccounts;
    }

    /**
     * <p>
     * The Amazon Web Services Region.
     * </p>
     * 
     * @return The Amazon Web Services Region.
     */
    public final String regionName() {
        return regionName;
    }

    /**
     * <p>
     * The number of accounts in the Region with the same configuration value for the attribute that is most frequently
     * observed.
     * </p>
     * 
     * @return The number of accounts in the Region with the same configuration value for the attribute that is most
     *         frequently observed.
     */
    public final Integer numberOfMatchedAccounts() {
        return numberOfMatchedAccounts;
    }

    /**
     * <p>
     * The number of accounts in the Region with a configuration value different from the most frequently observed value
     * for the attribute.
     * </p>
     * 
     * @return The number of accounts in the Region with a configuration value different from the most frequently
     *         observed value for the attribute.
     */
    public final Integer numberOfUnmatchedAccounts() {
        return numberOfUnmatchedAccounts;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(regionName());
        hashCode = 31 * hashCode + Objects.hashCode(numberOfMatchedAccounts());
        hashCode = 31 * hashCode + Objects.hashCode(numberOfUnmatchedAccounts());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegionalSummary)) {
            return false;
        }
        RegionalSummary other = (RegionalSummary) obj;
        return Objects.equals(regionName(), other.regionName())
                && Objects.equals(numberOfMatchedAccounts(), other.numberOfMatchedAccounts())
                && Objects.equals(numberOfUnmatchedAccounts(), other.numberOfUnmatchedAccounts());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RegionalSummary").add("RegionName", regionName())
                .add("NumberOfMatchedAccounts", numberOfMatchedAccounts())
                .add("NumberOfUnmatchedAccounts", numberOfUnmatchedAccounts()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RegionName":
            return Optional.ofNullable(clazz.cast(regionName()));
        case "NumberOfMatchedAccounts":
            return Optional.ofNullable(clazz.cast(numberOfMatchedAccounts()));
        case "NumberOfUnmatchedAccounts":
            return Optional.ofNullable(clazz.cast(numberOfUnmatchedAccounts()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("RegionName", REGION_NAME_FIELD);
        map.put("NumberOfMatchedAccounts", NUMBER_OF_MATCHED_ACCOUNTS_FIELD);
        map.put("NumberOfUnmatchedAccounts", NUMBER_OF_UNMATCHED_ACCOUNTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RegionalSummary, T> g) {
        return obj -> g.apply((RegionalSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RegionalSummary> {
        /**
         * <p>
         * The Amazon Web Services Region.
         * </p>
         * 
         * @param regionName
         *        The Amazon Web Services Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder regionName(String regionName);

        /**
         * <p>
         * The number of accounts in the Region with the same configuration value for the attribute that is most
         * frequently observed.
         * </p>
         * 
         * @param numberOfMatchedAccounts
         *        The number of accounts in the Region with the same configuration value for the attribute that is most
         *        frequently observed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfMatchedAccounts(Integer numberOfMatchedAccounts);

        /**
         * <p>
         * The number of accounts in the Region with a configuration value different from the most frequently observed
         * value for the attribute.
         * </p>
         * 
         * @param numberOfUnmatchedAccounts
         *        The number of accounts in the Region with a configuration value different from the most frequently
         *        observed value for the attribute.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfUnmatchedAccounts(Integer numberOfUnmatchedAccounts);
    }

    static final class BuilderImpl implements Builder {
        private String regionName;

        private Integer numberOfMatchedAccounts;

        private Integer numberOfUnmatchedAccounts;

        private BuilderImpl() {
        }

        private BuilderImpl(RegionalSummary model) {
            regionName(model.regionName);
            numberOfMatchedAccounts(model.numberOfMatchedAccounts);
            numberOfUnmatchedAccounts(model.numberOfUnmatchedAccounts);
        }

        public final String getRegionName() {
            return regionName;
        }

        public final void setRegionName(String regionName) {
            this.regionName = regionName;
        }

        @Override
        public final Builder regionName(String regionName) {
            this.regionName = regionName;
            return this;
        }

        public final Integer getNumberOfMatchedAccounts() {
            return numberOfMatchedAccounts;
        }

        public final void setNumberOfMatchedAccounts(Integer numberOfMatchedAccounts) {
            this.numberOfMatchedAccounts = numberOfMatchedAccounts;
        }

        @Override
        public final Builder numberOfMatchedAccounts(Integer numberOfMatchedAccounts) {
            this.numberOfMatchedAccounts = numberOfMatchedAccounts;
            return this;
        }

        public final Integer getNumberOfUnmatchedAccounts() {
            return numberOfUnmatchedAccounts;
        }

        public final void setNumberOfUnmatchedAccounts(Integer numberOfUnmatchedAccounts) {
            this.numberOfUnmatchedAccounts = numberOfUnmatchedAccounts;
        }

        @Override
        public final Builder numberOfUnmatchedAccounts(Integer numberOfUnmatchedAccounts) {
            this.numberOfUnmatchedAccounts = numberOfUnmatchedAccounts;
            return this;
        }

        @Override
        public RegionalSummary build() {
            return new RegionalSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
