/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateIpamPrefixListResolverRequest extends Ec2Request implements
        ToCopyableBuilder<CreateIpamPrefixListResolverRequest.Builder, CreateIpamPrefixListResolverRequest> {
    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DryRun")
            .getter(getter(CreateIpamPrefixListResolverRequest::dryRun))
            .setter(setter(Builder::dryRun))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun")
                    .unmarshallLocationName("DryRun").build()).build();

    private static final SdkField<String> IPAM_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("IpamId")
            .getter(getter(CreateIpamPrefixListResolverRequest::ipamId))
            .setter(setter(Builder::ipamId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpamId")
                    .unmarshallLocationName("IpamId").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Description")
            .getter(getter(CreateIpamPrefixListResolverRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description")
                    .unmarshallLocationName("Description").build()).build();

    private static final SdkField<String> ADDRESS_FAMILY_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AddressFamily")
            .getter(getter(CreateIpamPrefixListResolverRequest::addressFamilyAsString))
            .setter(setter(Builder::addressFamily))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddressFamily")
                    .unmarshallLocationName("AddressFamily").build()).build();

    private static final SdkField<List<IpamPrefixListResolverRuleRequest>> RULES_FIELD = SdkField
            .<List<IpamPrefixListResolverRuleRequest>> builder(MarshallingType.LIST)
            .memberName("Rules")
            .getter(getter(CreateIpamPrefixListResolverRequest::rules))
            .setter(setter(Builder::rules))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Rule")
                    .unmarshallLocationName("Rule").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("Rule")
                            .memberFieldInfo(
                                    SdkField.<IpamPrefixListResolverRuleRequest> builder(MarshallingType.SDK_POJO)
                                            .constructor(IpamPrefixListResolverRuleRequest::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Rule").unmarshallLocationName("Rule").build()).build())
                            .build()).build();

    private static final SdkField<List<TagSpecification>> TAG_SPECIFICATIONS_FIELD = SdkField
            .<List<TagSpecification>> builder(MarshallingType.LIST)
            .memberName("TagSpecifications")
            .getter(getter(CreateIpamPrefixListResolverRequest::tagSpecifications))
            .setter(setter(Builder::tagSpecifications))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSpecification")
                    .unmarshallLocationName("TagSpecification").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<TagSpecification> builder(MarshallingType.SDK_POJO)
                                            .constructor(TagSpecification::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientToken")
            .getter(getter(CreateIpamPrefixListResolverRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken")
                    .unmarshallLocationName("ClientToken").build(), DefaultValueTrait.idempotencyToken()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DRY_RUN_FIELD, IPAM_ID_FIELD,
            DESCRIPTION_FIELD, ADDRESS_FAMILY_FIELD, RULES_FIELD, TAG_SPECIFICATIONS_FIELD, CLIENT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Boolean dryRun;

    private final String ipamId;

    private final String description;

    private final String addressFamily;

    private final List<IpamPrefixListResolverRuleRequest> rules;

    private final List<TagSpecification> tagSpecifications;

    private final String clientToken;

    private CreateIpamPrefixListResolverRequest(BuilderImpl builder) {
        super(builder);
        this.dryRun = builder.dryRun;
        this.ipamId = builder.ipamId;
        this.description = builder.description;
        this.addressFamily = builder.addressFamily;
        this.rules = builder.rules;
        this.tagSpecifications = builder.tagSpecifications;
        this.clientToken = builder.clientToken;
    }

    /**
     * <p>
     * A check for whether you have the required permissions for the action without actually making the request and
     * provides an error response. If you have the required permissions, the error response is
     * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     * </p>
     * 
     * @return A check for whether you have the required permissions for the action without actually making the request
     *         and provides an error response. If you have the required permissions, the error response is
     *         <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     */
    public final Boolean dryRun() {
        return dryRun;
    }

    /**
     * <p>
     * The ID of the IPAM that will serve as the source of the IP address database for CIDR selection. The IPAM must be
     * in the Advanced tier to use this feature.
     * </p>
     * 
     * @return The ID of the IPAM that will serve as the source of the IP address database for CIDR selection. The IPAM
     *         must be in the Advanced tier to use this feature.
     */
    public final String ipamId() {
        return ipamId;
    }

    /**
     * <p>
     * A description for the IPAM prefix list resolver to help you identify its purpose and configuration.
     * </p>
     * 
     * @return A description for the IPAM prefix list resolver to help you identify its purpose and configuration.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The address family for the IPAM prefix list resolver. Valid values are <code>ipv4</code> and <code>ipv6</code>.
     * You must create separate resolvers for IPv4 and IPv6 CIDRs as they cannot be mixed in the same resolver.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #addressFamily}
     * will return {@link AddressFamily#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #addressFamilyAsString}.
     * </p>
     * 
     * @return The address family for the IPAM prefix list resolver. Valid values are <code>ipv4</code> and
     *         <code>ipv6</code>. You must create separate resolvers for IPv4 and IPv6 CIDRs as they cannot be mixed in
     *         the same resolver.
     * @see AddressFamily
     */
    public final AddressFamily addressFamily() {
        return AddressFamily.fromValue(addressFamily);
    }

    /**
     * <p>
     * The address family for the IPAM prefix list resolver. Valid values are <code>ipv4</code> and <code>ipv6</code>.
     * You must create separate resolvers for IPv4 and IPv6 CIDRs as they cannot be mixed in the same resolver.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #addressFamily}
     * will return {@link AddressFamily#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #addressFamilyAsString}.
     * </p>
     * 
     * @return The address family for the IPAM prefix list resolver. Valid values are <code>ipv4</code> and
     *         <code>ipv6</code>. You must create separate resolvers for IPv4 and IPv6 CIDRs as they cannot be mixed in
     *         the same resolver.
     * @see AddressFamily
     */
    public final String addressFamilyAsString() {
        return addressFamily;
    }

    /**
     * For responses, this returns true if the service returned a value for the Rules property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasRules() {
        return rules != null && !(rules instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The CIDR selection rules for the resolver.
     * </p>
     * <p>
     * CIDR selection rules define the business logic for selecting CIDRs from IPAM. If a CIDR matches any of the rules,
     * it will be included. If a rule has multiple conditions, the CIDR has to match every condition of that rule. You
     * can create a prefix list resolver without any CIDR selection rules, but it will generate empty versions
     * (containing no CIDRs) until you add rules.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRules} method.
     * </p>
     * 
     * @return The CIDR selection rules for the resolver.</p>
     *         <p>
     *         CIDR selection rules define the business logic for selecting CIDRs from IPAM. If a CIDR matches any of
     *         the rules, it will be included. If a rule has multiple conditions, the CIDR has to match every condition
     *         of that rule. You can create a prefix list resolver without any CIDR selection rules, but it will
     *         generate empty versions (containing no CIDRs) until you add rules.
     */
    public final List<IpamPrefixListResolverRuleRequest> rules() {
        return rules;
    }

    /**
     * For responses, this returns true if the service returned a value for the TagSpecifications property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTagSpecifications() {
        return tagSpecifications != null && !(tagSpecifications instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tags to apply to the IPAM prefix list resolver during creation. Tags help you organize and manage your Amazon
     * Web Services resources.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTagSpecifications} method.
     * </p>
     * 
     * @return The tags to apply to the IPAM prefix list resolver during creation. Tags help you organize and manage
     *         your Amazon Web Services resources.
     */
    public final List<TagSpecification> tagSpecifications() {
        return tagSpecifications;
    }

    /**
     * <p>
     * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more
     * information, see <a href="https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html">Ensuring
     * idempotency</a>.
     * </p>
     * 
     * @return A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html">Ensuring idempotency</a>.
     */
    public final String clientToken() {
        return clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(dryRun());
        hashCode = 31 * hashCode + Objects.hashCode(ipamId());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(addressFamilyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasRules() ? rules() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTagSpecifications() ? tagSpecifications() : null);
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateIpamPrefixListResolverRequest)) {
            return false;
        }
        CreateIpamPrefixListResolverRequest other = (CreateIpamPrefixListResolverRequest) obj;
        return Objects.equals(dryRun(), other.dryRun()) && Objects.equals(ipamId(), other.ipamId())
                && Objects.equals(description(), other.description())
                && Objects.equals(addressFamilyAsString(), other.addressFamilyAsString()) && hasRules() == other.hasRules()
                && Objects.equals(rules(), other.rules()) && hasTagSpecifications() == other.hasTagSpecifications()
                && Objects.equals(tagSpecifications(), other.tagSpecifications())
                && Objects.equals(clientToken(), other.clientToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateIpamPrefixListResolverRequest").add("DryRun", dryRun()).add("IpamId", ipamId())
                .add("Description", description()).add("AddressFamily", addressFamilyAsString())
                .add("Rules", hasRules() ? rules() : null)
                .add("TagSpecifications", hasTagSpecifications() ? tagSpecifications() : null).add("ClientToken", clientToken())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DryRun":
            return Optional.ofNullable(clazz.cast(dryRun()));
        case "IpamId":
            return Optional.ofNullable(clazz.cast(ipamId()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "AddressFamily":
            return Optional.ofNullable(clazz.cast(addressFamilyAsString()));
        case "Rules":
            return Optional.ofNullable(clazz.cast(rules()));
        case "TagSpecifications":
            return Optional.ofNullable(clazz.cast(tagSpecifications()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DryRun", DRY_RUN_FIELD);
        map.put("IpamId", IPAM_ID_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("AddressFamily", ADDRESS_FAMILY_FIELD);
        map.put("Rule", RULES_FIELD);
        map.put("TagSpecification", TAG_SPECIFICATIONS_FIELD);
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateIpamPrefixListResolverRequest, T> g) {
        return obj -> g.apply((CreateIpamPrefixListResolverRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, CreateIpamPrefixListResolverRequest> {
        /**
         * <p>
         * A check for whether you have the required permissions for the action without actually making the request and
         * provides an error response. If you have the required permissions, the error response is
         * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * </p>
         * 
         * @param dryRun
         *        A check for whether you have the required permissions for the action without actually making the
         *        request and provides an error response. If you have the required permissions, the error response is
         *        <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dryRun(Boolean dryRun);

        /**
         * <p>
         * The ID of the IPAM that will serve as the source of the IP address database for CIDR selection. The IPAM must
         * be in the Advanced tier to use this feature.
         * </p>
         * 
         * @param ipamId
         *        The ID of the IPAM that will serve as the source of the IP address database for CIDR selection. The
         *        IPAM must be in the Advanced tier to use this feature.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipamId(String ipamId);

        /**
         * <p>
         * A description for the IPAM prefix list resolver to help you identify its purpose and configuration.
         * </p>
         * 
         * @param description
         *        A description for the IPAM prefix list resolver to help you identify its purpose and configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The address family for the IPAM prefix list resolver. Valid values are <code>ipv4</code> and
         * <code>ipv6</code>. You must create separate resolvers for IPv4 and IPv6 CIDRs as they cannot be mixed in the
         * same resolver.
         * </p>
         * 
         * @param addressFamily
         *        The address family for the IPAM prefix list resolver. Valid values are <code>ipv4</code> and
         *        <code>ipv6</code>. You must create separate resolvers for IPv4 and IPv6 CIDRs as they cannot be mixed
         *        in the same resolver.
         * @see AddressFamily
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AddressFamily
         */
        Builder addressFamily(String addressFamily);

        /**
         * <p>
         * The address family for the IPAM prefix list resolver. Valid values are <code>ipv4</code> and
         * <code>ipv6</code>. You must create separate resolvers for IPv4 and IPv6 CIDRs as they cannot be mixed in the
         * same resolver.
         * </p>
         * 
         * @param addressFamily
         *        The address family for the IPAM prefix list resolver. Valid values are <code>ipv4</code> and
         *        <code>ipv6</code>. You must create separate resolvers for IPv4 and IPv6 CIDRs as they cannot be mixed
         *        in the same resolver.
         * @see AddressFamily
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AddressFamily
         */
        Builder addressFamily(AddressFamily addressFamily);

        /**
         * <p>
         * The CIDR selection rules for the resolver.
         * </p>
         * <p>
         * CIDR selection rules define the business logic for selecting CIDRs from IPAM. If a CIDR matches any of the
         * rules, it will be included. If a rule has multiple conditions, the CIDR has to match every condition of that
         * rule. You can create a prefix list resolver without any CIDR selection rules, but it will generate empty
         * versions (containing no CIDRs) until you add rules.
         * </p>
         * 
         * @param rules
         *        The CIDR selection rules for the resolver.</p>
         *        <p>
         *        CIDR selection rules define the business logic for selecting CIDRs from IPAM. If a CIDR matches any of
         *        the rules, it will be included. If a rule has multiple conditions, the CIDR has to match every
         *        condition of that rule. You can create a prefix list resolver without any CIDR selection rules, but it
         *        will generate empty versions (containing no CIDRs) until you add rules.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rules(Collection<IpamPrefixListResolverRuleRequest> rules);

        /**
         * <p>
         * The CIDR selection rules for the resolver.
         * </p>
         * <p>
         * CIDR selection rules define the business logic for selecting CIDRs from IPAM. If a CIDR matches any of the
         * rules, it will be included. If a rule has multiple conditions, the CIDR has to match every condition of that
         * rule. You can create a prefix list resolver without any CIDR selection rules, but it will generate empty
         * versions (containing no CIDRs) until you add rules.
         * </p>
         * 
         * @param rules
         *        The CIDR selection rules for the resolver.</p>
         *        <p>
         *        CIDR selection rules define the business logic for selecting CIDRs from IPAM. If a CIDR matches any of
         *        the rules, it will be included. If a rule has multiple conditions, the CIDR has to match every
         *        condition of that rule. You can create a prefix list resolver without any CIDR selection rules, but it
         *        will generate empty versions (containing no CIDRs) until you add rules.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rules(IpamPrefixListResolverRuleRequest... rules);

        /**
         * <p>
         * The CIDR selection rules for the resolver.
         * </p>
         * <p>
         * CIDR selection rules define the business logic for selecting CIDRs from IPAM. If a CIDR matches any of the
         * rules, it will be included. If a rule has multiple conditions, the CIDR has to match every condition of that
         * rule. You can create a prefix list resolver without any CIDR selection rules, but it will generate empty
         * versions (containing no CIDRs) until you add rules.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.IpamPrefixListResolverRuleRequest.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.ec2.model.IpamPrefixListResolverRuleRequest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.IpamPrefixListResolverRuleRequest.Builder#build()} is called
         * immediately and its result is passed to {@link #rules(List<IpamPrefixListResolverRuleRequest>)}.
         * 
         * @param rules
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.IpamPrefixListResolverRuleRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rules(java.util.Collection<IpamPrefixListResolverRuleRequest>)
         */
        Builder rules(Consumer<IpamPrefixListResolverRuleRequest.Builder>... rules);

        /**
         * <p>
         * The tags to apply to the IPAM prefix list resolver during creation. Tags help you organize and manage your
         * Amazon Web Services resources.
         * </p>
         * 
         * @param tagSpecifications
         *        The tags to apply to the IPAM prefix list resolver during creation. Tags help you organize and manage
         *        your Amazon Web Services resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagSpecifications(Collection<TagSpecification> tagSpecifications);

        /**
         * <p>
         * The tags to apply to the IPAM prefix list resolver during creation. Tags help you organize and manage your
         * Amazon Web Services resources.
         * </p>
         * 
         * @param tagSpecifications
         *        The tags to apply to the IPAM prefix list resolver during creation. Tags help you organize and manage
         *        your Amazon Web Services resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagSpecifications(TagSpecification... tagSpecifications);

        /**
         * <p>
         * The tags to apply to the IPAM prefix list resolver during creation. Tags help you organize and manage your
         * Amazon Web Services resources.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.TagSpecification.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.ec2.model.TagSpecification#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.TagSpecification.Builder#build()} is called immediately and
         * its result is passed to {@link #tagSpecifications(List<TagSpecification>)}.
         * 
         * @param tagSpecifications
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.TagSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tagSpecifications(java.util.Collection<TagSpecification>)
         */
        Builder tagSpecifications(Consumer<TagSpecification.Builder>... tagSpecifications);

        /**
         * <p>
         * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more
         * information, see <a href="https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html">Ensuring
         * idempotency</a>.
         * </p>
         * 
         * @param clientToken
         *        A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For
         *        more information, see <a
         *        href="https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html">Ensuring
         *        idempotency</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private Boolean dryRun;

        private String ipamId;

        private String description;

        private String addressFamily;

        private List<IpamPrefixListResolverRuleRequest> rules = DefaultSdkAutoConstructList.getInstance();

        private List<TagSpecification> tagSpecifications = DefaultSdkAutoConstructList.getInstance();

        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateIpamPrefixListResolverRequest model) {
            super(model);
            dryRun(model.dryRun);
            ipamId(model.ipamId);
            description(model.description);
            addressFamily(model.addressFamily);
            rules(model.rules);
            tagSpecifications(model.tagSpecifications);
            clientToken(model.clientToken);
        }

        public final Boolean getDryRun() {
            return dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final String getIpamId() {
            return ipamId;
        }

        public final void setIpamId(String ipamId) {
            this.ipamId = ipamId;
        }

        @Override
        public final Builder ipamId(String ipamId) {
            this.ipamId = ipamId;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getAddressFamily() {
            return addressFamily;
        }

        public final void setAddressFamily(String addressFamily) {
            this.addressFamily = addressFamily;
        }

        @Override
        public final Builder addressFamily(String addressFamily) {
            this.addressFamily = addressFamily;
            return this;
        }

        @Override
        public final Builder addressFamily(AddressFamily addressFamily) {
            this.addressFamily(addressFamily == null ? null : addressFamily.toString());
            return this;
        }

        public final List<IpamPrefixListResolverRuleRequest.Builder> getRules() {
            List<IpamPrefixListResolverRuleRequest.Builder> result = IpamPrefixListResolverRuleRequestSetCopier
                    .copyToBuilder(this.rules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRules(Collection<IpamPrefixListResolverRuleRequest.BuilderImpl> rules) {
            this.rules = IpamPrefixListResolverRuleRequestSetCopier.copyFromBuilder(rules);
        }

        @Override
        public final Builder rules(Collection<IpamPrefixListResolverRuleRequest> rules) {
            this.rules = IpamPrefixListResolverRuleRequestSetCopier.copy(rules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rules(IpamPrefixListResolverRuleRequest... rules) {
            rules(Arrays.asList(rules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rules(Consumer<IpamPrefixListResolverRuleRequest.Builder>... rules) {
            rules(Stream.of(rules).map(c -> IpamPrefixListResolverRuleRequest.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<TagSpecification.Builder> getTagSpecifications() {
            List<TagSpecification.Builder> result = TagSpecificationListCopier.copyToBuilder(this.tagSpecifications);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTagSpecifications(Collection<TagSpecification.BuilderImpl> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copyFromBuilder(tagSpecifications);
        }

        @Override
        public final Builder tagSpecifications(Collection<TagSpecification> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copy(tagSpecifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(TagSpecification... tagSpecifications) {
            tagSpecifications(Arrays.asList(tagSpecifications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(Consumer<TagSpecification.Builder>... tagSpecifications) {
            tagSpecifications(Stream.of(tagSpecifications).map(c -> TagSpecification.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateIpamPrefixListResolverRequest build() {
            return new CreateIpamPrefixListResolverRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
