/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2AsyncClient;
import software.amazon.awssdk.services.ec2.internal.UserAgentUtils;
import software.amazon.awssdk.services.ec2.model.DescribeVpnConcentratorsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeVpnConcentratorsResponse;
import software.amazon.awssdk.services.ec2.model.VpnConcentrator;

public class DescribeVpnConcentratorsPublisher
implements SdkPublisher<DescribeVpnConcentratorsResponse> {
    private final Ec2AsyncClient client;
    private final DescribeVpnConcentratorsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeVpnConcentratorsPublisher(Ec2AsyncClient client, DescribeVpnConcentratorsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeVpnConcentratorsPublisher(Ec2AsyncClient client, DescribeVpnConcentratorsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeVpnConcentratorsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeVpnConcentratorsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<VpnConcentrator> vpnConcentrators() {
        Function<DescribeVpnConcentratorsResponse, Iterator> getIterator = response -> {
            if (response != null && response.vpnConcentrators() != null) {
                return response.vpnConcentrators().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeVpnConcentratorsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeVpnConcentratorsResponseFetcher
    implements AsyncPageFetcher<DescribeVpnConcentratorsResponse> {
        private DescribeVpnConcentratorsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeVpnConcentratorsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeVpnConcentratorsResponse> nextPage(DescribeVpnConcentratorsResponse previousPage) {
            if (previousPage == null) {
                return DescribeVpnConcentratorsPublisher.this.client.describeVpnConcentrators(DescribeVpnConcentratorsPublisher.this.firstRequest);
            }
            return DescribeVpnConcentratorsPublisher.this.client.describeVpnConcentrators((DescribeVpnConcentratorsRequest)((Object)DescribeVpnConcentratorsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

